/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.metric.source;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.pipe.extractor.dataregion.IoTDBDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.epoch.TsFileEpoch;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeDataRegionExtractorMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeDataRegionExtractorMetrics.class);
    private volatile AbstractMetricService metricService;
    private final Map<String, IoTDBDataRegionExtractor> extractorMap = new ConcurrentHashMap<String, IoTDBDataRegionExtractor>();
    private final Map<String, Rate> tabletRateMap = new ConcurrentHashMap<String, Rate>();
    private final Map<String, Rate> tsFileRateMap = new ConcurrentHashMap<String, Rate>();
    private final Map<String, Rate> pipeHeartbeatRateMap = new ConcurrentHashMap<String, Rate>();
    private final Map<String, Gauge> recentProcessedTsFileEpochStateMap = new ConcurrentHashMap<String, Gauge>();

    public Map<String, IoTDBDataRegionExtractor> getExtractorMap() {
        return this.extractorMap;
    }

    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        ImmutableSet taskIDs = ImmutableSet.copyOf(this.extractorMap.keySet());
        for (String taskID : taskIDs) {
            this.createMetrics(taskID);
        }
    }

    private void createMetrics(String taskID) {
        this.createAutoGauge(taskID);
        this.createRate(taskID);
        this.createGauge(taskID);
    }

    private void createAutoGauge(String taskID) {
        IoTDBDataRegionExtractor extractor = this.extractorMap.get(taskID);
        this.metricService.createAutoGauge(Metric.UNPROCESSED_HISTORICAL_TSFILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)extractor, IoTDBDataRegionExtractor::getHistoricalTsFileInsertionEventCount, new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
        this.metricService.createAutoGauge(Metric.UNPROCESSED_REALTIME_TSFILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)extractor, IoTDBDataRegionExtractor::getRealtimeTsFileInsertionEventCount, new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
        this.metricService.createAutoGauge(Metric.UNPROCESSED_TABLET_COUNT.toString(), MetricLevel.IMPORTANT, (Object)extractor, IoTDBDataRegionExtractor::getTabletInsertionEventCount, new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
        this.metricService.createAutoGauge(Metric.UNPROCESSED_HEARTBEAT_COUNT.toString(), MetricLevel.IMPORTANT, (Object)extractor, IoTDBDataRegionExtractor::getPipeHeartbeatEventCount, new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
    }

    private void createRate(String taskID) {
        IoTDBDataRegionExtractor extractor = this.extractorMap.get(taskID);
        this.tabletRateMap.put(taskID, this.metricService.getOrCreateRate(Metric.PIPE_EXTRACTOR_TABLET_SUPPLY.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())}));
        this.tsFileRateMap.put(taskID, this.metricService.getOrCreateRate(Metric.PIPE_EXTRACTOR_TSFILE_SUPPLY.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())}));
        this.pipeHeartbeatRateMap.put(taskID, this.metricService.getOrCreateRate(Metric.PIPE_EXTRACTOR_HEARTBEAT_SUPPLY.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())}));
    }

    private void createGauge(String taskID) {
        IoTDBDataRegionExtractor extractor = this.extractorMap.get(taskID);
        this.recentProcessedTsFileEpochStateMap.put(taskID, this.metricService.getOrCreateGauge(Metric.PIPE_EXTRACTOR_TSFILE_EPOCH_STATE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())}));
    }

    public void unbindFrom(AbstractMetricService metricService) {
        ImmutableSet taskIDs = ImmutableSet.copyOf(this.extractorMap.keySet());
        for (String taskID : taskIDs) {
            this.deregister(taskID);
        }
        if (!this.extractorMap.isEmpty()) {
            LOGGER.warn("Failed to unbind from pipe extractor metrics, extractor map not empty");
        }
    }

    private void removeMetrics(String taskID) {
        this.removeAutoGauge(taskID);
        this.removeRate(taskID);
        this.removeGauge(taskID);
    }

    private void removeAutoGauge(String taskID) {
        IoTDBDataRegionExtractor extractor = this.extractorMap.get(taskID);
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.UNPROCESSED_HISTORICAL_TSFILE_COUNT.toString(), new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.UNPROCESSED_REALTIME_TSFILE_COUNT.toString(), new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.UNPROCESSED_TABLET_COUNT.toString(), new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.UNPROCESSED_HEARTBEAT_COUNT.toString(), new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
    }

    private void removeRate(String taskID) {
        IoTDBDataRegionExtractor extractor = this.extractorMap.get(taskID);
        this.metricService.remove(MetricType.RATE, Metric.PIPE_EXTRACTOR_TABLET_SUPPLY.toString(), new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
        this.metricService.remove(MetricType.RATE, Metric.PIPE_EXTRACTOR_TSFILE_SUPPLY.toString(), new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
        this.metricService.remove(MetricType.RATE, Metric.PIPE_EXTRACTOR_HEARTBEAT_SUPPLY.toString(), new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
        this.tabletRateMap.remove(taskID);
        this.tsFileRateMap.remove(taskID);
        this.pipeHeartbeatRateMap.remove(taskID);
    }

    private void removeGauge(String taskID) {
        IoTDBDataRegionExtractor extractor = this.extractorMap.get(taskID);
        this.metricService.remove(MetricType.GAUGE, Metric.PIPE_EXTRACTOR_TSFILE_EPOCH_STATE.toString(), new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
    }

    public void register(@NonNull IoTDBDataRegionExtractor extractor) {
        String taskID = extractor.getTaskID();
        this.extractorMap.putIfAbsent(taskID, extractor);
        if (Objects.nonNull(this.metricService)) {
            this.createMetrics(taskID);
        }
    }

    public void deregister(String taskID) {
        if (!this.extractorMap.containsKey(taskID)) {
            LOGGER.warn("Failed to deregister pipe data region extractor metrics, IoTDBDataRegionExtractor({}) does not exist", (Object)taskID);
            return;
        }
        if (Objects.nonNull(this.metricService)) {
            this.removeMetrics(taskID);
        }
        this.extractorMap.remove(taskID);
    }

    public void markTabletEvent(String taskID) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        Rate rate = this.tabletRateMap.get(taskID);
        if (rate == null) {
            LOGGER.info("Failed to mark pipe data region extractor tablet event, IoTDBDataRegionExtractor({}) does not exist", (Object)taskID);
            return;
        }
        rate.mark();
    }

    public void markTsFileEvent(String taskID) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        Rate rate = this.tsFileRateMap.get(taskID);
        if (rate == null) {
            LOGGER.info("Failed to mark pipe data region extractor tsfile event, IoTDBDataRegionExtractor({}) does not exist", (Object)taskID);
            return;
        }
        rate.mark();
    }

    public void markPipeHeartbeatEvent(String taskID) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        Rate rate = this.pipeHeartbeatRateMap.get(taskID);
        if (rate == null) {
            LOGGER.info("Failed to mark pipe data region extractor heartbeat event, IoTDBDataRegionExtractor({}) does not exist", (Object)taskID);
            return;
        }
        rate.mark();
    }

    public void setRecentProcessedTsFileEpochState(String taskID, TsFileEpoch.State state) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        Gauge gauge = this.recentProcessedTsFileEpochStateMap.get(taskID);
        if (gauge == null) {
            LOGGER.info("Failed to set recent processed tsfile epoch state, PipeRealtimeDataRegionExtractor({}) does not exist", (Object)taskID);
            return;
        }
        gauge.set((long)state.getId());
    }

    public static PipeDataRegionExtractorMetrics getInstance() {
        return PipeExtractorMetricsHolder.INSTANCE;
    }

    private PipeDataRegionExtractorMetrics() {
    }

    private static class PipeExtractorMetricsHolder {
        private static final PipeDataRegionExtractorMetrics INSTANCE = new PipeDataRegionExtractorMetrics();

        private PipeExtractorMetricsHolder() {
        }
    }
}

