/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.services;

import java.util.List;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.services.MethodServices;
import org.eclipse.milo.opcua.sdk.server.services.ServiceAttributes;
import org.eclipse.milo.opcua.sdk.server.services.ServiceCounter;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodResult;
import org.eclipse.milo.opcua.stack.core.types.structured.CallRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.server.services.MethodServiceSet;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;

public class DefaultMethodServiceSet
implements MethodServiceSet {
    private final ServiceCounter callCounter = new ServiceCounter();

    public void onCall(ServiceRequest service) {
        this.callCounter.record(service);
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        CallRequest request = (CallRequest)service.getRequest();
        List methodsToCall = ConversionUtil.l((Object[])request.getMethodsToCall());
        if (methodsToCall.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        if ((long)methodsToCall.size() > server.getConfig().getLimits().getMaxNodesPerMethodCall().longValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        DiagnosticsContext<CallMethodRequest> diagnosticsContext = new DiagnosticsContext<CallMethodRequest>();
        MethodServices.CallContext context = new MethodServices.CallContext(server, session, diagnosticsContext);
        server.getAddressSpaceManager().call(context, methodsToCall);
        context.getFuture().thenAccept(values -> {
            ResponseHeader header = service.createResponseHeader();
            CallResponse response = new CallResponse(header, (CallMethodResult[])ConversionUtil.a((List)values, CallMethodResult.class), new DiagnosticInfo[0]);
            service.setResponse((UaResponseMessage)response);
        });
    }
}

