/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.component;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;

public class IntoItem
extends StatementNode {
    private final PartialPath intoDevice;
    private final List<String> intoMeasurements;
    private final boolean isAligned;

    public IntoItem(PartialPath intoDevice, List<String> intoMeasurements, boolean isAligned) {
        this.intoDevice = intoDevice;
        this.intoMeasurements = intoMeasurements;
        this.isAligned = isAligned;
    }

    public PartialPath getIntoDevice() {
        return this.intoDevice;
    }

    public List<String> getIntoMeasurements() {
        return this.intoMeasurements;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public boolean isDeviceExistPlaceholder() {
        return this.intoDevice.containNode("::") || IoTDBConstant.LEVELED_PATH_TEMPLATE_PATTERN.matcher(this.intoDevice.getFullPath()).find();
    }

    public boolean isMeasurementsExistPlaceholder() {
        for (String measurement : this.intoMeasurements) {
            if (!measurement.equals("::") && !IoTDBConstant.LEVELED_PATH_TEMPLATE_PATTERN.matcher(measurement).find()) continue;
            return true;
        }
        return false;
    }

    public List<PartialPath> getIntoPaths() {
        return this.intoMeasurements.stream().map(arg_0 -> ((PartialPath)this.intoDevice).concatNode(arg_0)).collect(Collectors.toList());
    }

    public String toSQLString() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(this.intoDevice);
        sqlBuilder.append('(');
        for (int i = 0; i < this.intoMeasurements.size(); ++i) {
            sqlBuilder.append(this.intoMeasurements.get(i));
            if (i >= this.intoMeasurements.size() - 1) continue;
            sqlBuilder.append(',').append(" ");
        }
        sqlBuilder.append(')');
        return sqlBuilder.toString();
    }
}

