/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;
import reactor.core.scheduler.NonBlocking;
import reactor.core.scheduler.Schedulers;

public final class ReactorBlockHoundIntegration
implements BlockHoundIntegration {
    public void applyTo(BlockHound.Builder builder) {
        builder.nonBlockingThreadPredicate(current -> current.or(NonBlocking.class::isInstance));
        builder.allowBlockingCallsInside("java.util.concurrent.ScheduledThreadPoolExecutor$DelayedWorkQueue", "offer");
        builder.allowBlockingCallsInside(ScheduledThreadPoolExecutor.class.getName() + "$DelayedWorkQueue", "take");
        Schedulers.onScheduleHook("BlockHound", Wrapper::new);
        builder.disallowBlockingCallsInside(Wrapper.class.getName(), "run");
    }

    static final class Wrapper
    implements Runnable {
        final Runnable delegate;

        Wrapper(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            this.delegate.run();
        }
    }
}

