/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.filtering.impl;

import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.filtering.FilteringManagement;
import org.apache.james.jmap.api.filtering.Version;
import org.apache.james.user.api.UsernameChangeTaskStep;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class FilterUsernameChangeTaskStep
implements UsernameChangeTaskStep {
    public static final Optional<Version> NO_VERSION = Optional.empty();
    private final FilteringManagement filteringManagement;

    @Inject
    public FilterUsernameChangeTaskStep(FilteringManagement filteringManagement) {
        this.filteringManagement = filteringManagement;
    }

    public UsernameChangeTaskStep.StepName name() {
        return new UsernameChangeTaskStep.StepName("FilterUsernameChangeTaskStep");
    }

    public int priority() {
        return 4;
    }

    public Publisher<Void> changeUsername(Username oldUsername, Username newUsername) {
        return Mono.from(this.filteringManagement.listRulesForUser(oldUsername)).filter(rules -> !rules.getRules().isEmpty()).flatMap(rules -> Mono.from(this.filteringManagement.defineRulesForUser(newUsername, rules.getRules(), NO_VERSION)).then(Mono.from(this.filteringManagement.clearRulesForUser(oldUsername)))).then();
    }
}

