/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.http;

import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.ribbon.CacheProvider;
import com.netflix.ribbon.RequestTemplate;
import com.netflix.ribbon.ResourceGroup;
import com.netflix.ribbon.ResponseValidator;
import com.netflix.ribbon.http.HttpRequestBuilder;
import com.netflix.ribbon.http.HttpResourceGroup;
import com.netflix.ribbon.hystrix.FallbackHandler;
import com.netflix.ribbon.template.ParsedTemplate;
import com.netflix.ribbon.transport.netty.LoadBalancingRxClient;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import java.util.HashMap;
import java.util.Map;

public class HttpRequestTemplate<T>
extends RequestTemplate<T, HttpClientResponse<ByteBuf>> {
    public static final String CACHE_HYSTRIX_COMMAND_SUFFIX = "_cache";
    public static final int DEFAULT_CACHE_TIMEOUT = 20;
    private final HttpClient<ByteBuf, ByteBuf> client;
    private final int maxResponseTime;
    private final HystrixObservableCommand.Setter setter;
    private final HystrixObservableCommand.Setter cacheSetter;
    private final FallbackHandler<T> fallbackHandler;
    private final ParsedTemplate parsedUriTemplate;
    private final ResponseValidator<HttpClientResponse<ByteBuf>> validator;
    private final HttpMethod method;
    private final String name;
    private final CacheProviderWithKeyTemplate<T> cacheProvider;
    private final ParsedTemplate hystrixCacheKeyTemplate;
    private final Class<? extends T> classType;
    private final int concurrentRequestLimit;
    private final HttpHeaders headers;
    private final HttpResourceGroup group;

    protected HttpRequestTemplate(String name, HttpResourceGroup group, Class<? extends T> classType, HystrixObservableCommand.Setter setter, HttpMethod method, HttpHeaders headers, ParsedTemplate uriTemplate, FallbackHandler<T> fallbackHandler, ResponseValidator<HttpClientResponse<ByteBuf>> validator, CacheProviderWithKeyTemplate<T> cacheProvider, ParsedTemplate hystrixCacheKeyTemplate) {
        this.group = group;
        this.name = name;
        this.classType = classType;
        this.method = method;
        this.parsedUriTemplate = uriTemplate;
        this.fallbackHandler = fallbackHandler;
        this.validator = validator;
        this.cacheProvider = cacheProvider;
        this.hystrixCacheKeyTemplate = hystrixCacheKeyTemplate;
        this.client = group.getClient();
        this.headers = headers;
        if (this.client instanceof LoadBalancingRxClient) {
            LoadBalancingRxClient ribbonClient = (LoadBalancingRxClient)this.client;
            this.maxResponseTime = ribbonClient.getResponseTimeOut();
            this.concurrentRequestLimit = ribbonClient.getMaxConcurrentRequests();
        } else {
            this.maxResponseTime = -1;
            this.concurrentRequestLimit = -1;
        }
        String cacheName = name + CACHE_HYSTRIX_COMMAND_SUFFIX;
        this.cacheSetter = HystrixObservableCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)cacheName)).andCommandKey(HystrixCommandKey.Factory.asKey((String)cacheName));
        HystrixCommandProperties.Setter cacheCommandProps = HystrixCommandProperties.Setter();
        cacheCommandProps.withExecutionIsolationThreadTimeoutInMilliseconds(20);
        this.cacheSetter.andCommandPropertiesDefaults(cacheCommandProps);
        if (setter != null) {
            this.setter = setter;
        } else {
            this.setter = HystrixObservableCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)this.client.name())).andCommandKey(HystrixCommandKey.Factory.asKey((String)this.name()));
            HystrixCommandProperties.Setter commandProps = HystrixCommandProperties.Setter();
            if (this.maxResponseTime > 0) {
                commandProps.withExecutionIsolationThreadTimeoutInMilliseconds(this.maxResponseTime);
            }
            if (this.concurrentRequestLimit > 0) {
                commandProps.withExecutionIsolationSemaphoreMaxConcurrentRequests(this.concurrentRequestLimit);
            }
            this.setter.andCommandPropertiesDefaults(commandProps);
        }
    }

    @Override
    public HttpRequestBuilder<T> requestBuilder() {
        return new HttpRequestBuilder(this);
    }

    protected final ParsedTemplate hystrixCacheKeyTemplate() {
        return this.hystrixCacheKeyTemplate;
    }

    protected final CacheProviderWithKeyTemplate<T> cacheProvider() {
        return this.cacheProvider;
    }

    protected final ResponseValidator<HttpClientResponse<ByteBuf>> responseValidator() {
        return this.validator;
    }

    protected final FallbackHandler<T> fallbackHandler() {
        return this.fallbackHandler;
    }

    protected final ParsedTemplate uriTemplate() {
        return this.parsedUriTemplate;
    }

    protected final HttpMethod method() {
        return this.method;
    }

    protected final Class<? extends T> getClassType() {
        return this.classType;
    }

    protected final HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public String name() {
        return this.name;
    }

    public HttpRequestTemplate<T> copy(String name) {
        HttpRequestTemplate<? extends T> newTemplate = new HttpRequestTemplate<T>(name, this.group, this.classType, this.setter, this.method, this.headers, this.parsedUriTemplate, this.fallbackHandler, this.validator, this.cacheProvider, this.hystrixCacheKeyTemplate);
        return newTemplate;
    }

    protected final HystrixObservableCommand.Setter hystrixProperties() {
        return this.setter;
    }

    protected final HystrixObservableCommand.Setter cacheHystrixProperties() {
        return this.cacheSetter;
    }

    protected final HttpClient<ByteBuf, ByteBuf> getClient() {
        return this.client;
    }

    public static class CacheProviderWithKeyTemplate<T> {
        private final ParsedTemplate keyTemplate;
        private final CacheProvider<T> provider;

        public CacheProviderWithKeyTemplate(ParsedTemplate keyTemplate, CacheProvider<T> provider) {
            this.keyTemplate = keyTemplate;
            this.provider = provider;
        }

        public final ParsedTemplate getKeyTemplate() {
            return this.keyTemplate;
        }

        public final CacheProvider<T> getProvider() {
            return this.provider;
        }
    }

    public static class Builder<T>
    extends ResourceGroup.TemplateBuilder<T, HttpClientResponse<ByteBuf>, HttpRequestTemplate<T>> {
        private String name;
        private HttpResourceGroup resourceGroup;
        private Class<? extends T> classType;
        private FallbackHandler<T> fallbackHandler;
        private HttpMethod method;
        private ParsedTemplate parsedUriTemplate;
        private ParsedTemplate cacheKeyTemplate;
        private CacheProviderWithKeyTemplate<T> cacheProvider;
        private HttpHeaders headers;
        private HystrixObservableCommand.Setter setter;
        private Map<String, ParsedTemplate> parsedTemplates;
        private ResponseValidator<HttpClientResponse<ByteBuf>> validator;

        private Builder(String name, HttpResourceGroup resourceGroup, Class<? extends T> classType) {
            this.name = name;
            this.resourceGroup = resourceGroup;
            this.classType = classType;
            this.headers = new DefaultHttpHeaders();
            this.headers.add(resourceGroup.getHeaders());
            this.parsedTemplates = new HashMap<String, ParsedTemplate>();
        }

        private ParsedTemplate createParsedTemplate(String template) {
            ParsedTemplate parsedTemplate = this.parsedTemplates.get(template);
            if (parsedTemplate == null) {
                parsedTemplate = ParsedTemplate.create(template);
                this.parsedTemplates.put(template, parsedTemplate);
            }
            return parsedTemplate;
        }

        public static <T> Builder<T> newBuilder(String templateName, HttpResourceGroup group, Class<? extends T> classType) {
            return new Builder<T>(templateName, group, classType);
        }

        public Builder<T> withFallbackProvider(FallbackHandler<T> fallbackHandler) {
            this.fallbackHandler = fallbackHandler;
            return this;
        }

        public Builder<T> withResponseValidator(ResponseValidator<HttpClientResponse<ByteBuf>> validator) {
            this.validator = validator;
            return this;
        }

        public Builder<T> withMethod(String method) {
            this.method = HttpMethod.valueOf((String)method);
            return this;
        }

        public Builder<T> withUriTemplate(String uriTemplate) {
            this.parsedUriTemplate = this.createParsedTemplate(uriTemplate);
            return this;
        }

        @Override
        public Builder<T> withRequestCacheKey(String cacheKeyTemplate) {
            this.cacheKeyTemplate = this.createParsedTemplate(cacheKeyTemplate);
            return this;
        }

        public Builder<T> withCacheProvider(String keyTemplate, CacheProvider<T> cacheProvider) {
            ParsedTemplate template = this.createParsedTemplate(keyTemplate);
            this.cacheProvider = new CacheProviderWithKeyTemplate<T>(template, cacheProvider);
            return this;
        }

        public Builder<T> withHeader(String name, String value) {
            this.headers.add(name, (Object)value);
            return this;
        }

        @Override
        public Builder<T> withHystrixProperties(HystrixObservableCommand.Setter propertiesSetter) {
            this.setter = propertiesSetter;
            return this;
        }

        @Override
        public HttpRequestTemplate<T> build() {
            return new HttpRequestTemplate<T>(this.name, this.resourceGroup, this.classType, this.setter, this.method, this.headers, this.parsedUriTemplate, this.fallbackHandler, this.validator, this.cacheProvider, this.cacheKeyTemplate);
        }
    }
}

