/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.exception;

import com.netflix.hystrix.HystrixInvokable;

public class HystrixRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 5219160375476046229L;
    private final Class<? extends HystrixInvokable> commandClass;
    private final Throwable fallbackException;
    private final FailureType failureCause;

    public HystrixRuntimeException(FailureType failureCause, Class<? extends HystrixInvokable> commandClass, String message, Exception cause, Throwable fallbackException) {
        super(message, cause);
        this.failureCause = failureCause;
        this.commandClass = commandClass;
        this.fallbackException = fallbackException;
    }

    public HystrixRuntimeException(FailureType failureCause, Class<? extends HystrixInvokable> commandClass, String message, Throwable cause, Throwable fallbackException) {
        super(message, cause);
        this.failureCause = failureCause;
        this.commandClass = commandClass;
        this.fallbackException = fallbackException;
    }

    public FailureType getFailureType() {
        return this.failureCause;
    }

    public Class<? extends HystrixInvokable> getImplementingClass() {
        return this.commandClass;
    }

    public Throwable getFallbackException() {
        return this.fallbackException;
    }

    public static enum FailureType {
        BAD_REQUEST_EXCEPTION,
        COMMAND_EXCEPTION,
        TIMEOUT,
        SHORTCIRCUIT,
        REJECTED_THREAD_EXECUTION,
        REJECTED_SEMAPHORE_EXECUTION,
        REJECTED_SEMAPHORE_FALLBACK;

    }
}

