/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.springmvc.reference;

import java.io.IOException;
import java.net.URI;
import org.apache.servicecomb.provider.springmvc.reference.CseClientHttpRequest;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;

public class UrlWithProviderPrefixClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private String prefix;

    public UrlWithProviderPrefixClientHttpRequestFactory(String prefix) {
        this.prefix = prefix;
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        return new UrlWithProviderPrefixClientHttpRequest(uri, httpMethod, this.prefix);
    }

    static class UrlWithProviderPrefixClientHttpRequest
    extends CseClientHttpRequest {
        private String prefix;

        public UrlWithProviderPrefixClientHttpRequest(URI uri, HttpMethod httpMethod, String prefix) {
            super(uri, httpMethod);
            this.prefix = prefix;
        }

        @Override
        protected String findUriPath(URI uri) {
            return uri.getRawPath().substring(this.prefix.length());
        }
    }
}

