/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.servo;

import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.NumericMonitor;
import com.netflix.servo.tag.Tag;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.impl.AtomicDouble;
import com.netflix.spectator.servo.ServoMeter;
import com.netflix.spectator.servo.ServoRegistry;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

final class ServoGauge<T extends Number>
extends AbstractMonitor<Double>
implements Gauge,
ServoMeter,
NumericMonitor<Double> {
    private final Id id;
    private final Clock clock;
    private final AtomicDouble value;
    private final AtomicLong lastUpdated;

    ServoGauge(Id id, Clock clock, MonitorConfig config) {
        super(config.withAdditionalTag((Tag)DataSourceType.GAUGE));
        this.id = id;
        this.clock = clock;
        this.value = new AtomicDouble(Double.NaN);
        this.lastUpdated = new AtomicLong(clock.wallTime());
    }

    public Id id() {
        return this.id;
    }

    public boolean hasExpired() {
        long now = this.clock.wallTime();
        return now - this.lastUpdated.get() > ServoRegistry.EXPIRATION_TIME_MILLIS;
    }

    public Iterable<Measurement> measure() {
        long now = this.clock.wallTime();
        return Collections.singleton(new Measurement(this.id(), now, this.value.get()));
    }

    public void set(double v) {
        this.value.set(v);
        this.lastUpdated.set(this.clock.wallTime());
    }

    public double value() {
        return this.hasExpired() ? Double.NaN : this.value.get();
    }

    public Double getValue(int pollerIndex) {
        return this.value();
    }

    @Override
    public void addMonitors(List<Monitor<?>> monitors) {
        monitors.add((Monitor<?>)this);
    }
}

