/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.springmvc.reference;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import org.apache.servicecomb.provider.springmvc.reference.AcceptableRestTemplate;
import org.apache.servicecomb.provider.springmvc.reference.CseClientHttpRequestFactory;
import org.apache.servicecomb.provider.springmvc.reference.CseHttpMessageConverter;
import org.apache.servicecomb.provider.springmvc.reference.CseHttpMessageConverterExtractor;
import org.apache.servicecomb.provider.springmvc.reference.CseRequestCallback;
import org.apache.servicecomb.provider.springmvc.reference.CseResponseEntityResponseExtractor;
import org.apache.servicecomb.provider.springmvc.reference.CseUriTemplateHandler;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriTemplateHandler;

public class CseRestTemplate
extends AcceptableRestTemplate {
    public CseRestTemplate() {
        this.setMessageConverters(Arrays.asList(new CseHttpMessageConverter()));
        this.setRequestFactory(new CseClientHttpRequestFactory());
        this.setUriTemplateHandler((UriTemplateHandler)new CseUriTemplateHandler());
    }

    @Nullable
    public <T> T getForObject(String url, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.acceptHeaderRequestCallback(responseType);
        CseHttpMessageConverterExtractor responseExtractor = new CseHttpMessageConverterExtractor();
        return (T)this.execute(url, HttpMethod.GET, requestCallback, responseExtractor, uriVariables);
    }

    @Nullable
    public <T> T getForObject(String url, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.acceptHeaderRequestCallback(responseType);
        CseHttpMessageConverterExtractor responseExtractor = new CseHttpMessageConverterExtractor();
        return (T)this.execute(url, HttpMethod.GET, requestCallback, responseExtractor, uriVariables);
    }

    @Nullable
    public <T> T getForObject(URI url, Class<T> responseType) throws RestClientException {
        RequestCallback requestCallback = this.acceptHeaderRequestCallback(responseType);
        CseHttpMessageConverterExtractor responseExtractor = new CseHttpMessageConverterExtractor();
        return (T)this.execute(url, HttpMethod.GET, requestCallback, responseExtractor);
    }

    @Nullable
    public <T> T postForObject(String url, @Nullable Object request, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        CseHttpMessageConverterExtractor responseExtractor = new CseHttpMessageConverterExtractor();
        return (T)this.execute(url, HttpMethod.POST, requestCallback, responseExtractor, uriVariables);
    }

    @Nullable
    public <T> T postForObject(String url, @Nullable Object request, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        CseHttpMessageConverterExtractor responseExtractor = new CseHttpMessageConverterExtractor();
        return (T)this.execute(url, HttpMethod.POST, requestCallback, responseExtractor, uriVariables);
    }

    @Nullable
    public <T> T postForObject(URI url, @Nullable Object request, Class<T> responseType) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        CseHttpMessageConverterExtractor responseExtractor = new CseHttpMessageConverterExtractor();
        return (T)this.execute(url, HttpMethod.POST, requestCallback, responseExtractor);
    }

    @Nullable
    public <T> T patchForObject(String url, @Nullable Object request, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        CseHttpMessageConverterExtractor responseExtractor = new CseHttpMessageConverterExtractor();
        return (T)this.execute(url, HttpMethod.PATCH, requestCallback, responseExtractor, uriVariables);
    }

    @Nullable
    public <T> T patchForObject(String url, @Nullable Object request, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        CseHttpMessageConverterExtractor responseExtractor = new CseHttpMessageConverterExtractor();
        return (T)this.execute(url, HttpMethod.PATCH, requestCallback, responseExtractor, uriVariables);
    }

    @Nullable
    public <T> T patchForObject(URI url, @Nullable Object request, Class<T> responseType) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        CseHttpMessageConverterExtractor responseExtractor = new CseHttpMessageConverterExtractor();
        return (T)this.execute(url, HttpMethod.PATCH, requestCallback, responseExtractor);
    }

    public <T> ResponseExtractor<ResponseEntity<T>> responseEntityExtractor(Type responseType) {
        return new CseResponseEntityResponseExtractor(responseType);
    }

    public <T> RequestCallback httpEntityCallback(Object requestBody) {
        RequestCallback callback = super.httpEntityCallback(requestBody);
        CseRequestCallback cseCallback = new CseRequestCallback(requestBody, callback, null);
        return cseCallback;
    }

    public <T> RequestCallback httpEntityCallback(Object requestBody, Type responseType) {
        RequestCallback callback = super.httpEntityCallback(requestBody, responseType);
        CseRequestCallback cseCallback = new CseRequestCallback(requestBody, callback, responseType);
        return cseCallback;
    }

    public <T> RequestCallback acceptHeaderRequestCallback(Class<T> responseType) {
        RequestCallback callback = super.acceptHeaderRequestCallback(responseType);
        CseRequestCallback cseCallback = new CseRequestCallback(null, callback, responseType);
        return cseCallback;
    }

    @Override
    public boolean isAcceptable(String uri) {
        return uri.startsWith("cse://") || uri.startsWith("servicecomb://");
    }

    @Override
    public boolean isAcceptable(URI uri) {
        return "cse".equals(uri.getScheme()) || "servicecomb".equals(uri.getScheme());
    }
}

