/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.runtime.RuntimeService;
import org.apache.sling.resourceresolver.impl.CommonResourceResolverFactoryImpl;
import org.apache.sling.resourceresolver.impl.FactoryPreconditions;
import org.apache.sling.resourceresolver.impl.ResourceResolverFactoryActivator;
import org.apache.sling.resourceresolver.impl.ResourceResolverFactoryImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryRegistrationHandler
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(FactoryRegistrationHandler.class);
    private final ExecutorService factoryRegistrationWorker;
    private final ReentrantLock configurationLock = new ReentrantLock();
    private ResourceResolverFactoryActivator activator;
    private FactoryPreconditions factoryPreconditions;
    private final AtomicReference<FactoryRegistration> factoryRegistration = new AtomicReference<Object>(null);

    public FactoryRegistrationHandler() {
        this.factoryRegistrationWorker = Executors.newSingleThreadExecutor(r -> new Thread(r, ResourceResolverFactory.class.getSimpleName() + " registration/deregistration"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(ResourceResolverFactoryActivator activator, FactoryPreconditions factoryPreconditions) {
        boolean reRegister;
        this.checkClosed();
        try {
            this.configurationLock.lock();
            reRegister = this.activator != activator || !Objects.equals(this.factoryPreconditions, factoryPreconditions);
            LOG.debug("activator differs = {}, factoryPreconditions differ = {}", (Object)(this.activator != activator ? 1 : 0), (Object)(!Objects.equals(this.factoryPreconditions, factoryPreconditions) ? 1 : 0));
            LOG.debug("factoryPreconditions {} vs {}", (Object)this.factoryPreconditions, (Object)factoryPreconditions);
            this.factoryPreconditions = factoryPreconditions;
            this.activator = activator;
        }
        finally {
            this.configurationLock.unlock();
        }
        if (reRegister) {
            this.unregisterFactory();
            this.maybeRegisterFactory();
        }
    }

    private void checkClosed() {
        if (this.factoryRegistrationWorker.isShutdown()) {
            throw new IllegalStateException("FactoryRegistrationHandler is already closed");
        }
    }

    @Override
    public void close() {
        this.factoryRegistrationWorker.shutdown();
        try {
            if (!this.factoryRegistrationWorker.awaitTermination(1L, TimeUnit.MINUTES)) {
                this.factoryRegistrationWorker.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.runWithThreadName("deregistration on close", this::doUnregisterFactory);
    }

    void maybeRegisterFactory() {
        if (!this.factoryRegistrationWorker.isShutdown()) {
            LOG.debug("submitting maybeRegisterFactory");
            this.factoryRegistrationWorker.execute(() -> {
                ResourceResolverFactoryActivator localActivator;
                boolean preconditionsOk;
                try {
                    this.configurationLock.lock();
                    preconditionsOk = this.factoryPreconditions.checkPreconditions();
                    localActivator = this.activator;
                }
                finally {
                    this.configurationLock.unlock();
                }
                if (preconditionsOk) {
                    Bundle systemBundle = localActivator.getBundleContext().getBundle("System Bundle");
                    if (systemBundle != null && systemBundle.getState() != 16) {
                        this.runWithThreadName("registration", () -> this.doRegisterFactory(localActivator));
                    }
                } else {
                    LOG.debug("performing unregisterFactory via maybeRegisterFactory");
                    this.runWithThreadName("deregistration", this::doUnregisterFactory);
                }
            });
        }
    }

    void unregisterFactory() {
        if (!this.factoryRegistrationWorker.isShutdown()) {
            LOG.debug("submitting unregisterFactory");
            this.factoryRegistrationWorker.execute(() -> this.runWithThreadName("deregistration", this::doUnregisterFactory));
        }
    }

    private void doRegisterFactory(ResourceResolverFactoryActivator activator) {
        FactoryRegistration newRegistration = this.factoryRegistration.updateAndGet(oldRegistration -> {
            LOG.debug("performing registerFactory, factoryRegistration == {}", oldRegistration);
            return Objects.requireNonNullElseGet(oldRegistration, () -> new FactoryRegistration(activator.getBundleContext(), activator));
        });
        LOG.debug("finished performing registerFactory, factoryRegistration == {}", (Object)newRegistration);
    }

    private void doUnregisterFactory() {
        FactoryRegistration newRegistration = this.factoryRegistration.updateAndGet(oldRegistration -> {
            LOG.debug("performing unregisterFactory, factoryRegistration == {}", this.factoryRegistration);
            Optional.ofNullable(oldRegistration).ifPresent(FactoryRegistration::unregister);
            LOG.debug("setting factoryRegistration = null");
            return null;
        });
        LOG.debug("finished performing unregisterFactory, factoryRegistration == {}", (Object)newRegistration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithThreadName(String threadNameSuffix, Runnable task) {
        String name = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(ResourceResolverFactory.class.getSimpleName() + " " + threadNameSuffix);
            task.run();
        }
        finally {
            Thread.currentThread().setName(name);
        }
    }

    private final class FactoryRegistration {
        private final ServiceRegistration<ResourceResolverFactory> factoryRegistration;
        private final ServiceRegistration<RuntimeService> runtimeRegistration;
        private final CommonResourceResolverFactoryImpl commonFactory;

        FactoryRegistration(BundleContext context, final ResourceResolverFactoryActivator activator) {
            this.commonFactory = new CommonResourceResolverFactoryImpl(activator);
            this.commonFactory.activate(context);
            Hashtable<String, String> serviceProps = new Hashtable<String, String>();
            ((Dictionary)serviceProps).put("service.vendor", "The Apache Software Foundation");
            ((Dictionary)serviceProps).put("service.description", "Apache Sling Resource Resolver Factory");
            this.factoryRegistration = context.registerService(ResourceResolverFactory.class, (ServiceFactory)new ServiceFactory<ResourceResolverFactory>(){

                public ResourceResolverFactory getService(Bundle bundle, ServiceRegistration<ResourceResolverFactory> registration) {
                    if (FactoryRegistrationHandler.this.factoryRegistrationWorker.isShutdown()) {
                        return null;
                    }
                    return new ResourceResolverFactoryImpl(FactoryRegistration.this.commonFactory, bundle, activator.getServiceUserMapper());
                }

                public void ungetService(Bundle bundle, ServiceRegistration<ResourceResolverFactory> registration, ResourceResolverFactory service) {
                }
            }, serviceProps);
            this.runtimeRegistration = context.registerService(RuntimeService.class, (Object)activator.getRuntimeService(), null);
        }

        void unregister() {
            LOG.debug("Unregister runtimeRegistration");
            this.runtimeRegistration.unregister();
            LOG.debug("Unregister factoryRegistration");
            this.factoryRegistration.unregister();
            LOG.debug("Unregister commonFactory");
            this.commonFactory.deactivate();
            LOG.debug("Unregister completed");
        }
    }
}

