/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;

public class SemiJoinRule
extends RelOptRule {
    private static final Predicate<Join> IS_LEFT_OR_INNER = new Predicate<Join>(){

        public boolean apply(Join input) {
            switch (input.getJoinType()) {
                case LEFT: 
                case INNER: {
                    return true;
                }
            }
            return false;
        }
    };
    public static final SemiJoinRule INSTANCE = new SemiJoinRule(Project.class, Join.class, Aggregate.class, RelFactories.LOGICAL_BUILDER, "SemiJoinRule");

    public SemiJoinRule(Class<Project> projectClass, Class<Join> joinClass, Class<Aggregate> aggregateClass, RelBuilderFactory relBuilderFactory, String description) {
        super(SemiJoinRule.operand(projectClass, SemiJoinRule.some(SemiJoinRule.operand(joinClass, null, IS_LEFT_OR_INNER, SemiJoinRule.some(SemiJoinRule.operand(RelNode.class, SemiJoinRule.any()), SemiJoinRule.operand(aggregateClass, SemiJoinRule.any()))), new RelOptRuleOperand[0])), relBuilderFactory, description);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        ImmutableBitSet rightBits;
        Project project = (Project)call.rel(0);
        Join join = (Join)call.rel(1);
        Object left = call.rel(2);
        Aggregate aggregate = (Aggregate)call.rel(3);
        RelOptCluster cluster = join.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        ImmutableBitSet bits = RelOptUtil.InputFinder.bits(project.getProjects(), null);
        if (bits.intersects(rightBits = ImmutableBitSet.range(left.getRowType().getFieldCount(), join.getRowType().getFieldCount()))) {
            return;
        }
        JoinInfo joinInfo = join.analyzeCondition();
        if (!joinInfo.rightSet().equals(ImmutableBitSet.range(aggregate.getGroupCount()))) {
            return;
        }
        if (!joinInfo.isEqui()) {
            return;
        }
        RelBuilder relBuilder = call.builder();
        relBuilder.push((RelNode)left);
        switch (join.getJoinType()) {
            case INNER: {
                ArrayList newRightKeyBuilder = Lists.newArrayList();
                List<Integer> aggregateKeys = aggregate.getGroupSet().asList();
                for (int key : joinInfo.rightKeys) {
                    newRightKeyBuilder.add(aggregateKeys.get(key));
                }
                ImmutableIntList newRightKeys = ImmutableIntList.copyOf(newRightKeyBuilder);
                relBuilder.push(aggregate.getInput());
                RexNode newCondition = RelOptUtil.createEquiJoinCondition(relBuilder.peek(2, 0), joinInfo.leftKeys, relBuilder.peek(2, 1), newRightKeys, rexBuilder);
                relBuilder.semiJoin(newCondition);
                break;
            }
            case LEFT: {
                break;
            }
            default: {
                throw new AssertionError((Object)join.getJoinType());
            }
        }
        relBuilder.project(project.getProjects(), project.getRowType().getFieldNames());
        call.transformTo(relBuilder.build());
    }
}

