/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime.trident.functions;

import java.util.Map;
import org.apache.calcite.DataContext;
import org.apache.calcite.interpreter.StormContext;
import org.apache.storm.sql.runtime.calcite.DebuggableExecutableExpression;
import org.apache.storm.sql.runtime.calcite.ExecutableExpression;
import org.apache.storm.trident.operation.BaseFilter;
import org.apache.storm.trident.operation.TridentOperationContext;
import org.apache.storm.trident.tuple.TridentTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationFilter
extends BaseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(EvaluationFilter.class);
    private final ExecutableExpression filterInstance;
    private final DataContext dataContext;
    private final Object[] outputValues;

    public EvaluationFilter(ExecutableExpression filterInstance, DataContext dataContext) {
        this.filterInstance = filterInstance;
        this.dataContext = dataContext;
        this.outputValues = new Object[1];
    }

    public void prepare(Map conf, TridentOperationContext context) {
        if (this.filterInstance != null && this.filterInstance instanceof DebuggableExecutableExpression) {
            LOG.info("Expression code for filter: \n{}", (Object)((DebuggableExecutableExpression)this.filterInstance).getDelegateCode());
        }
    }

    public boolean isKeep(TridentTuple tuple) {
        StormContext calciteContext = new StormContext(this.dataContext);
        calciteContext.values = tuple.getValues().toArray();
        this.filterInstance.execute(calciteContext, this.outputValues);
        return this.outputValues[0] != null && (Boolean)this.outputValues[0] != false;
    }
}

