/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.export.ooxml.XlsxBorderStyle;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.util.ObjectUtils;

public class XlsxBorderInfo {
    protected static final String TOP_BORDER = "top";
    protected static final String LEFT_BORDER = "left";
    protected static final String BOTTOM_BORDER = "bottom";
    protected static final String RIGHT_BORDER = "right";
    protected static final String DIAGONAL_BORDER = "diagonal";
    protected Color topBorderColor;
    protected Color leftBorderColor;
    protected Color bottomBorderColor;
    protected Color rightBorderColor;
    protected Color diagonalBorderColor;
    protected XlsxBorderStyle topBorderStyle;
    protected XlsxBorderStyle leftBorderStyle;
    protected XlsxBorderStyle bottomBorderStyle;
    protected XlsxBorderStyle rightBorderStyle;
    protected XlsxBorderStyle diagonalBorderStyle;
    protected LineDirectionEnum direction;

    public XlsxBorderInfo(JRLineBox box) {
        this.setTopBorder(box.getTopPen());
        this.setLeftBorder(box.getLeftPen());
        this.setBottomBorder(box.getBottomPen());
        this.setRightBorder(box.getRightPen());
    }

    public XlsxBorderInfo(JRLineBox box, LineDirectionEnum direction) {
        if (direction != null) {
            this.setDiagonalBorder(box.getPen());
        } else {
            this.setTopBorder(box.getTopPen());
            this.setLeftBorder(box.getLeftPen());
            this.setBottomBorder(box.getBottomPen());
            this.setRightBorder(box.getRightPen());
        }
        this.direction = direction;
    }

    public XlsxBorderInfo(JRPen pen) {
        this.setTopBorder(pen);
        this.setLeftBorder(pen);
        this.setBottomBorder(pen);
        this.setRightBorder(pen);
    }

    public int hashCode() {
        int hash = 47 + ObjectUtils.hashCode((Object)this.topBorderStyle);
        hash = 29 * hash + ObjectUtils.hashCode(this.topBorderColor);
        hash = 29 * hash + ObjectUtils.hashCode((Object)this.leftBorderStyle);
        hash = 29 * hash + ObjectUtils.hashCode(this.leftBorderColor);
        hash = 29 * hash + ObjectUtils.hashCode((Object)this.bottomBorderStyle);
        hash = 29 * hash + ObjectUtils.hashCode(this.bottomBorderColor);
        hash = 29 * hash + ObjectUtils.hashCode((Object)this.rightBorderStyle);
        hash = 29 * hash + ObjectUtils.hashCode(this.rightBorderColor);
        hash = 29 * hash + ObjectUtils.hashCode((Object)this.diagonalBorderStyle);
        hash = 29 * hash + ObjectUtils.hashCode(this.diagonalBorderColor);
        hash = 29 * hash + ObjectUtils.hashCode(this.direction);
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XlsxBorderInfo)) {
            return false;
        }
        XlsxBorderInfo info = (XlsxBorderInfo)obj;
        return this.topBorderStyle == info.topBorderStyle && ObjectUtils.equals(this.topBorderColor, info.topBorderColor) && this.leftBorderStyle == info.leftBorderStyle && ObjectUtils.equals(this.leftBorderColor, info.leftBorderColor) && this.bottomBorderStyle == info.bottomBorderStyle && ObjectUtils.equals(this.bottomBorderColor, info.bottomBorderColor) && this.rightBorderStyle == info.rightBorderStyle && ObjectUtils.equals(this.rightBorderColor, info.rightBorderColor) && this.diagonalBorderStyle == info.diagonalBorderStyle && ObjectUtils.equals(this.diagonalBorderColor, info.diagonalBorderColor) && this.direction == info.direction;
    }

    public LineDirectionEnum getDirection() {
        return this.direction;
    }

    private void setTopBorder(JRPen pen) {
        this.topBorderStyle = XlsxBorderInfo.borderStyle(pen);
        this.topBorderColor = pen.getLineColor();
    }

    private void setLeftBorder(JRPen pen) {
        this.leftBorderStyle = XlsxBorderInfo.borderStyle(pen);
        this.leftBorderColor = pen.getLineColor();
    }

    private void setBottomBorder(JRPen pen) {
        this.bottomBorderStyle = XlsxBorderInfo.borderStyle(pen);
        this.bottomBorderColor = pen.getLineColor();
    }

    private void setRightBorder(JRPen pen) {
        this.rightBorderStyle = XlsxBorderInfo.borderStyle(pen);
        this.rightBorderColor = pen.getLineColor();
    }

    private void setDiagonalBorder(JRPen pen) {
        this.diagonalBorderStyle = XlsxBorderInfo.borderStyle(pen);
        this.diagonalBorderColor = pen.getLineColor();
    }

    private static XlsxBorderStyle borderStyle(JRPen pen) {
        float width = pen.getLineWidth() == null ? 0.0f : pen.getLineWidth().floatValue();
        XlsxBorderStyle style = null;
        if (width > 0.0f) {
            switch (pen.getLineStyle()) {
                case DOUBLE: {
                    style = XlsxBorderStyle.DOUBLE;
                    break;
                }
                case DOTTED: {
                    style = XlsxBorderStyle.DOTTED;
                    break;
                }
                case DASHED: {
                    if (width >= 1.0f) {
                        style = XlsxBorderStyle.MEDIUM_DASHED;
                        break;
                    }
                    style = XlsxBorderStyle.DASHED;
                    break;
                }
                default: {
                    style = width >= 2.0f ? XlsxBorderStyle.THICK : (width >= 1.0f ? XlsxBorderStyle.MEDIUM : (width >= 0.5f ? XlsxBorderStyle.THIN : XlsxBorderStyle.HAIR));
                }
            }
        }
        return style;
    }
}

