/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml.print;

import java.util.Map;
import java.util.UUID;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBasePrintElement;
import net.sf.jasperreports.engine.base.JRBasePrintGraphicElement;
import net.sf.jasperreports.engine.type.FillEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.xml.print.PenLoader;
import net.sf.jasperreports.engine.xml.print.PropertyLoader;
import net.sf.jasperreports.engine.xml.print.XmlLoader;

public class ReportElementLoader {
    private static final ReportElementLoader INSTANCE = new ReportElementLoader();

    public static ReportElementLoader instance() {
        return INSTANCE;
    }

    public void loadReportElement(XmlLoader xmlLoader, JasperPrint jasperPrint, JRBasePrintElement printElement) {
        xmlLoader.setAttribute("key", printElement::setKey);
        xmlLoader.setEnumAttribute("mode", ModeEnum::getByName, printElement::setMode);
        xmlLoader.setAttribute("uuid", UUID::fromString, printElement::setUUID);
        xmlLoader.setIntAttribute("x", printElement::setX);
        xmlLoader.setIntAttribute("y", printElement::setY);
        xmlLoader.setIntAttribute("width", printElement::setWidth);
        xmlLoader.setIntAttribute("height", printElement::setHeight);
        xmlLoader.setColorAttribute("forecolor", printElement::setForecolor);
        xmlLoader.setColorAttribute("backcolor", printElement::setBackcolor);
        xmlLoader.setAttribute("style", styleName -> {
            Map<String, JRStyle> stylesMap = jasperPrint.getStylesMap();
            JRStyle style = stylesMap.get(styleName);
            if (style == null) {
                throw new JRRuntimeException("xml.base.factory.unknown.report.style", styleName);
            }
            return style;
        }, printElement::setStyle);
        xmlLoader.setAttribute("origin", originAttr -> jasperPrint.getOriginsList().get(Integer.parseInt(originAttr)), printElement::setOrigin);
        xmlLoader.setIntAttribute("srcId", printElement::setSourceElementId);
        xmlLoader.setIntAttribute("printId", printElement::setPrintElementId);
        xmlLoader.loadElements(element -> {
            switch (element) {
                case "property": {
                    PropertyLoader.instance().loadProperty(xmlLoader, printElement);
                    break;
                }
                default: {
                    xmlLoader.unexpectedElement((String)element);
                }
            }
        });
    }

    public void loadGraphicElement(XmlLoader xmlLoader, JRBasePrintGraphicElement printElement) {
        xmlLoader.setEnumAttribute("fill", FillEnum::getByName, printElement::setFill);
        xmlLoader.loadElements(element -> {
            switch (element) {
                case "pen": {
                    PenLoader.instance().loadPen(xmlLoader, printElement.getLinePen());
                    break;
                }
                default: {
                    xmlLoader.unexpectedElement((String)element);
                }
            }
        });
    }
}

