/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.jasperreports7.export;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.SimpleCsvExporterConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.StrutsException;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.views.jasperreports7.JasperReport7Aware;
import org.apache.struts2.views.jasperreports7.export.JasperReport7ExporterProvider;

public class JasperReport7CsvExporterProvider
implements JasperReport7ExporterProvider<JRCsvExporter> {
    private static final Logger LOG = LogManager.getLogger(JasperReport7CsvExporterProvider.class);
    private String defaultDelimiter = ",";

    @Inject
    public JasperReport7CsvExporterProvider(@Inject(value="struts.jasperReport7.csv.defaultDelimiter", required=false) String defaultDelimiter) {
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{defaultDelimiter})) {
            LOG.debug("Using custom default delimiter [{}]", (Object)defaultDelimiter);
            this.defaultDelimiter = defaultDelimiter;
        }
    }

    @Override
    public JRCsvExporter createExporter(ActionInvocation invocation, JasperPrint jasperPrint) throws StrutsException {
        LOG.debug("Creating: {} exporter", (Object)this.getClass().getSimpleName());
        HttpServletResponse response = invocation.getInvocationContext().getServletResponse();
        response.setContentType("text/csv");
        JRCsvExporter exporter = new JRCsvExporter();
        String reportDelimiter = null;
        Object object = invocation.getAction();
        if (object instanceof JasperReport7Aware) {
            JasperReport7Aware action = (JasperReport7Aware)object;
            reportDelimiter = action.getCsvDelimiter(invocation);
        }
        if (StringUtils.isEmpty(reportDelimiter)) {
            reportDelimiter = this.defaultDelimiter;
        }
        LOG.debug("Using delimiter: [{}]", (Object)reportDelimiter);
        SimpleCsvExporterConfiguration config = new SimpleCsvExporterConfiguration();
        config.setFieldDelimiter(reportDelimiter);
        config.setRecordDelimiter(reportDelimiter);
        exporter.setConfiguration((ExporterConfiguration)config);
        SimpleExporterInput input = new SimpleExporterInput(jasperPrint);
        exporter.setExporterInput((ExporterInput)input);
        try (ServletOutputStream responseStream = response.getOutputStream();){
            SimpleWriterExporterOutput exporterOutput = new SimpleWriterExporterOutput((OutputStream)responseStream);
            exporter.setExporterOutput((ExporterOutput)exporterOutput);
        }
        catch (IOException e) {
            LOG.error("Error writing CSV report output using: {}", (Object)JasperReport7CsvExporterProvider.class.getName(), (Object)e);
            throw new StrutsException(e.getMessage(), (Throwable)e);
        }
        return exporter;
    }
}

