/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.mr.ReblockInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.AdaptivePartialBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.PartialBlock;
import org.apache.sysml.runtime.matrix.data.TaggedAdaptivePartialBlock;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.mapred.ReduceBase;

public class ReblockReducer
extends ReduceBase
implements Reducer<MatrixIndexes, TaggedAdaptivePartialBlock, MatrixIndexes, MatrixBlock> {
    private HashMap<Byte, MatrixCharacteristics> dimensions = new HashMap();

    public void reduce(MatrixIndexes indexes, Iterator<TaggedAdaptivePartialBlock> values, OutputCollector<MatrixIndexes, MatrixBlock> out, Reporter reporter) throws IOException {
        long start = System.currentTimeMillis();
        this.commonSetup(reporter);
        this.cachedValues.reset();
        this.processReblockInReducer(indexes, values, this.dimensions);
        this.processReducerInstructions();
        this.outputResultsFromCachedValues(reporter);
        reporter.incrCounter((Enum)ReduceBase.Counters.COMBINE_OR_REDUCE_TIME, System.currentTimeMillis() - start);
    }

    @Override
    public void configure(JobConf job) {
        MRJobConfiguration.setMatrixValueClass(job, true);
        super.configure(job);
        try {
            ReblockInstruction[] reblockInstructions;
            for (ReblockInstruction ins : reblockInstructions = MRJobConfiguration.getReblockInstructions(job)) {
                this.dimensions.put(ins.output, MRJobConfiguration.getMatrixCharactristicsForReblock(job, ins.output));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void processReblockInReducer(MatrixIndexes indexes, Iterator<TaggedAdaptivePartialBlock> values, HashMap<Byte, MatrixCharacteristics> dimensions) {
        while (values.hasNext()) {
            MatrixBlock out;
            TaggedAdaptivePartialBlock partial = values.next();
            Byte tag = partial.getTag();
            AdaptivePartialBlock srcBlk = (AdaptivePartialBlock)partial.getBaseObject();
            IndexedMatrixValue block = this.cachedValues.getFirst(tag);
            if (block == null) {
                MatrixCharacteristics mc = dimensions.get(tag);
                int brlen = mc.getRowsPerBlock();
                int bclen = mc.getColsPerBlock();
                int realBrlen = (int)Math.min((long)brlen, mc.getRows() - (indexes.getRowIndex() - 1L) * (long)brlen);
                int realBclen = (int)Math.min((long)bclen, mc.getCols() - (indexes.getColumnIndex() - 1L) * (long)bclen);
                block = this.cachedValues.holdPlace(tag, this.valueClass);
                block.getValue().reset(realBrlen, realBclen);
                block.getIndexes().setIndexes(indexes);
            }
            if (srcBlk.isBlocked()) {
                try {
                    out = (MatrixBlock)block.getValue();
                    MatrixBlock in = srcBlk.getMatrixBlock();
                    out.merge(in, false);
                    out.examSparsity();
                    continue;
                }
                catch (DMLRuntimeException e) {
                    throw new RuntimeException(e);
                }
            }
            out = (MatrixBlock)block.getValue();
            PartialBlock pb = srcBlk.getPartialBlock();
            int row = pb.getRowIndex();
            int column = pb.getColumnIndex();
            if (row < 0 || column < 0) continue;
            out.quickSetValue(row, column, pb.getValue());
        }
    }
}

