/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.indexes;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.sysds.runtime.compress.colgroup.indexes.AColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.IIterate;
import org.apache.sysds.runtime.compress.colgroup.indexes.TwoIndex;

public class SingleIndex
extends AColIndex {
    private final int idx;

    public SingleIndex(int idx) {
        this.idx = idx;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public int get(int i) {
        return this.idx;
    }

    @Override
    public SingleIndex shift(int i) {
        return new SingleIndex(i + this.idx);
    }

    @Override
    public IIterate iterator() {
        return new SingleIterator();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(IColIndex.ColIndexType.SINGLE.ordinal());
        out.writeInt(this.idx);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 5L;
    }

    @Override
    public long estimateInMemorySize() {
        return SingleIndex.estimateInMemorySizeStatic();
    }

    public static long estimateInMemorySizeStatic() {
        return 24L;
    }

    @Override
    public int findIndex(int i) {
        if (i < this.idx) {
            return -1;
        }
        if (i == this.idx) {
            return 0;
        }
        return -2;
    }

    @Override
    public IColIndex.SliceResult slice(int l, int u) {
        return l <= this.idx && u > this.idx ? (l == 0 ? new IColIndex.SliceResult(0, 1, this) : new IColIndex.SliceResult(0, 1, new SingleIndex(this.idx - l))) : new IColIndex.SliceResult(0, 0, null);
    }

    @Override
    public boolean equals(IColIndex other) {
        return other.size() == 1 && other.get(0) == this.idx;
    }

    @Override
    public IColIndex combine(IColIndex other) {
        if (other instanceof SingleIndex) {
            int otherV = other.get(0);
            if (otherV < this.idx) {
                return new TwoIndex(otherV, this.idx);
            }
            return new TwoIndex(this.idx, otherV);
        }
        return other.combine(this);
    }

    @Override
    public boolean isContiguous() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        sb.append(this.idx);
        sb.append("]");
        return sb.toString();
    }

    protected class SingleIterator
    implements IIterate {
        boolean taken = false;

        protected SingleIterator() {
        }

        @Override
        public int next() {
            this.taken = true;
            return SingleIndex.this.idx;
        }

        @Override
        public boolean hasNext() {
            return !this.taken;
        }
    }
}

