/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import java.util.concurrent.Executors;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.TriggerPrefetchTask;
import org.apache.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class PrefetchCPInstruction
extends UnaryCPInstruction {
    private PrefetchCPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.Prefetch, op, in, out, opcode, istr);
    }

    public static PrefetchCPInstruction parseInstruction(String str) {
        InstructionUtils.checkNumFields(str, 3);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        return new PrefetchCPInstruction(null, in, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        LineageItem li;
        ec.setVariable(this.output.getName(), ec.getMatrixObject(this.input1));
        LineageItem lineageItem = li = !LineageCacheConfig.ReuseCacheType.isNone() ? (LineageItem)this.getLineageItem(ec).getValue() : null;
        if (CommonThreadPool.triggerRemoteOPsPool == null) {
            CommonThreadPool.triggerRemoteOPsPool = Executors.newCachedThreadPool();
        }
        CommonThreadPool.triggerRemoteOPsPool.submit(new TriggerPrefetchTask(ec.getMatrixObject(this.output), li));
    }
}

