/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.tokenize.applier;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.transform.tokenize.DocumentRepresentation;
import org.apache.sysds.runtime.transform.tokenize.Tokenizer;
import org.apache.sysds.runtime.util.DependencyTask;
import org.apache.sysds.runtime.util.DependencyThreadPool;
import org.apache.sysds.runtime.util.UtilFunctions;

public abstract class TokenizerApplier
implements Serializable {
    private static final long serialVersionUID = 39116559705096787L;
    protected static final Log LOG = LogFactory.getLog((String)TokenizerApplier.class.getName());
    public static final String PADDING_STRING = "";
    protected final int numIdCols;
    protected final int maxTokens;
    protected final boolean wideFormat;
    protected final boolean applyPadding;

    public TokenizerApplier(int numIdCols, int maxTokens, boolean wideFormat, boolean applyPadding) {
        this.numIdCols = numIdCols;
        this.maxTokens = maxTokens;
        this.wideFormat = wideFormat;
        this.applyPadding = applyPadding;
    }

    public int applyInternalRepresentation(DocumentRepresentation[] internalRepresentation, FrameBlock out) {
        return this.applyInternalRepresentation(internalRepresentation, out, 0, -1);
    }

    abstract int applyInternalRepresentation(DocumentRepresentation[] var1, FrameBlock var2, int var3, int var4);

    public void build(DocumentRepresentation[] internalRepresentation, int inputRowStart, int blk) {
    }

    public List<DependencyTask<?>> getBuildTasks(DocumentRepresentation[] internalRepresentation) {
        int nRows = internalRepresentation.length;
        ArrayList<TokenizerApplierBuildTask<TokenizerApplier>> tasks = new ArrayList<TokenizerApplierBuildTask<TokenizerApplier>>();
        int[] blockSizes = UtilFunctions.getBlockSizes(nRows, Tokenizer.TOKENIZE_NUM_BLOCKS);
        if (blockSizes.length == 1) {
            tasks.add(new TokenizerApplierBuildTask<TokenizerApplier>(this, internalRepresentation, 0, -1));
        } else {
            int startRow = 0;
            for (int i = 0; i < blockSizes.length; ++i) {
                tasks.add(new TokenizerApplierBuildTask<TokenizerApplier>(this, internalRepresentation, startRow, blockSizes[i]));
                startRow += blockSizes[i];
            }
        }
        return DependencyThreadPool.createDependencyTasks(tasks, null);
    }

    public List<DependencyTask<?>> getApplyTasks(DocumentRepresentation[] internalRepresentation, FrameBlock out) {
        int nRows = internalRepresentation.length;
        ArrayList<TokenizerApplyTask<TokenizerApplier>> tasks = new ArrayList<TokenizerApplyTask<TokenizerApplier>>();
        int[] blockSizes = UtilFunctions.getBlockSizes(nRows, Tokenizer.TOKENIZE_NUM_BLOCKS);
        if (blockSizes.length == 1) {
            tasks.add(new TokenizerApplyTask<TokenizerApplier>(this, out, internalRepresentation, 0, -1));
        } else {
            int startRow = 0;
            for (int i = 0; i < blockSizes.length; ++i) {
                tasks.add(new TokenizerApplyTask<TokenizerApplier>(this, out, internalRepresentation, startRow, blockSizes[i]));
                startRow += blockSizes[i];
            }
        }
        return DependencyThreadPool.createDependencyTasks(tasks, null);
    }

    protected int setKeys(int row, List<Object> keys, FrameBlock out) {
        int col;
        for (col = 0; col < keys.size(); ++col) {
            out.set(row, col, keys.get(col));
        }
        return col;
    }

    protected int applyPaddingLong(int startRow, int numTokens, List<Object> keys, FrameBlock out, Object val1, Object val2) {
        int row = startRow;
        while (numTokens < this.maxTokens) {
            int col = this.setKeys(row, keys, out);
            out.set(row, col, val1);
            out.set(row, col + 1, val2);
            ++numTokens;
            ++row;
        }
        return row;
    }

    protected void applyPaddingWide(int row, int offset, int startToken, FrameBlock out, Object padding) {
        for (int token = startToken; token < this.maxTokens; ++token) {
            out.set(row, offset + token, padding);
        }
    }

    public abstract Types.ValueType[] getOutSchema();

    public boolean hasPadding() {
        return this.applyPadding;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public int getMaxNumRows(int inRows) {
        if (this.wideFormat) {
            return inRows;
        }
        return inRows * this.maxTokens;
    }

    public abstract int getNumRows(DocumentRepresentation[] var1);

    public <T, E> int getOutputRow(int inputRowStart, List<Map<T, E>> internalData) {
        if (this.wideFormat) {
            return inputRowStart;
        }
        if (this.applyPadding) {
            return this.maxTokens * inputRowStart;
        }
        return internalData.stream().limit(inputRowStart).mapToInt(hashMap -> Math.min(hashMap.size(), this.maxTokens)).sum();
    }

    public int getOutputRow(int inputRowStart, DocumentRepresentation[] internalData) {
        if (this.wideFormat) {
            return inputRowStart;
        }
        if (this.applyPadding) {
            return this.maxTokens * inputRowStart;
        }
        return Arrays.stream(internalData).limit(inputRowStart).mapToInt(doc -> Math.min(doc.tokens.size(), this.maxTokens)).sum();
    }

    public long getNumCols() {
        return this.getOutSchema().length;
    }

    public boolean isWideFormat() {
        return this.wideFormat;
    }

    public void allocateInternalMeta(int numDocuments) {
    }

    protected static class TokenizerApplierBuildTask<T extends TokenizerApplier>
    implements Callable<Object> {
        protected final T _tokenizerApplier;
        protected final DocumentRepresentation[] _internalRepresentation;
        protected final int _rowStart;
        protected final int _blk;

        protected TokenizerApplierBuildTask(T tokenizerApplier, DocumentRepresentation[] internalRepresentation, int rowStart, int blk) {
            this._tokenizerApplier = tokenizerApplier;
            this._internalRepresentation = internalRepresentation;
            this._rowStart = rowStart;
            this._blk = blk;
        }

        @Override
        public Object call() throws Exception {
            ((TokenizerApplier)this._tokenizerApplier).build(this._internalRepresentation, this._rowStart, this._blk);
            return null;
        }
    }

    protected static class TokenizerApplyTask<T extends TokenizerApplier>
    implements Callable<Object> {
        protected final T _tokenizerApplier;
        protected final FrameBlock _output;
        protected final DocumentRepresentation[] _internalRepresentation;
        protected final int _rowStart;
        protected final int _blk;

        protected TokenizerApplyTask(T tokenizerApplier, FrameBlock out, DocumentRepresentation[] internalRepresentation, int rowStart, int blk) {
            this._tokenizerApplier = tokenizerApplier;
            this._output = out;
            this._internalRepresentation = internalRepresentation;
            this._rowStart = rowStart;
            this._blk = blk;
        }

        @Override
        public Object call() throws Exception {
            return ((TokenizerApplier)this._tokenizerApplier).applyInternalRepresentation(this._internalRepresentation, this._output, this._rowStart, this._blk);
        }
    }
}

