/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.indexes;

import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.indexes.ArrayIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.IIterate;
import org.apache.sysds.runtime.compress.colgroup.indexes.RangeIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.SingleIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.TwoIndex;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public interface ColIndexFactory {
    public static IColIndex read(DataInput in) throws IOException {
        IColIndex.ColIndexType t = IColIndex.ColIndexType.values()[in.readByte()];
        switch (t) {
            case SINGLE: {
                return new SingleIndex(in.readInt());
            }
            case TWO: {
                return new TwoIndex(in.readInt(), in.readInt());
            }
            case ARRAY: {
                return ArrayIndex.read(in);
            }
            case RANGE: {
                return RangeIndex.read(in);
            }
        }
        throw new DMLCompressionException("Failed reading column index of type: " + t);
    }

    public static IColIndex create(int[] indexes) {
        if (indexes.length <= 0) {
            throw new DMLRuntimeException("Invalid length to create index from : " + indexes.length);
        }
        if (indexes.length == 1) {
            return new SingleIndex(indexes[0]);
        }
        if (indexes.length == 2) {
            return new TwoIndex(indexes[0], indexes[1]);
        }
        if (RangeIndex.isValidRange(indexes)) {
            return new RangeIndex(indexes[0], indexes[0] + indexes.length);
        }
        return new ArrayIndex(indexes);
    }

    public static IColIndex create(IntArrayList indexes) {
        int s = indexes.size();
        if (s <= 0) {
            throw new DMLRuntimeException("Invalid length to create index from " + indexes);
        }
        if (s == 1) {
            return new SingleIndex(indexes.get(0));
        }
        if (s == 2) {
            return new TwoIndex(indexes.get(0), indexes.get(1));
        }
        if (RangeIndex.isValidRange(indexes)) {
            return new RangeIndex(indexes.get(0), indexes.get(0) + s);
        }
        return new ArrayIndex(indexes.extractValues(true));
    }

    public static IColIndex create(int l, int u) {
        if (u - l <= 0) {
            throw new DMLRuntimeException("Invalid range: " + l + " " + u);
        }
        if (u - 1 == l) {
            return new SingleIndex(l);
        }
        if (u - 2 == l) {
            return new TwoIndex(l, l + 1);
        }
        return new RangeIndex(l, u);
    }

    public static IColIndex create(int nCol) {
        if (nCol <= 0) {
            throw new DMLRuntimeException("Invalid size of index columns must be above 0");
        }
        if (nCol == 1) {
            return new SingleIndex(0);
        }
        if (nCol == 2) {
            return new TwoIndex(0, 1);
        }
        return new RangeIndex(nCol);
    }

    public static long estimateMemoryCost(int nCol, boolean contiguous) {
        if (nCol == 1) {
            return SingleIndex.estimateInMemorySizeStatic();
        }
        if (nCol == 2) {
            return TwoIndex.estimateInMemorySizeStatic();
        }
        if (contiguous) {
            return RangeIndex.estimateInMemorySizeStatic();
        }
        return ArrayIndex.estimateInMemorySizeStatic(nCol);
    }

    public static IColIndex combine(List<AColGroup> gs) {
        int numCols = 0;
        for (AColGroup g : gs) {
            numCols += g.getNumCols();
        }
        int[] resCols = new int[numCols];
        int index = 0;
        for (AColGroup g : gs) {
            IIterate it = g.getColIndices().iterator();
            while (it.hasNext()) {
                resCols[index++] = it.next();
            }
        }
        Arrays.sort(resCols);
        return ColIndexFactory.create(resCols);
    }
}

