/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Writable;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.columns.ABooleanArray;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.OptionalArray;
import org.apache.sysds.runtime.matrix.data.Pair;

public abstract class Array<T>
implements Writable {
    protected static final Log LOG = LogFactory.getLog((String)Array.class.getName());
    private static final boolean REUSE_RECODE_MAPS = true;
    protected SoftReference<HashMap<T, Long>> _rcdMapCache = null;
    protected int _size;

    protected Array(int size) {
        this._size = size;
        if (size <= 0) {
            throw new DMLRuntimeException("Invalid zero/negative size of Array");
        }
    }

    protected int newSize() {
        return Math.max(this._size * 2, 4);
    }

    public final SoftReference<HashMap<T, Long>> getCache() {
        return this._rcdMapCache;
    }

    public final void setCache(SoftReference<HashMap<T, Long>> m) {
        this._rcdMapCache = m;
    }

    public HashMap<T, Long> getRecodeMap() {
        HashMap<T, Long> map;
        SoftReference<HashMap<T, Long>> tmp = this.getCache();
        HashMap<T, Long> hashMap = map = tmp != null ? tmp.get() : null;
        if (map != null) {
            return map;
        }
        HashMap<T, Long> map2 = this.createRecodeMap();
        this.setCache(new SoftReference<HashMap<T, Long>>(map2));
        return map2;
    }

    protected HashMap<T, Long> createRecodeMap() {
        HashMap<T, Long> map = new HashMap<T, Long>();
        long id = 0L;
        for (int i = 0; i < this.size(); ++i) {
            Long v;
            T val = this.get(i);
            if (val == null || (v = map.putIfAbsent(val, id)) != null) continue;
            ++id;
        }
        return map;
    }

    public final int size() {
        return this._size;
    }

    public abstract T get(int var1);

    public abstract Object get();

    public abstract double getAsDouble(int var1);

    public double getAsNaNDouble(int i) {
        return this.getAsDouble(i);
    }

    public abstract void set(int var1, T var2);

    public abstract void set(int var1, double var2);

    public abstract void set(int var1, String var2);

    public abstract void setFromOtherType(int var1, int var2, Array<?> var3);

    public abstract void set(int var1, int var2, Array<T> var3);

    public abstract void set(int var1, int var2, Array<T> var3, int var4);

    public final void setNz(Array<T> value) {
        this.setNz(0, value.size() - 1, value);
    }

    public abstract void setNz(int var1, int var2, Array<T> var3);

    public final void setFromOtherTypeNz(Array<?> value) {
        this.setFromOtherTypeNz(0, value.size() - 1, value);
    }

    public abstract void setFromOtherTypeNz(int var1, int var2, Array<?> var3);

    public abstract void append(String var1);

    public abstract void append(T var1);

    public abstract Array<T> append(Array<T> var1);

    public abstract Array<T> slice(int var1, int var2);

    public abstract void reset(int var1);

    public abstract byte[] getAsByteArray();

    public abstract Types.ValueType getValueType();

    public abstract Pair<Types.ValueType, Boolean> analyzeValueType();

    public abstract ArrayFactory.FrameArrayType getFrameArrayType();

    public long getInMemorySize() {
        return Array.baseMemoryCost();
    }

    public static long baseMemoryCost() {
        return 32L;
    }

    public abstract long getExactSerializedSize();

    public ABooleanArray getNulls() {
        return null;
    }

    public boolean containsNull() {
        return false;
    }

    public Array<?> changeTypeWithNulls(Types.ValueType t) {
        ABooleanArray nulls = this.getNulls();
        if (nulls == null) {
            return this.changeType(t);
        }
        switch (t) {
            case BOOLEAN: {
                if (this.size() > 64) {
                    return new OptionalArray<Boolean>(this.changeTypeBitSet(), nulls);
                }
                return new OptionalArray<Boolean>(this.changeTypeBoolean(), nulls);
            }
            case FP32: {
                return new OptionalArray<Float>(this.changeTypeFloat(), nulls);
            }
            case FP64: {
                return new OptionalArray<Double>(this.changeTypeDouble(), nulls);
            }
            case UINT4: 
            case UINT8: {
                throw new NotImplementedException();
            }
            case INT32: {
                return new OptionalArray<Integer>(this.changeTypeInteger(), nulls);
            }
            case INT64: {
                return new OptionalArray<Long>(this.changeTypeLong(), nulls);
            }
            case CHARACTER: {
                return new OptionalArray<Character>(this.changeTypeCharacter(), nulls);
            }
        }
        return this.changeTypeString();
    }

    public final Array<?> changeType(Types.ValueType t) {
        switch (t) {
            case BOOLEAN: {
                if (this.size() > 64) {
                    return this.changeTypeBitSet();
                }
                return this.changeTypeBoolean();
            }
            case FP32: {
                return this.changeTypeFloat();
            }
            case FP64: {
                return this.changeTypeDouble();
            }
            case UINT4: 
            case UINT8: {
                throw new NotImplementedException();
            }
            case INT32: {
                return this.changeTypeInteger();
            }
            case INT64: {
                return this.changeTypeLong();
            }
            case STRING: {
                return this.changeTypeString();
            }
            case CHARACTER: {
                return this.changeTypeCharacter();
            }
        }
        return this.changeTypeString();
    }

    protected abstract Array<Boolean> changeTypeBitSet();

    protected abstract Array<Boolean> changeTypeBoolean();

    protected abstract Array<Double> changeTypeDouble();

    protected abstract Array<Float> changeTypeFloat();

    protected abstract Array<Integer> changeTypeInteger();

    protected abstract Array<Long> changeTypeLong();

    protected abstract Array<String> changeTypeString();

    protected abstract Array<Character> changeTypeCharacter();

    public Pair<Integer, Integer> getMinMaxLength() {
        throw new DMLRuntimeException("Length is only relevant if case is String");
    }

    public abstract void fill(String var1);

    public abstract void fill(T var1);

    public abstract boolean isShallowSerialize();

    public abstract boolean isEmpty();

    public abstract Array<T> select(int[] var1);

    public abstract Array<T> select(boolean[] var1, int var2);

    public final void findEmpty(boolean[] select) {
        for (int i = 0; i < select.length; ++i) {
            if (!this.isNotEmpty(i)) continue;
            select[i] = true;
        }
    }

    public abstract boolean isNotEmpty(int var1);

    public void findEmptyInverse(boolean[] select) {
        for (int i = 0; i < select.length; ++i) {
            if (this.isNotEmpty(i)) continue;
            select[i] = true;
        }
    }

    public abstract Array<T> clone();

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public ArrayIterator getIterator() {
        return new ArrayIterator();
    }

    public class ArrayIterator
    implements Iterator<T> {
        int index = -1;

        public int getIndex() {
            return this.index;
        }

        @Override
        public boolean hasNext() {
            return this.index < Array.this.size() - 1;
        }

        @Override
        public T next() {
            return Array.this.get(++this.index);
        }
    }
}

