/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.erasurecode;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.ErasureCodingWorker;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedReconstructionInfo;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedReconstructor;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedWriter;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeMetrics;
import org.apache.hadoop.io.erasurecode.rawcoder.InvalidDecodingException;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
class StripedBlockReconstructor
extends StripedReconstructor
implements Runnable {
    private StripedWriter stripedWriter;

    StripedBlockReconstructor(ErasureCodingWorker worker, StripedReconstructionInfo stripedReconInfo) {
        super(worker, stripedReconInfo);
        this.stripedWriter = new StripedWriter(this, this.getDatanode(), this.getConf(), stripedReconInfo);
    }

    boolean hasValidTargets() {
        return this.stripedWriter.hasValidTargets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.initDecoderIfNecessary();
            this.initDecodingValidatorIfNecessary();
            this.getStripedReader().init();
            this.stripedWriter.init();
            this.reconstruct();
            this.stripedWriter.endTargetBlocks();
        }
        catch (Throwable e) {
            LOG.warn("Failed to reconstruct striped block: {}", (Object)this.getBlockGroup(), (Object)e);
            this.getDatanode().getMetrics().incrECFailedReconstructionTasks();
        }
        finally {
            float xmitWeight = this.getErasureCodingWorker().getXmitWeight();
            int xmitsSubmitted = Math.max((int)((float)this.getXmits() * xmitWeight), 1);
            this.getDatanode().decrementXmitsInProgress(xmitsSubmitted);
            DataNodeMetrics metrics = this.getDatanode().getMetrics();
            metrics.incrECReconstructionTasks();
            metrics.incrECReconstructionBytesRead(this.getBytesRead());
            metrics.incrECReconstructionRemoteBytesRead(this.getRemoteBytesRead());
            metrics.incrECReconstructionBytesWritten(this.getBytesWritten());
            this.getStripedReader().close();
            this.stripedWriter.close();
            this.cleanup();
        }
    }

    @Override
    void reconstruct() throws IOException {
        while (this.getPositionInBlock() < this.getMaxTargetLength()) {
            DataNodeFaultInjector.get().stripedBlockReconstruction();
            long remaining = this.getMaxTargetLength() - this.getPositionInBlock();
            int toReconstructLen = (int)Math.min((long)this.getStripedReader().getBufferSize(), remaining);
            long start = Time.monotonicNow();
            this.getStripedReader().readMinimumSources(toReconstructLen);
            long readEnd = Time.monotonicNow();
            this.reconstructTargets(toReconstructLen);
            long decodeEnd = Time.monotonicNow();
            if (this.stripedWriter.transferData2Targets() == 0) {
                String error = "Transfer failed for all targets.";
                throw new IOException(error);
            }
            long writeEnd = Time.monotonicNow();
            DataNodeMetrics metrics = this.getDatanode().getMetrics();
            metrics.incrECReconstructionReadTime(readEnd - start);
            metrics.incrECReconstructionDecodingTime(decodeEnd - readEnd);
            metrics.incrECReconstructionWriteTime(writeEnd - decodeEnd);
            this.updatePositionInBlock(toReconstructLen);
            this.clearBuffers();
        }
    }

    private void reconstructTargets(int toReconstructLen) throws IOException {
        ByteBuffer[] inputs = this.getStripedReader().getInputBuffers(toReconstructLen);
        int[] erasedIndices = this.stripedWriter.getRealTargetIndices();
        ByteBuffer[] outputs = this.stripedWriter.getRealTargetBuffers(toReconstructLen);
        if (this.isValidationEnabled()) {
            StripedBlockReconstructor.markBuffers(inputs);
            this.decode(inputs, erasedIndices, outputs);
            StripedBlockReconstructor.resetBuffers(inputs);
            DataNodeFaultInjector.get().badDecoding(outputs);
            long start = Time.monotonicNow();
            try {
                this.getValidator().validate(inputs, erasedIndices, outputs);
                long validateEnd = Time.monotonicNow();
                this.getDatanode().getMetrics().incrECReconstructionValidateTime(validateEnd - start);
            }
            catch (InvalidDecodingException e) {
                long validateFailedEnd = Time.monotonicNow();
                this.getDatanode().getMetrics().incrECReconstructionValidateTime(validateFailedEnd - start);
                this.getDatanode().getMetrics().incrECInvalidReconstructionTasks();
                throw e;
            }
        } else {
            this.decode(inputs, erasedIndices, outputs);
        }
        this.stripedWriter.updateRealTargetBuffers(toReconstructLen);
    }

    private void decode(ByteBuffer[] inputs, int[] erasedIndices, ByteBuffer[] outputs) throws IOException {
        long start = System.nanoTime();
        this.getDecoder().decode(inputs, erasedIndices, outputs);
        long end = System.nanoTime();
        this.getDatanode().getMetrics().incrECDecodingTime(end - start);
    }

    private void clearBuffers() {
        this.getStripedReader().clearBuffers();
        this.stripedWriter.clearBuffers();
    }
}

