def writefiles():
    with open('04_md_ntc.reference.xml', 'w') as fd:
        fd.write("""<?xml version="1.0" encoding="UTF-8"?>
<!--

                   ___________________________
                   |                         |
                   | qball alsos             |
                   |                         |
                   |                         |
                   |                         |
                   |                         |
                   |                         |
                   |                         |
                   |                         |
                   |                         |
                   |      Lawrence Livermore |
                   |     National Laboratory |
                   |                         |
                   | Copyright (c) 2003-2016 |
                   |_________________________|

-->
<qbox:simulation xmlns:qbox="http://www.quantum-simulation.org/ns/fpmd/fpmd-1.0">
<release> qball alsos </release>
<npes> 4 </npes>
<nthreads> 1 </nthreads>
<user> xavier </user>
<sysname> Linux </sysname>
<nodename> refri </nodename>
<start_time> 2016-11-26T06:40:35Z </start_time>
<!-- [qball] md.sys -->
<!-- [qball][md.sys] set cell  15.30600000   0.00000000   0.00000000   0.00000000  15.30600000   0.00000000   0.00000000   0.00000000  15.30600000 -->
  <unitcell>
<unit_cell 
    a="15.30600000  0.00000000   0.00000000  "
    b="0.00000000   15.30600000  0.00000000  "
    c="0.00000000   0.00000000   15.30600000 " />
  </unitcell>
<!-- [qball][md.sys] species aluminum Al.xml -->
  <!-- SpeciesCmd: defining species aluminum as Al.xml -->
  <!-- SpeciesReader opening file Al.xml size: 76072 -->
  <!-- SpeciesReader::readSpecies: potential type:  norm-conserving -->
  <!-- SpeciesReader::readSpecies: read description 
 PSGen-1.6.1 pseudopotential: HSCV Al xc=LDA
 Generated by PSGen-1.6.1 on 2009-10-11T04:37:45Z
 psgen arguments:
 -element Al -xc LDA -smooth_v -bound l=0:rc=1.3 -bound l=1:rc=1.6
 -scat l=2:rc=1.6
 -->
  <!-- SpeciesReader::readSpecies: read symbol Al -->
  <!-- SpeciesReader::readSpecies: read atomic_number 13 -->
  <!-- SpeciesReader::readSpecies: read mass 26.98150000 -->
  <!-- SpeciesReader::readSpecies: read valence_charge 3 -->
  <!-- SpeciesReader::readSpecies: read lmax 2 -->
  <!-- SpeciesReader::readSpecies: read llocal 2 -->
  <!-- SpeciesReader::readSpecies: read nquad 0 -->
  <!-- SpeciesReader::readSpecies: read rquad 0.00000000 -->
  <!-- SpeciesReader::readSpecies: read mesh_spacing 0.01000000 -->
  <!-- SpeciesReader::readSpecies: read radial_potential l=0 size=1087 -->
  <!-- SpeciesReader::readSpecies: read radial_function l=0 size=1087 -->
  <!-- SpeciesReader::readSpecies: read radial_potential l=1 size=1087 -->
  <!-- SpeciesReader::readSpecies: read radial_function l=1 size=1087 -->
  <!-- SpeciesReader::readSpecies: read radial_potential l=2 size=1087 -->
<!-- Species aluminum:  extending grid to rmax = 40.00000000 to increase vnlg resolution (4096 pts) -->
SPECIES.ndft = 4096, np = 1087, rmax = 40.96000000, gmax = 314.08256632, hubbard_l = -1
<!-- Kleinman-Bylander normalization term wsg[0] = 5.29180491 -->
<!-- Kleinman-Bylander normalization term wsg[1] = 15.25266347 -->

 species aluminum:
 name_ = aluminum
 description_ = 
 PSGen-1.6.1 pseudopotential: HSCV Al xc=LDA
 Generated by PSGen-1.6.1 on 2009-10-11T04:37:45Z
 psgen arguments:
 -element Al -xc LDA -smooth_v -bound l=0:rc=1.3 -bound l=1:rc=1.6
 -scat l=2:rc=1.6

 uri_ = Al.xml
 symbol_ = Al
 atomic_number_ = 13
 Kleinman-Bylander potential
 valence charge = 3 / ionic mass_ = 26.98150000 (amu)
 lmax_ =   2
 llocal_ = 2
 rcps_ =   1.50000000
<!-- [qball][md.sys] atom Al1 aluminum 0.00000000     0.00000000     0.00000000     0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al2 aluminum 3.82650000     3.82650000     0.00000000     0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al3 aluminum 3.82650000     0.00000000     3.82650000     0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al4 aluminum 0.00000000     3.82650000     3.82650000     0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al5 aluminum -7.65300000    0.00000000     0.00000000     0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al6 aluminum -3.82650000    3.82650000     0.00000000     0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al7 aluminum -3.82650000    0.00000000     3.82650000     0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al8 aluminum -7.65300000    3.82650000     3.82650000     0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al9 aluminum 0.00000000     -7.65300000    0.00000000     0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al10 aluminum 3.82650000     -3.82650000    0.00000000     0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al11 aluminum 3.82650000     -7.65300000    3.82650000     0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al12 aluminum 0.00000000     -3.82650000    3.82650000     0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al13 aluminum 0.00000000     0.00000000     -7.65300000    0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al14 aluminum 3.82650000     3.82650000     -7.65300000    0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al15 aluminum 3.82650000     0.00000000     -3.82650000    0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al16 aluminum 0.00000000     3.82650000     -3.82650000    0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al17 aluminum 0.00000000     -7.65300000    -7.65300000    0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al18 aluminum 3.82650000     -3.82650000    -7.65300000    0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al19 aluminum 3.82650000     -7.65300000    -3.82650000    0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al20 aluminum 0.00000000     -3.82650000    -3.82650000    0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al21 aluminum -7.65300000    0.00000000     -7.65300000    0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al22 aluminum -3.82650000    3.82650000     -7.65300000    0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al23 aluminum -3.82650000    0.00000000     -3.82650000    0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al24 aluminum -7.65300000    3.82650000     -3.82650000    0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al25 aluminum -7.65300000    -7.65300000    0.00000000     0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al26 aluminum -3.82650000    -3.82650000    0.00000000     0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al27 aluminum -3.82650000    -7.65300000    3.82650000     0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al28 aluminum -7.65300000    -3.82650000    3.82650000     0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al29 aluminum -7.65300000    -7.65300000    -7.65300000    0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al30 aluminum -3.82650000    -3.82650000    -7.65300000    0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al31 aluminum -3.82650000    -7.65300000    -3.82650000    0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys] atom Al32 aluminum -7.65300000    -3.82650000    -3.82650000    0.00000000     0.00000000     0.00000000      -->
<!-- [qball][md.sys]  -->
<!-- end of command stream -->
<!-- [qball]  -->
<!-- [qball] set ecut 30 -->
<!-- [qball] set ecutprec 4.0 -->
<!-- [qball] set threshold_scf 1.E-6 5 -->
<!-- [qball]  -->
<!-- [qball] set wf_dyn PSDA -->
<!-- [qball] set nempty 12 -->
<!-- [qball] set smearing fermi -->
<!-- [qball] set smearing_width 0.006333621 -->
<!-- [qball] set charge_mix_coeff 0.6 -->
<!-- [qball]  -->
<!-- [qball] set wf_extrapolation NTC -->
<!-- [qball]  -->
<!-- [qball] set atoms_dyn MD -->
<!-- [qball] set dt 41.341373 -->
<!-- [qball]  -->
<!-- [qball] randomize_v 1000 -->
<WARNING> no such command or file name: randomize_v </WARNING>
<!-- [qball] reset_vcm -->
<!-- [qball]  -->
<!-- [qball] load -states restart/md -->
<!-- Creating SlaterDet context 4x1 from spincontext, ispin = 0 -->
SlaterDet.resize:  new c dimensions = 5020x60   (1255x60 blocks, local data size on pe 0 = 1255x60) -->
<!-- Updated occupation of wf -->
<!-- LoadCmd:  setting MD iteration count to 1. -->
ChargeDensity:  vbasis = 56 56 56, resize to 60 60 60
  <!-- total_electronic_charge: 96.00000000, spin = 0 -->
<!-- LoadCmd:  loading mixed charge density from file. -->
<!--  load timing :    0.1437    0.1459 -->
<!-- [qball]  -->
<!-- [qball] run 20 200 5 -->
SlaterDet.resize:  new c dimensions = 5020x60   (1255x60 blocks, local data size on pe 0 = 1255x60) -->
ChargeDensity:  vbasis = 56 56 56, resize to 60 60 60
  <!-- EnergyFunctional: charge density basis: 39799 plane waves, ngloc = 9942 -->
  <!-- EnergyFunctional: np0v,np1v,np2v: 60 60 60 -->
  <!-- EnergyFunctional: vft->np012(): 216000 -->
<!-- AtomSet.set_rcps:  Ewald width for species aluminum is too small for reciprocal sum convergence, increasing rcps from 1.5000 to 1.0500 -->
<!-- Species aluminum:  extending grid to rmax = 40.0000 to increase vnlg resolution (4096 pts) -->
SPECIES.ndft = 4096, np = 1087, rmax = 40.9600, gmax = 314.0826, hubbard_l = -1
<!-- Kleinman-Bylander normalization term wsg[0] = 5.2918 -->
<!-- Kleinman-Bylander normalization term wsg[1] = 15.2527 -->
<!-- AtomSet.set_rcps:  Ewald width for species aluminum = 1.0500 -->
<!-- EnergyFunctional:  number of images in real-space ewald sum = 0 for rckj = 1.4849 -->
<run niter_ionic="20" niter_scf="200" niter_nonscf="5">
<wavefunction ecut="15.0000" nspin="1" nel="96" nempty="12">
<cell a0="15.306000 0.000000 0.000000"
      a1="0.000000 15.306000 0.000000"
      a2="0.000000 0.000000 15.306000"/>
<reciprocal_lattice b0="0.410505 0.000000 0.000000"
      b1="0.000000 0.410505 0.000000"
      b2="0.000000 0.000000 0.410505"/>
<refcell a0="0.000000 0.000000 0.000000"
         a1="0.000000 0.000000 0.000000"
         a2="0.000000 0.000000 0.000000"/>
<slater_determinant kpoint="0.000000 0.000000 0.000000"  weight="1.000000" size="60">
 <!-- sdcontext: 4x1 -->
<grid nx="28" ny="28" nz="28"/>
 <!-- basis size: 4970 -->
 <!-- c dimensions: 5020x60   (1255x60 blocks) -->
 <density_matrix form="diagonal" size="60">
 </density_matrix>
</slater_determinant>
</wavefunction>
<!-- BOSampleStepper:  fractional occupation detected. -->
SlaterDet.resize:  new c dimensions = 5020x60   (1255x60 blocks, local data size on pe 0 = 1255x60) -->
 <!-- Wavefunction::update_occ: sum = 96.000000 -->
 <!-- Wavefunction::update_occ: using Fermi smearing, mu = 5.2701 eV, ispin = 0 -->
SlaterDet.resize:  new c dimensions = 5020x60   (1255x60 blocks, local data size on pe 0 = 1255x60) -->
SlaterDet.resize:  new c dimensions = 5020x60   (1255x60 blocks, local data size on pe 0 = 1255x60) -->
SlaterDet.resize:  new c dimensions = 5020x60   (1255x60 blocks, local data size on pe 0 = 1255x60) -->
<iteration count="1">
  <!-- total_electronic_charge: 96.00000000, spin = 0 -->
  <ekin>       27.68898842 </ekin>
  <eps>        -5.91921370 </eps>
  <enl>        11.87213023 </enl>
  <ecoul>     -74.73821340 </ecoul>
  <exc>       -25.63679332 </exc>
  <esr>         0.00008151 </esr>
  <eself>     109.42416834 </eself>
  <ets>        -0.02644462 </ets>
  <etotal>    -66.75954638 </etotal>
<atomset>
<unit_cell 
    a=" 15.30600000   0.00000000   0.00000000"
    b="  0.00000000  15.30600000   0.00000000"
    c="  0.00000000   0.00000000  15.30600000" />
  <atom name="Al1" species="aluminum">
    <position> 0.00000000 0.00000000 0.00000000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000092 0.00000198 -0.00000107 </force>
  </atom>
  <atom name="Al2" species="aluminum">
    <position> 3.82650000 3.82650000 0.00000000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> -0.00000026 -0.00000085 0.00000007 </force>
  </atom>
  <atom name="Al3" species="aluminum">
    <position> 3.82650000 0.00000000 3.82650000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000003 -0.00000241 -0.00000050 </force>
  </atom>
  <atom name="Al4" species="aluminum">
    <position> 0.00000000 3.82650000 3.82650000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> -0.00000422 0.00000064 0.00000011 </force>
  </atom>
  <atom name="Al5" species="aluminum">
    <position> -7.65300000 0.00000000 0.00000000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> -0.00000028 0.00000132 -0.00000007 </force>
  </atom>
  <atom name="Al6" species="aluminum">
    <position> -3.82650000 3.82650000 0.00000000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000026 -0.00000043 0.00000042 </force>
  </atom>
  <atom name="Al7" species="aluminum">
    <position> -3.82650000 0.00000000 3.82650000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000007 0.00000223 0.00000071 </force>
  </atom>
  <atom name="Al8" species="aluminum">
    <position> -7.65300000 3.82650000 3.82650000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000420 0.00000104 -0.00000012 </force>
  </atom>
  <atom name="Al9" species="aluminum">
    <position> 0.00000000 -7.65300000 0.00000000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000042 0.00000180 0.00000103 </force>
  </atom>
  <atom name="Al10" species="aluminum">
    <position> 3.82650000 -3.82650000 0.00000000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000020 -0.00000060 -0.00000004 </force>
  </atom>
  <atom name="Al11" species="aluminum">
    <position> 3.82650000 -7.65300000 3.82650000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> -0.00000013 0.00000233 -0.00000075 </force>
  </atom>
  <atom name="Al12" species="aluminum">
    <position> 0.00000000 -3.82650000 3.82650000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000162 -0.00000010 -0.00000045 </force>
  </atom>
  <atom name="Al13" species="aluminum">
    <position> 0.00000000 0.00000000 -7.65300000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> -0.00000067 -0.00000127 0.00000034 </force>
  </atom>
  <atom name="Al14" species="aluminum">
    <position> 3.82650000 3.82650000 -7.65300000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000030 0.00000060 -0.00000010 </force>
  </atom>
  <atom name="Al15" species="aluminum">
    <position> 3.82650000 0.00000000 -3.82650000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000026 -0.00000242 0.00000019 </force>
  </atom>
  <atom name="Al16" species="aluminum">
    <position> 0.00000000 3.82650000 -3.82650000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> -0.00000180 -0.00000060 -0.00000033 </force>
  </atom>
  <atom name="Al17" species="aluminum">
    <position> 0.00000000 -7.65300000 -7.65300000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> -0.00000135 -0.00000147 -0.00000054 </force>
  </atom>
  <atom name="Al18" species="aluminum">
    <position> 3.82650000 -3.82650000 -7.65300000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000020 0.00000118 0.00000081 </force>
  </atom>
  <atom name="Al19" species="aluminum">
    <position> 3.82650000 -7.65300000 -3.82650000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000030 0.00000289 -0.00000019 </force>
  </atom>
  <atom name="Al20" species="aluminum">
    <position> 0.00000000 -3.82650000 -3.82650000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000387 0.00000008 -0.00000021 </force>
  </atom>
  <atom name="Al21" species="aluminum">
    <position> -7.65300000 0.00000000 -7.65300000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> -0.00000054 -0.00000264 -0.00000025 </force>
  </atom>
  <atom name="Al22" species="aluminum">
    <position> -3.82650000 3.82650000 -7.65300000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000039 0.00000123 -0.00000093 </force>
  </atom>
  <atom name="Al23" species="aluminum">
    <position> -3.82650000 0.00000000 -3.82650000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000021 0.00000206 0.00000002 </force>
  </atom>
  <atom name="Al24" species="aluminum">
    <position> -7.65300000 3.82650000 -3.82650000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000131 -0.00000054 0.00000079 </force>
  </atom>
  <atom name="Al25" species="aluminum">
    <position> -7.65300000 -7.65300000 0.00000000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000043 0.00000109 0.00000036 </force>
  </atom>
  <atom name="Al26" species="aluminum">
    <position> -3.82650000 -3.82650000 0.00000000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> -0.00000036 -0.00000068 0.00000013 </force>
  </atom>
  <atom name="Al27" species="aluminum">
    <position> -3.82650000 -7.65300000 3.82650000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000009 -0.00000298 0.00000033 </force>
  </atom>
  <atom name="Al28" species="aluminum">
    <position> -7.65300000 -3.82650000 3.82650000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> -0.00000169 -0.00000007 0.00000048 </force>
  </atom>
  <atom name="Al29" species="aluminum">
    <position> -7.65300000 -7.65300000 -7.65300000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000022 -0.00000153 0.00000049 </force>
  </atom>
  <atom name="Al30" species="aluminum">
    <position> -3.82650000 -3.82650000 -7.65300000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000019 0.00000063 0.00000014 </force>
  </atom>
  <atom name="Al31" species="aluminum">
    <position> -3.82650000 -7.65300000 -3.82650000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00000015 -0.00000228 -0.00000033 </force>
  </atom>
  <atom name="Al32" species="aluminum">
    <position> -7.65300000 -3.82650000 -3.82650000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> -0.00000438 0.00000059 -0.00000050 </force>
  </atom>
</atomset>
  <econst> -66.75954638 </econst>
  <ekin_ion> 0.00000000 </ekin_ion>
  <temp_ion> 0.00000000 </temp_ion>
<!-- EnergyFunctional:  number of images in real-space ewald sum = 0 for rckj = 1.48492424 -->
Extrapolating wavefunction using NTC algorithm.
  <!-- BOSampleStepper: start scf iteration -->
  <!-- total_electronic_charge: 96.00000000, spin = 0 -->
  <eigenvalue_sum> 4.10150168 </eigenvalue_sum>
  <etotal_int scf_iter="0">    -66.75954638 </etotal_int>
  <eharris>    -66.75954638 </eharris>
  <eigenvalue_sum> 4.10148751 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 5.70200055 ( using 2.00000000 ) -->
  <etotal_int scf_iter="0">    -66.75954714 </etotal_int>
  <eigenvalue_sum> 4.10144502 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 1.61523684 ( using 1.61523684 ) -->
  <etotal_int scf_iter="0">    -66.75954876 </etotal_int>
  <eigenvalue_sum> 4.10136224 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 0.35699216 ( using 0.35699216 ) -->
  <etotal_int scf_iter="0">    -66.75955070 </etotal_int>
  <eigenvalue_sum> 4.10131852 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 5.17847633 ( using 2.00000000 ) -->
  <etotal_int scf_iter="0">    -66.75955072 </etotal_int>
  <eigenvalues spin="0" kpoint="0.00000000 0.00000000 0.00000000" n="60">
    -6.01941    -3.77018    -3.77016    -3.77015    -3.77014    -3.77014    -3.77011    -1.56567
    -1.56567    -1.56567    -1.56565    -1.56564    -1.56563    -1.56563    -1.56563    -1.56563
    -1.56562    -1.56561    -1.56561     0.55800     0.55800     0.55800     0.55801     0.64516
     0.64517     0.64517     0.64518     2.19316     2.19316     2.19316     3.41195     3.41196
     3.41197     4.23705     4.23706     4.23708     4.23708     4.23708     4.23709     4.23709
     4.23710     4.23710     4.23710     4.23710     4.23711     5.27016     5.27018     5.27018
     5.27018     5.27018     5.27020     5.95408     5.95409     5.95411     5.96335     5.97193
     6.25325     6.29425     6.29425     6.29426
  </eigenvalues>
 <!-- Wavefunction::update_occ: sum = 96.00000 -->
 <!-- Wavefunction::update_occ: using Fermi smearing, mu = 5.2701 eV, ispin = 0 -->
  <occupation spin="0" kpoint="0.00000000 0.00000000 0.00000000" n="60">
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  0.9996  0.9995  0.9995  0.9995  0.9994
  0.9993  0.0007  0.0007  0.0007  0.0006  0.0006  0.0000  0.0000  0.0000  0.0000
  </occupation>
  <!-- Wavefunction entropy: 8.35076163 -->
  <!-- Entropy contribution to free energy: -0.10578112 -->
  <!-- BOSampleStepper: end scf iteration -->
  <!-- BOSampleStepper: start scf iteration -->
  <!-- total_electronic_charge: 96.00000000, spin = 0 -->
  <eigenvalue_sum> 4.10121661 </eigenvalue_sum>
  <etotal_int scf_iter="1">    -66.75954511 </etotal_int>
  <eharris>    -66.75954647 </eharris>
  <eigenvalue_sum> 4.10120243 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 6.69459583 ( using 2.00000000 ) -->
  <etotal_int scf_iter="1">    -66.75954471 </etotal_int>
  <eigenvalue_sum> 4.10115985 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 2.00766753 ( using 2.00000000 ) -->
  <etotal_int scf_iter="1">    -66.75954378 </etotal_int>
  <eigenvalue_sum> 4.10106040 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 0.31723118 ( using 0.31723118 ) -->
  <etotal_int scf_iter="1">    -66.75954216 </etotal_int>
  <eigenvalue_sum> 4.10101456 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 5.39166432 ( using 2.00000000 ) -->
  <etotal_int scf_iter="1">    -66.75954191 </etotal_int>
  <eigenvalues spin="0" kpoint="0.00000000 0.00000000 0.00000000" n="60">
    -6.01941    -3.77020    -3.77014    -3.77014    -3.77014    -3.77013    -3.77012    -1.56569
    -1.56568    -1.56567    -1.56565    -1.56563    -1.56563    -1.56562    -1.56562    -1.56562
    -1.56562    -1.56561    -1.56561     0.55799     0.55800     0.55800     0.55801     0.64516
     0.64516     0.64516     0.64520     2.19316     2.19316     2.19316     3.41195     3.41196
     3.41197     4.23705     4.23706     4.23707     4.23708     4.23708     4.23709     4.23709
     4.23710     4.23711     4.23711     4.23711     4.23711     5.27016     5.27018     5.27018
     5.27018     5.27019     5.27019     5.95409     5.95409     5.95411     5.96220     5.96971
     6.24822     6.29424     6.29425     6.29426
  </eigenvalues>
 <!-- Wavefunction::update_occ: sum = 96.00000 -->
 <!-- Wavefunction::update_occ: using Fermi smearing, mu = 5.2701 eV, ispin = 0 -->
  <occupation spin="0" kpoint="0.00000000 0.00000000 0.00000000" n="60">
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  0.9996  0.9995  0.9995  0.9995  0.9994
  0.9994  0.0007  0.0007  0.0007  0.0006  0.0006  0.0000  0.0000  0.0000  0.0000
  </occupation>
  <!-- Wavefunction entropy: 8.35096795 -->
  <!-- Entropy contribution to free energy: -0.10578373 -->
  <!-- BOSampleStepper: end scf iteration -->
  <!-- BOSampleStepper: start scf iteration -->
  <!-- total_electronic_charge: 96.00000000, spin = 0 -->
 AndersonMixer: theta = 0.39164250 
  <eigenvalue_sum> 4.10090858 </eigenvalue_sum>
  <etotal_int scf_iter="2">    -66.75953866 </etotal_int>
  <eharris>    -66.75954655 </eharris>
  <eigenvalue_sum> 4.10089424 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 8.26400053 ( using 2.00000000 ) -->
  <etotal_int scf_iter="2">    -66.75953884 </etotal_int>
  <eigenvalue_sum> 4.10085119 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 2.72962226 ( using 2.00000000 ) -->
  <etotal_int scf_iter="2">    -66.75953921 </etotal_int>
  <eigenvalue_sum> 4.10075049 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 0.80153834 ( using 0.80153834 ) -->
  <etotal_int scf_iter="2">    -66.75953970 </etotal_int>
  <eigenvalue_sum> 4.10065506 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 1.50926656 ( using 1.50926656 ) -->
  <etotal_int scf_iter="2">    -66.75953975 </etotal_int>
  <eigenvalues spin="0" kpoint="0.00000000 0.00000000 0.00000000" n="60">
    -6.01941    -3.77018    -3.77016    -3.77014    -3.77014    -3.77014    -3.77012    -1.56568
    -1.56566    -1.56566    -1.56565    -1.56565    -1.56563    -1.56563    -1.56563    -1.56562
    -1.56562    -1.56562    -1.56561     0.55799     0.55800     0.55800     0.55801     0.64516
     0.64516     0.64516     0.64519     2.19316     2.19316     2.19316     3.41195     3.41196
     3.41197     4.23706     4.23707     4.23707     4.23708     4.23709     4.23709     4.23709
     4.23710     4.23710     4.23710     4.23711     4.23711     5.27017     5.27018     5.27018
     5.27018     5.27018     5.27019     5.95408     5.95409     5.95411     5.96086     5.96720
     6.24086     6.29425     6.29425     6.29425
  </eigenvalues>
 <!-- Wavefunction::update_occ: sum = 96.00000 -->
 <!-- Wavefunction::update_occ: using Fermi smearing, mu = 5.2701 eV, ispin = 0 -->
  <occupation spin="0" kpoint="0.00000000 0.00000000 0.00000000" n="60">
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  0.9995  0.9995  0.9995  0.9994  0.9994
  0.9994  0.0007  0.0007  0.0007  0.0007  0.0006  0.0000  0.0000  0.0000  0.0000
  </occupation>
  <!-- Wavefunction entropy: 8.35121662 -->
  <!-- Entropy contribution to free energy: -0.10578688 -->
  <!-- BOSampleStepper: end scf iteration -->
  <!-- BOSampleStepper: start scf iteration -->
  <!-- total_electronic_charge: 96.00000000, spin = 0 -->
 AndersonMixer: theta = 0.49266292 0.22500301 
  <eigenvalue_sum> 4.10049589 </eigenvalue_sum>
  <etotal_int scf_iter="3">    -66.75953421 </etotal_int>
  <eharris>    -66.75954664 </eharris>
  <eigenvalue_sum> 4.10048119 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 6.65291036 ( using 2.00000000 ) -->
  <etotal_int scf_iter="3">    -66.75953394 </etotal_int>
  <eigenvalue_sum> 4.10043699 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 1.94870971 ( using 1.94870971 ) -->
  <etotal_int scf_iter="3">    -66.75953329 </etotal_int>
  <eigenvalue_sum> 4.10033577 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 0.30628959 ( using 0.30628959 ) -->
  <etotal_int scf_iter="3">    -66.75953216 </etotal_int>
  <eigenvalue_sum> 4.10028973 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 6.70052592 ( using 2.00000000 ) -->
  <etotal_int scf_iter="3">    -66.75953196 </etotal_int>
  <eigenvalues spin="0" kpoint="0.00000000 0.00000000 0.00000000" n="60">
    -6.01941    -3.77018    -3.77015    -3.77014    -3.77014    -3.77014    -3.77012    -1.56568
    -1.56567    -1.56566    -1.56565    -1.56565    -1.56563    -1.56562    -1.56562    -1.56562
    -1.56562    -1.56562    -1.56561     0.55799     0.55800     0.55800     0.55801     0.64516
     0.64516     0.64516     0.64519     2.19316     2.19316     2.19316     3.41195     3.41196
     3.41197     4.23706     4.23707     4.23708     4.23708     4.23708     4.23709     4.23709
     4.23710     4.23710     4.23710     4.23711     4.23711     5.27017     5.27018     5.27018
     5.27018     5.27018     5.27019     5.95408     5.95409     5.95410     5.96002     5.96560
     6.23476     6.29425     6.29425     6.29426
  </eigenvalues>
 <!-- Wavefunction::update_occ: sum = 96.00000 -->
 <!-- Wavefunction::update_occ: using Fermi smearing, mu = 5.2701 eV, ispin = 0 -->
  <occupation spin="0" kpoint="0.00000000 0.00000000 0.00000000" n="60">
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  0.9995  0.9995  0.9995  0.9994  0.9994
  0.9994  0.0007  0.0007  0.0007  0.0007  0.0006  0.0000  0.0000  0.0000  0.0000
  </occupation>
  <!-- Wavefunction entropy: 8.35138168 -->
  <!-- Entropy contribution to free energy: -0.10578897 -->
  <!-- BOSampleStepper: end scf iteration -->
  <!-- BOSampleStepper: start scf iteration -->
  <!-- total_electronic_charge: 96.00000000, spin = 0 -->
 AndersonMixer: theta = -0.61089823 0.34695262 0.57008570 
  <eigenvalue_sum> 4.10018240 </eigenvalue_sum>
  <etotal_int scf_iter="4">    -66.75952718 </etotal_int>
  <eharris>    -66.75954671 </eharris>
  <eigenvalue_sum> 4.10016729 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 8.02944050 ( using 2.00000000 ) -->
  <etotal_int scf_iter="4">    -66.75952727 </etotal_int>
  <eigenvalue_sum> 4.10012185 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 2.64681535 ( using 2.00000000 ) -->
  <etotal_int scf_iter="4">    -66.75952745 </etotal_int>
  <eigenvalue_sum> 4.10001534 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 0.78177714 ( using 0.78177714 ) -->
  <etotal_int scf_iter="4">    -66.75952766 </etotal_int>
  <eigenvalue_sum> 4.09991622 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 1.76833136 ( using 1.76833136 ) -->
  <etotal_int scf_iter="4">    -66.75952763 </etotal_int>
  <eigenvalues spin="0" kpoint="0.00000000 0.00000000 0.00000000" n="60">
    -6.01941    -3.77017    -3.77016    -3.77014    -3.77014    -3.77014    -3.77012    -1.56567
    -1.56566    -1.56565    -1.56565    -1.56565    -1.56563    -1.56563    -1.56563    -1.56562
    -1.56562    -1.56562    -1.56561     0.55799     0.55800     0.55800     0.55801     0.64516
     0.64516     0.64517     0.64519     2.19316     2.19316     2.19316     3.41195     3.41196
     3.41197     4.23706     4.23707     4.23707     4.23708     4.23709     4.23709     4.23709
     4.23710     4.23710     4.23710     4.23711     4.23711     5.27017     5.27018     5.27018
     5.27018     5.27018     5.27019     5.95408     5.95409     5.95410     5.95899     5.96364
     6.22528     6.29425     6.29425     6.29425
  </eigenvalues>
 <!-- Wavefunction::update_occ: sum = 96.00000 -->
 <!-- Wavefunction::update_occ: using Fermi smearing, mu = 5.2701 eV, ispin = 0 -->
  <occupation spin="0" kpoint="0.00000000 0.00000000 0.00000000" n="60">
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  0.9995  0.9995  0.9994  0.9994  0.9994
  0.9994  0.0007  0.0007  0.0007  0.0007  0.0006  0.0000  0.0000  0.0000  0.0000
  </occupation>
  <!-- Wavefunction entropy: 8.35159730 -->
  <!-- Entropy contribution to free energy: -0.10579170 -->
  <!-- BOSampleStepper: end scf iteration -->
  <!-- BOSampleStepper: start scf iteration -->
  <!-- total_electronic_charge: 95.99999999, spin = 0 -->
 AndersonMixer: theta = 0.31564175 0.69739118 0.16503012 
  <eigenvalue_sum> 4.09972400 </eigenvalue_sum>
  <etotal_int scf_iter="5">    -66.75952475 </etotal_int>
  <eharris>    -66.75954679 </eharris>
  <eigenvalue_sum> 4.09970819 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 5.90720698 ( using 2.00000000 ) -->
  <etotal_int scf_iter="5">    -66.75952460 </etotal_int>
  <eigenvalue_sum> 4.09966063 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 1.58220995 ( using 1.58220995 ) -->
  <etotal_int scf_iter="5">    -66.75952422 </etotal_int>
  <eigenvalue_sum> 4.09956910 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 0.26624188 ( using 0.26624188 ) -->
  <etotal_int scf_iter="5">    -66.75952363 </etotal_int>
  <eigenvalue_sum> 4.09952854 </eigenvalue_sum>
  <!-- Anderson extrapolation: theta = 6.82547046 ( using 2.00000000 ) -->
  <etotal_int scf_iter="5">    -66.75952350 </etotal_int>
  <eigenvalues spin="0" kpoint="0.00000000 0.00000000 0.00000000" n="60">
    -6.01941    -3.77018    -3.77015    -3.77014    -3.77014    -3.77014    -3.77012    -1.56568
    -1.56567    -1.56566    -1.56565    -1.56564    -1.56563    -1.56563    -1.56562    -1.56562
    -1.56562    -1.56562    -1.56561     0.55799     0.55800     0.55800     0.55801     0.64516
     0.64516     0.64516     0.64519     2.19316     2.19316     2.19316     3.41195     3.41196
     3.41197     4.23705     4.23706     4.23708     4.23708     4.23708     4.23709     4.23709
     4.23710     4.23710     4.23710     4.23711     4.23711     5.27017     5.27018     5.27018
     5.27018     5.27018     5.27019     5.95408     5.95409     5.95410     5.95847     5.96261
     6.21886     6.29425     6.29425     6.29426
  </eigenvalues>
 <!-- Wavefunction::update_occ: sum = 96.00000 -->
 <!-- Wavefunction::update_occ: using Fermi smearing, mu = 5.2701 eV, ispin = 0 -->
  <occupation spin="0" kpoint="0.00000000 0.00000000 0.00000000" n="60">
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000  2.0000
  2.0000  2.0000  2.0000  2.0000  2.0000  0.9995  0.9994  0.9994  0.9994  0.9994
  0.9994  0.0007  0.0007  0.0007  0.0007  0.0006  0.0000  0.0000  0.0000  0.0000
  </occupation>
  <!-- Wavefunction entropy: 8.35171796 -->
  <!-- Entropy contribution to free energy: -0.10579323 -->
  <!-- BOSampleStepper: end scf iteration -->
  <!-- BOSampleStepper: scf convergence at itscf = 6, Harris-Foulkes energy varied by less than 1.00e-06 a.u. over 5 scf steps. -->
<timing where="run"                name=" iteration"       min="4.585e+00" max="4.585e+00" count="1        "/>
</iteration>
<!-- memory nlp.twnl    :    0.152 MB  (0.038 MB local) -->
<!-- memory sd.psi      :    4.550 MB  (1.133 MB local) -->
<!-- memory sd.hpsi     :    4.550 MB  (1.133 MB local) -->
<!-- memory cd.rhor     :    1.648 MB  (0.412 MB local) -->
<!-- memory cd.rhog     :    0.607 MB  (0.152 MB local) -->
<!-- memory total       :   11.507 MB  (2.866 MB local) -->
  <!-- total_electronic_charge: 96.00000000, spin = 0 -->
  <!-- total_electronic_charge: 96.00000000, spin = 0 -->
</run>
<!-- [qball]  -->
<!-- end of command stream -->
<real_time> 104.00126290 </real_time>
<end_time> 2016-11-26T06:42:19Z </end_time>
</qbox:simulation>
""")

    with open('test.xml', 'w') as fd:
        fd.write("""<?xml version="1.0" encoding="UTF-8"?>
<fpmd:simulation xmlns:fpmd="http://www.quantum-simulation.org/ns/fpmd/fpmd-1.0">
<uuid> 5bd1acfc-88da-11e7-bb1d-fa163ec3a82b </uuid>

                   ============================
                   I qbox 1.63.8              I
                   I                          I
                   I                          I
                   I                          I
                   I                          I
                   I                          I
                   I                          I
                   I                          I
                   I                          I
                   I                          I
                   I                          I
                   I                          I
                   I http://qboxcode.org      I
                   ============================


<release> 1.63.8 centos7 </release>
<user> wardlt </user>
<sysname> Linux </sysname>
<nodename> js-168-106.jetstream-cloud.org </nodename>
<start_time> 2017-08-24T14:41:48Z </start_time>
<mpi_processes count="24">
<process id="0"> js-168-106.jetstream-cloud.org </process>
<process id="1"> js-168-106.jetstream-cloud.org </process>
<process id="2"> js-168-106.jetstream-cloud.org </process>
<process id="3"> js-168-106.jetstream-cloud.org </process>
<process id="4"> js-168-106.jetstream-cloud.org </process>
<process id="5"> js-168-106.jetstream-cloud.org </process>
<process id="6"> js-168-106.jetstream-cloud.org </process>
<process id="7"> js-168-106.jetstream-cloud.org </process>
<process id="8"> js-168-106.jetstream-cloud.org </process>
<process id="9"> js-168-106.jetstream-cloud.org </process>
<process id="10"> js-168-106.jetstream-cloud.org </process>
<process id="11"> js-168-106.jetstream-cloud.org </process>
<process id="12"> js-168-106.jetstream-cloud.org </process>
<process id="13"> js-168-106.jetstream-cloud.org </process>
<process id="14"> js-168-106.jetstream-cloud.org </process>
<process id="15"> js-168-106.jetstream-cloud.org </process>
<process id="16"> js-168-106.jetstream-cloud.org </process>
<process id="17"> js-168-106.jetstream-cloud.org </process>
<process id="18"> js-168-106.jetstream-cloud.org </process>
<process id="19"> js-168-106.jetstream-cloud.org </process>
<process id="20"> js-168-106.jetstream-cloud.org </process>
<process id="21"> js-168-106.jetstream-cloud.org </process>
<process id="22"> js-168-106.jetstream-cloud.org </process>
<process id="23"> js-168-106.jetstream-cloud.org </process>
</mpi_processes>
[qbox] <cmd># Si4 CP dynamics</cmd>
[qbox] <cmd>load ../si4gs/test.xml</cmd>
 LoadCmd: loading from ../si4gs/test.xml
 XMLGFPreprocessor: reading from ../si4gs/test.xml size: 358009
 XMLGFPreprocessor: read time: 0.00014
 XMLGFPreprocessor: local read rate: 101.6 MB/s  aggregate read rate: 2440 MB/s
 XMLGFPreprocessor: tag fixing time: 8.607e-05
 XMLGFPreprocessor: segment definition time: 0.001074
 XMLGFPreprocessor: boundary adjustment time: 4.053e-06
 XMLGFPreprocessor: transcoding time: 3.099e-06
 XMLGFPreprocessor: data redistribution time: 0.001073
 XMLGFPreprocessor: XML compacting time: 0.0005789
 XMLGFPreprocessor: total time: 0.003368
 xmlcontent.size(): 120537
 Starting XML parsing

 species silicon:
<species name="silicon">
 <description>
Translated from UPF format by upf2qso
Generated using unknown code
Author: Von Barth-Car ( 1984)
Info: automatically converted from PWSCF format
    0        The Pseudo was generated with a Non-Relativistic Calculation
  0.00000000000E+00    Local Potential cutoff radius
nl pn  l   occ               Rcut            Rcut US             E pseu
3S  0  0  2.00      0.00000000000      0.00000000000      0.00000000000
3P  0  1  2.00      0.00000000000      0.00000000000      0.00000000000
SLA PZ NOGX NOGC
 </description>
 <symbol>Si</symbol>
 <atomic_number>14</atomic_number>
 <mass>28.09</mass>
 <norm_conserving_pseudopotential>
 <valence_charge>4</valence_charge>
 <lmax>2</lmax>
 <llocal>2</llocal>
 <nquad>0</nquad>
 <rquad>0</rquad>
 <mesh_spacing>0.01</mesh_spacing>
 </norm_conserving_pseudopotential>
</species>
 Kleinman-Bylander potential
 rcps_ =   1.5
 WavefunctionHandler::startElement: wavefunction nspin=1 nel=16 nempty=0
 WavefunctionHandler::startElement: slater_determinant
 kpoint=0 0 0 weight=1 size=8
 WavefunctionHandler::endElement: slater_determinant
 XML parsing done
 SampleReader: read time: 0.03573 s
[qbox] <cmd>set wf_dyn MD</cmd>
[qbox] <cmd>set atoms_dyn MD</cmd>
[qbox] <cmd>set dt 4</cmd>
[qbox] <cmd>set stress ON</cmd>
[qbox] <cmd>run 5</cmd>
  EnergyFunctional: np0v,np1v,np2v: 30 30 30
  EnergyFunctional: vft->np012(): 27000
<wavefunction ecut="3" nspin="1" nel="16" nempty="0">
<cell a="16.000000 0.000000 0.000000"
      b="0.000000 16.000000 0.000000"
      c="0.000000 0.000000 16.000000"/>
 reciprocal lattice vectors
 0.392699 0.000000 0.000000
 0.000000 0.392699 0.000000
 0.000000 0.000000 0.392699
<refcell a="0.000000 0.000000 0.000000"
         b="0.000000 0.000000 0.000000"
         c="0.000000 0.000000 0.000000"/>
<grid nx="14" ny="14" nz="14"/>
 kpoint: 0.000000 0.000000 0.000000 weight: 1.000000
<slater_determinant kpoint="0.000000 0.000000 0.000000" size="8">
 sdcontext: 24x1
 basis size: 511
 c dimensions: 696x8   (29x8 blocks)
 <density_matrix form="diagonal" size="8">
 </density_matrix>
</slater_determinant>
</wavefunction>
  total_electronic_charge: 16.00000000
<iteration count="1">
  <ekin>         5.34839594 </ekin>
  <econf>        0.00000000 </econf>
  <eps>         -5.48138503 </eps>
  <enl>          4.77521434 </enl>
  <ecoul>      -15.60248424 </ecoul>
  <exc>         -4.41268616 </exc>
  <esr>          0.07326880 </esr>
  <eself>       17.02153730 </eself>
  <ets>          0.00000000 </ets>
  <eexf>         0.00000000 </eexf>
  <etotal>     -15.37294515 </etotal>
  <epv>          0.00000000 </epv>
  <eefield>      0.00000000 </eefield>
  <enthalpy>   -15.37294515 </enthalpy>
<atomset>
<unit_cell 
    a=" 16.00000000   0.00000000   0.00000000"
    b="  0.00000000  16.00000000   0.00000000"
    c="  0.00000000   0.00000000  16.00000000" />
  <atom name="Si1" species="silicon">
    <position> 3.70000044 -0.00000000 -0.00000000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> 0.00284439 -0.00000004 -0.00000759 </force>
  </atom>
  <atom name="Si2" species="silicon">
    <position> -0.00000000 2.20000267 0.00000000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> -0.00000030 0.01705795 0.00000984 </force>
  </atom>
  <atom name="Si3" species="silicon">
    <position> -3.70000044 -0.00000000 -0.00000000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> -0.00284289 -0.00000006 -0.00000896 </force>
  </atom>
  <atom name="Si4" species="silicon">
    <position> -0.00000000 -2.20000267 0.00000000 </position>
    <velocity> 0.00000000 0.00000000 0.00000000 </velocity>
    <force> -0.00000029 -0.01705787 0.00000764 </force>
  </atom>
</atomset>
  <ekin_e> 0.00000000 </ekin_e>
  <ekin_ion> 0.00000000 </ekin_ion>
  <temp_ion> 0.00000000 </temp_ion>
  <eta_ion> 0.00000000 </eta_ion>
  <econst> -15.37294515 </econst>
  <ekin_ec> -15.37294515 </ekin_ec>
 <stress_tensor unit="GPa">
   <sigma_eks_xx>  -0.40316092 </sigma_eks_xx>
   <sigma_eks_yy>  -1.11691203 </sigma_eks_yy>
   <sigma_eks_zz>  -1.39125067 </sigma_eks_zz>
   <sigma_eks_xy>  -0.00000015 </sigma_eks_xy>
   <sigma_eks_yz>   0.00001892 </sigma_eks_yz>
   <sigma_eks_xz>  -0.00002269 </sigma_eks_xz>

   <sigma_kin_xx>   0.00000000 </sigma_kin_xx>
   <sigma_kin_yy>   0.00000000 </sigma_kin_yy>
   <sigma_kin_zz>   0.00000000 </sigma_kin_zz>
   <sigma_kin_xy>   0.00000000 </sigma_kin_xy>
   <sigma_kin_yz>   0.00000000 </sigma_kin_yz>
   <sigma_kin_xz>   0.00000000 </sigma_kin_xz>

   <sigma_ext_xx>   0.00000000 </sigma_ext_xx>
   <sigma_ext_yy>   0.00000000 </sigma_ext_yy>
   <sigma_ext_zz>   0.00000000 </sigma_ext_zz>
   <sigma_ext_xy>   0.00000000 </sigma_ext_xy>
   <sigma_ext_yz>   0.00000000 </sigma_ext_yz>
   <sigma_ext_xz>   0.00000000 </sigma_ext_xz>

   <sigma_xx>  -0.40316092 </sigma_xx>
   <sigma_yy>  -1.11691203 </sigma_yy>
   <sigma_zz>  -1.39125067 </sigma_zz>
   <sigma_xy>  -0.00000015 </sigma_xy>
   <sigma_yz>   0.00001892 </sigma_yz>
   <sigma_xz>  -0.00002269 </sigma_xz>
 </stress_tensor>
  total_electronic_charge: 16.00000000
</iteration>
<timing name="iteration"       min="0.003" max="0.003"/>
<iteration count="2">
  <ekin>         5.34839594 </ekin>
  <econf>        0.00000000 </econf>
  <eps>         -5.48138456 </eps>
  <enl>          4.77521478 </enl>
  <ecoul>      -15.60248525 </ecoul>
  <exc>         -4.41268616 </exc>
  <esr>          0.07326840 </esr>
  <eself>       17.02153730 </eself>
  <ets>          0.00000000 </ets>
  <eexf>         0.00000000 </eexf>
  <etotal>     -15.37294524 </etotal>
  <epv>          0.00000000 </epv>
  <eefield>      0.00000000 </eefield>
  <enthalpy>   -15.37294524 </enthalpy>
<atomset>
<unit_cell 
    a=" 16.00000000   0.00000000   0.00000000"
    b="  0.00000000  16.00000000   0.00000000"
    c="  0.00000000   0.00000000  16.00000000" />
  <atom name="Si1" species="silicon">
    <position> 3.70000178 -0.00000000 -0.00000000 </position>
    <velocity> 0.00000022 -0.00000000 -0.00000000 </velocity>
    <force> 0.00284244 -0.00000004 -0.00000759 </force>
  </atom>
  <atom name="Si2" species="silicon">
    <position> -0.00000000 2.20001066 0.00000001 </position>
    <velocity> -0.00000000 0.00000133 0.00000000 </velocity>
    <force> -0.00000030 0.01705370 0.00000982 </force>
  </atom>
  <atom name="Si3" species="silicon">
    <position> -3.70000178 -0.00000000 -0.00000001 </position>
    <velocity> -0.00000022 -0.00000000 -0.00000000 </velocity>
    <force> -0.00284094 -0.00000006 -0.00000895 </force>
  </atom>
  <atom name="Si4" species="silicon">
    <position> -0.00000000 -2.20001066 0.00000000 </position>
    <velocity> -0.00000000 -0.00000133 0.00000000 </velocity>
    <force> -0.00000029 -0.01705361 0.00000763 </force>
  </atom>
</atomset>
  <ekin_e> 0.00000000 </ekin_e>
  <ekin_ion> 0.00000009 </ekin_ion>
  <temp_ion> 0.00491777 </temp_ion>
  <eta_ion> 0.00000000 </eta_ion>
  <econst> -15.37294515 </econst>
  <ekin_ec> -15.37294515 </ekin_ec>
 <stress_tensor unit="GPa">
   <sigma_eks_xx>  -0.40318581 </sigma_eks_xx>
   <sigma_eks_yy>  -1.11691708 </sigma_eks_yy>
   <sigma_eks_zz>  -1.39122938 </sigma_eks_zz>
   <sigma_eks_xy>  -0.00000015 </sigma_eks_xy>
   <sigma_eks_yz>   0.00001885 </sigma_eks_yz>
   <sigma_eks_xz>  -0.00002278 </sigma_eks_xz>

   <sigma_kin_xx>   0.00000004 </sigma_kin_xx>
   <sigma_kin_yy>   0.00000131 </sigma_kin_yy>
   <sigma_kin_zz>   0.00000000 </sigma_kin_zz>
   <sigma_kin_xy>  -0.00000000 </sigma_kin_xy>
   <sigma_kin_yz>   0.00000000 </sigma_kin_yz>
   <sigma_kin_xz>   0.00000000 </sigma_kin_xz>

   <sigma_ext_xx>   0.00000000 </sigma_ext_xx>
   <sigma_ext_yy>   0.00000000 </sigma_ext_yy>
   <sigma_ext_zz>   0.00000000 </sigma_ext_zz>
   <sigma_ext_xy>   0.00000000 </sigma_ext_xy>
   <sigma_ext_yz>   0.00000000 </sigma_ext_yz>
   <sigma_ext_xz>   0.00000000 </sigma_ext_xz>

   <sigma_xx>  -0.40318578 </sigma_xx>
   <sigma_yy>  -1.11691578 </sigma_yy>
   <sigma_zz>  -1.39122938 </sigma_zz>
   <sigma_xy>  -0.00000015 </sigma_xy>
   <sigma_yz>   0.00001885 </sigma_yz>
   <sigma_xz>  -0.00002278 </sigma_xz>
 </stress_tensor>
  total_electronic_charge: 16.00000000
</iteration>
<timing name="iteration"       min="0.002" max="0.002"/>
<iteration count="3">
  <ekin>         5.34839575 </ekin>
  <econf>        0.00000000 </econf>
  <eps>         -5.48138300 </eps>
  <enl>          4.77521599 </enl>
  <ecoul>      -15.60248818 </ecoul>
  <exc>         -4.41268608 </exc>
  <esr>          0.07326719 </esr>
  <eself>       17.02153730 </eself>
  <ets>          0.00000000 </ets>
  <eexf>         0.00000000 </eexf>
  <etotal>     -15.37294552 </etotal>
  <epv>          0.00000000 </epv>
  <eefield>      0.00000000 </eefield>
  <enthalpy>   -15.37294552 </enthalpy>
<atomset>
<unit_cell 
    a=" 16.00000000   0.00000000   0.00000000"
    b="  0.00000000  16.00000000   0.00000000"
    c="  0.00000000   0.00000000  16.00000000" />
  <atom name="Si1" species="silicon">
    <position> 3.70000400 -0.00000000 -0.00000001 </position>
    <velocity> 0.00000044 -0.00000000 -0.00000000 </velocity>
    <force> 0.00283676 -0.00000004 -0.00000758 </force>
  </atom>
  <atom name="Si2" species="silicon">
    <position> -0.00000000 2.20002398 0.00000001 </position>
    <velocity> -0.00000000 0.00000266 0.00000000 </velocity>
    <force> -0.00000029 0.01704131 0.00000976 </force>
  </atom>
  <atom name="Si3" species="silicon">
    <position> -3.70000399 -0.00000000 -0.00000001 </position>
    <velocity> -0.00000044 -0.00000000 -0.00000000 </velocity>
    <force> -0.00283528 -0.00000006 -0.00000889 </force>
  </atom>
  <atom name="Si4" species="silicon">
    <position> -0.00000000 -2.20002398 0.00000001 </position>
    <velocity> -0.00000000 -0.00000266 0.00000000 </velocity>
    <force> -0.00000028 -0.01704123 0.00000759 </force>
  </atom>
</atomset>
  <ekin_e> 0.00000000 </ekin_e>
  <ekin_ion> 0.00000037 </ekin_ion>
  <temp_ion> 0.01966104 </temp_ion>
  <eta_ion> 0.00000000 </eta_ion>
  <econst> -15.37294515 </econst>
  <ekin_ec> -15.37294515 </ekin_ec>
 <stress_tensor unit="GPa">
   <sigma_eks_xx>  -0.40325935 </sigma_eks_xx>
   <sigma_eks_yy>  -1.11693283 </sigma_eks_yy>
   <sigma_eks_zz>  -1.39116835 </sigma_eks_zz>
   <sigma_eks_xy>  -0.00000015 </sigma_eks_xy>
   <sigma_eks_yz>   0.00001865 </sigma_eks_yz>
   <sigma_eks_xz>  -0.00002306 </sigma_eks_xz>

   <sigma_kin_xx>   0.00000014 </sigma_kin_xx>
   <sigma_kin_yy>   0.00000522 </sigma_kin_yy>
   <sigma_kin_zz>   0.00000000 </sigma_kin_zz>
   <sigma_kin_xy>  -0.00000000 </sigma_kin_xy>
   <sigma_kin_yz>   0.00000000 </sigma_kin_yz>
   <sigma_kin_xz>   0.00000000 </sigma_kin_xz>

   <sigma_ext_xx>   0.00000000 </sigma_ext_xx>
   <sigma_ext_yy>   0.00000000 </sigma_ext_yy>
   <sigma_ext_zz>   0.00000000 </sigma_ext_zz>
   <sigma_ext_xy>   0.00000000 </sigma_ext_xy>
   <sigma_ext_yz>   0.00000000 </sigma_ext_yz>
   <sigma_ext_xz>   0.00000000 </sigma_ext_xz>

   <sigma_xx>  -0.40325920 </sigma_xx>
   <sigma_yy>  -1.11692760 </sigma_yy>
   <sigma_zz>  -1.39116835 </sigma_zz>
   <sigma_xy>  -0.00000015 </sigma_xy>
   <sigma_yz>   0.00001865 </sigma_yz>
   <sigma_xz>  -0.00002306 </sigma_xz>
 </stress_tensor>
  total_electronic_charge: 16.00000000
</iteration>
<timing name="iteration"       min="0.002" max="0.002"/>
<iteration count="4">
  <ekin>         5.34839478 </ekin>
  <econf>        0.00000000 </econf>
  <eps>         -5.48137994 </eps>
  <enl>          4.77521759 </enl>
  <ecoul>      -15.60249275 </ecoul>
  <exc>         -4.41268567 </exc>
  <esr>          0.07326517 </esr>
  <eself>       17.02153730 </eself>
  <ets>          0.00000000 </ets>
  <eexf>         0.00000000 </eexf>
  <etotal>     -15.37294599 </etotal>
  <epv>          0.00000000 </epv>
  <eefield>      0.00000000 </eefield>
  <enthalpy>   -15.37294599 </enthalpy>
<atomset>
<unit_cell 
    a=" 16.00000000   0.00000000   0.00000000"
    b="  0.00000000  16.00000000   0.00000000"
    c="  0.00000000   0.00000000  16.00000000" />
  <atom name="Si1" species="silicon">
    <position> 3.70000710 -0.00000000 -0.00000002 </position>
    <velocity> 0.00000067 -0.00000000 -0.00000000 </velocity>
    <force> 0.00282791 -0.00000003 -0.00000756 </force>
  </atom>
  <atom name="Si2" species="silicon">
    <position> -0.00000000 2.20004262 0.00000002 </position>
    <velocity> -0.00000000 0.00000400 0.00000000 </velocity>
    <force> -0.00000028 0.01702190 0.00000967 </force>
  </atom>
  <atom name="Si3" species="silicon">
    <position> -3.70000710 -0.00000000 -0.00000002 </position>
    <velocity> -0.00000066 -0.00000000 -0.00000000 </velocity>
    <force> -0.00282646 -0.00000005 -0.00000879 </force>
  </atom>
  <atom name="Si4" species="silicon">
    <position> -0.00000000 -2.20004262 0.00000002 </position>
    <velocity> -0.00000000 -0.00000400 0.00000000 </velocity>
    <force> -0.00000027 -0.01702182 0.00000754 </force>
  </atom>
</atomset>
  <ekin_e> 0.00000000 </ekin_e>
  <ekin_ion> 0.00000084 </ekin_ion>
  <temp_ion> 0.04420103 </temp_ion>
  <eta_ion> 0.00000000 </eta_ion>
  <econst> -15.37294515 </econst>
  <ekin_ec> -15.37294515 </ekin_ec>
 <stress_tensor unit="GPa">
   <sigma_eks_xx>  -0.40337818 </sigma_eks_xx>
   <sigma_eks_yy>  -1.11696101 </sigma_eks_yy>
   <sigma_eks_zz>  -1.39107579 </sigma_eks_zz>
   <sigma_eks_xy>  -0.00000014 </sigma_eks_xy>
   <sigma_eks_yz>   0.00001831 </sigma_eks_yz>
   <sigma_eks_xz>  -0.00002349 </sigma_eks_xz>

   <sigma_kin_xx>   0.00000033 </sigma_kin_xx>
   <sigma_kin_yy>   0.00001174 </sigma_kin_yy>
   <sigma_kin_zz>   0.00000000 </sigma_kin_zz>
   <sigma_kin_xy>  -0.00000000 </sigma_kin_xy>
   <sigma_kin_yz>   0.00000000 </sigma_kin_yz>
   <sigma_kin_xz>   0.00000000 </sigma_kin_xz>

   <sigma_ext_xx>   0.00000000 </sigma_ext_xx>
   <sigma_ext_yy>   0.00000000 </sigma_ext_yy>
   <sigma_ext_zz>   0.00000000 </sigma_ext_zz>
   <sigma_ext_xy>   0.00000000 </sigma_ext_xy>
   <sigma_ext_yz>   0.00000000 </sigma_ext_yz>
   <sigma_ext_xz>   0.00000000 </sigma_ext_xz>

   <sigma_xx>  -0.40337786 </sigma_xx>
   <sigma_yy>  -1.11694927 </sigma_yy>
   <sigma_zz>  -1.39107579 </sigma_zz>
   <sigma_xy>  -0.00000014 </sigma_xy>
   <sigma_yz>   0.00001831 </sigma_yz>
   <sigma_xz>  -0.00002349 </sigma_xz>
 </stress_tensor>
  total_electronic_charge: 16.00000000
</iteration>
<timing name="iteration"       min="0.010" max="0.010"/>
<iteration count="5">
  <ekin>         5.34839213 </ekin>
  <econf>        0.00000000 </econf>
  <eps>         -5.48137474 </eps>
  <enl>          4.77521902 </enl>
  <ecoul>      -15.60249850 </ecoul>
  <exc>         -4.41268455 </exc>
  <esr>          0.07326235 </esr>
  <eself>       17.02153730 </eself>
  <ets>          0.00000000 </ets>
  <eexf>         0.00000000 </eexf>
  <etotal>     -15.37294664 </etotal>
  <epv>          0.00000000 </epv>
  <eefield>      0.00000000 </eefield>
  <enthalpy>   -15.37294664 </enthalpy>
<atomset>
<unit_cell 
    a=" 16.00000000   0.00000000   0.00000000"
    b="  0.00000000  16.00000000   0.00000000"
    c="  0.00000000   0.00000000  16.00000000" />
  <atom name="Si1" species="silicon">
    <position> 3.70001108 -0.00000000 -0.00000003 </position>
    <velocity> 0.00000089 -0.00000000 -0.00000000 </velocity>
    <force> 0.00281674 -0.00000003 -0.00000752 </force>
  </atom>
  <atom name="Si2" species="silicon">
    <position> -0.00000000 2.20006657 0.00000004 </position>
    <velocity> -0.00000000 0.00000532 0.00000000 </velocity>
    <force> -0.00000027 0.01699715 0.00000953 </force>
  </atom>
  <atom name="Si3" species="silicon">
    <position> -3.70001108 -0.00000000 -0.00000003 </position>
    <velocity> -0.00000089 -0.00000000 -0.00000000 </velocity>
    <force> -0.00281533 -0.00000005 -0.00000865 </force>
  </atom>
  <atom name="Si4" species="silicon">
    <position> -0.00000000 -2.20006657 0.00000003 </position>
    <velocity> -0.00000000 -0.00000532 0.00000000 </velocity>
    <force> -0.00000026 -0.01699708 0.00000746 </force>
  </atom>
</atomset>
  <ekin_e> 0.00000000 </ekin_e>
  <ekin_ion> 0.00000149 </ekin_ion>
  <temp_ion> 0.07849411 </temp_ion>
  <eta_ion> 0.00000000 </eta_ion>
  <econst> -15.37294515 </econst>
  <ekin_ec> -15.37294515 </ekin_ec>
 <stress_tensor unit="GPa">
   <sigma_eks_xx>  -0.40353719 </sigma_eks_xx>
   <sigma_eks_yy>  -1.11700470 </sigma_eks_yy>
   <sigma_eks_zz>  -1.39096418 </sigma_eks_zz>
   <sigma_eks_xy>  -0.00000014 </sigma_eks_xy>
   <sigma_eks_yz>   0.00001786 </sigma_eks_yz>
   <sigma_eks_xz>  -0.00002405 </sigma_eks_xz>

   <sigma_kin_xx>   0.00000058 </sigma_kin_xx>
   <sigma_kin_yy>   0.00002085 </sigma_kin_yy>
   <sigma_kin_zz>   0.00000000 </sigma_kin_zz>
   <sigma_kin_xy>  -0.00000000 </sigma_kin_xy>
   <sigma_kin_yz>   0.00000000 </sigma_kin_yz>
   <sigma_kin_xz>   0.00000000 </sigma_kin_xz>

   <sigma_ext_xx>   0.00000000 </sigma_ext_xx>
   <sigma_ext_yy>   0.00000000 </sigma_ext_yy>
   <sigma_ext_zz>   0.00000000 </sigma_ext_zz>
   <sigma_ext_xy>   0.00000000 </sigma_ext_xy>
   <sigma_ext_yz>   0.00000000 </sigma_ext_yz>
   <sigma_ext_xz>   0.00000000 </sigma_ext_xz>

   <sigma_xx>  -0.40353661 </sigma_xx>
   <sigma_yy>  -1.11698386 </sigma_yy>
   <sigma_zz>  -1.39096418 </sigma_zz>
   <sigma_xy>  -0.00000014 </sigma_xy>
   <sigma_yz>   0.00001786 </sigma_yz>
   <sigma_xz>  -0.00002405 </sigma_xz>
 </stress_tensor>
  total_electronic_charge: 16.00000000
</iteration>
<timing name="iteration"       min="0.002" max="0.002"/>
<timing name="charge"          min="0.004" max="0.012"/>
<timing name="ekin_e"          min="0.000" max="0.000"/>
<timing name="md_update_wf"    min="0.000" max="0.000"/>
<timing name="riccati"         min="0.001" max="0.001"/>
<timing name="ekin"            min="0.000" max="0.001"/>
<timing name="exc"             min="0.001" max="0.001"/>
<timing name="hpsi"            min="0.004" max="0.004"/>
<timing name="nonlocal"        min="0.002" max="0.002"/>
<timing name="charge_compute"  min="0.000" max="0.011"/>
<timing name="charge_integral" min="0.000" max="0.011"/>
<timing name="charge_rowsum"   min="0.000" max="0.000"/>
<timing name="charge_vft"      min="0.001" max="0.001"/>
[qbox]  End of command stream 
<real_time> 15.469 </real_time>
<end_time> 2017-08-24T14:41:48Z </end_time>
</fpmd:simulation>
""")
