#pragma once
/* Text wrapping is not recommended for this document 
 * 
 * Normal PRN generator. Must call normal_setup() to initialize the
 * uniform PRNG.
 *
 * normal() -> Standard normal PRN variate. 
 *
 * */
#include "./shared.h"       /* Functions used both in exponential.h and here */
#include "exponential.h"    /* Sampling from the tail uses exponential PRNs  */
#define __NORM_BINS__	253

void normal_setup(void) {
  mt_init();
}

static uint_fast8_t _norm_sample_A(void) {  /* Alias Sampling of A_i */
    static uint8_t map[256] = { 0, 0, 239, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 251, 251, 251, 251, 251, 251, 251, 250, 250, 250, 250, 250, 249, 249, 249, 248, 248, 248, 247, 247, 247, 246, 246, 245, 244, 244, 243, 242, 240, 2, 2, 3, 3, 0, 0, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 1, 0, 0 };
    static int64_t ipmf[256] = { 9223372036854775807, 1100243796532604147, 7866600928978262881, 6788754710654027089, 9022865200181691852, 6522434035205505475, 4723064097359993915, 3360495653216419673, 2289663232373874393, 1423968905551925104, 708364817827802907, 106102487305606492, -408333464665790208, -853239722779020926, -1242095211825517037, -1585059631105792592, -1889943050287164616, -2162852901990665326, -2408637386594506662, -2631196530262949902, -2833704942520918738, -3018774289025815052, -3188573753472182441, -3344920681707440829, -3489349705062145773, -3623166100042174483, -3747487436868330185, -3863276422712168700, -3971367044063122321, -4072485557029853479, -4167267476830907467, -4256271432240150335, -4339990541927301065, -4418861817133796561, -4493273980372371289, -4563574004462236379, -4630072609770443287, -4693048910430993529, -4752754358862853623, -4809416110052798111, -4863239903586974371, -4914412541515869230, -4963104028439154501, -5009469424769141876, -5053650458856546947, -5095776932695070785, -5135967952544950843, -5174333008451188631, -5210972924952682065, -5245980700100453012, -5279442247516290042, -5311437055462362013, -5342038772315636138, -5371315728843324427, -5399331404632497705, -5426144845493682879, -5451811038474681565, -5476381248265612057, -5499903320558330825, -5522421955752302985, -5543978956085246988, -5564613449659052023, -5584362093436129148, -5603259257517445975, -5621337193070977432, -5638626184974114133, -5655154691220924683, -5670949470294749069, -5686035697601828417, -5700437072199142976, -5714175914219797723, -5727273255295211389, -5739748920272022600, -5751621603810396917, -5762908939773930926, -5773627565914992314, -5783793183152402325, -5793420610475612574, -5802523835894645221, -5811116062947594592, -5819209754516104281, -5826816672854561136, -5833947916825296227, -5840613956570562553, -5846824665591787384, -5852589350491064419, -5857916778480708968, -5862815203334817577, -5867292388935689664, -5871355631762300668, -5875011781262872391, -5878267259039068099, -5881128076579864607, -5883599852028866964, -5885687825288587920, -5887396872144944193, -5888731517955022366, -5889695949247708370, -5890294025706661862, -5890529289910843690, -5890404977676009159, -5889924026487152552, -5889089083913561497, -5887902514965187544, -5886366408898350160, -5884482585690660648, -5882252601321067956, -5879677752995005083, -5876759083794187244, -5873497386318817608, -5869893206505495615, -5865946846617000703, -5861658367354170141, -5857027590486142268, -5852054100063403979, -5846737243971479915, -5841076134082348607, -5835069647234555080, -5828716424754558627, -5822014871949050545, -5814963157357505615, -5807559211080035948, -5799800723447248431, -5791685142338046612, -5783209670985131963, -5774371264582507258, -5765166627072198898, -5755592207057629351, -5745644193442020886, -5735318510777140130, -5724610813433637581, -5713516480385064197, -5702030608511931905, -5690148005851000163, -5677863184109376595, -5665170350903283020, -5652063400924584736, -5638535907000098559, -5624581109999495711, -5610191908627545348, -5595360848093635657, -5580080108034221525, -5564341489875517452, -5548136403221361788, -5531455851545388194, -5514290416638313566, -5496630242181647032, -5478465016761708394, -5459783954986630496, -5440575777891763554, -5420828692432362328, -5400530368638759086, -5379667916699386572, -5358227861294079939, -5336196115274289941, -5313557951078348351, -5290297970633413513, -5266400072915204637, -5241847420213976978, -5216622401043707762, -5190706591719514516, -5164080714589163015, -5136724594099061292, -5108617109269271995, -5079736143458208314, -5050058530461699570, -5019559997031867155, -4988215101008300666, -4955997165600740840, -4922878208651982466, -4888828866780310778, -4853818314258448763, -4817814175855136221, -4780782432601640934, -4742687321746673837, -4703491227581398702, -4663154564978669839, -4621635653358718847, -4578890580370737438, -4534873055659651863, -4489534251700544707, -4442822631898778778, -4394683764809052552, -4345060121983309848, -4293890858708851568, -4241111576153757717, -4186654061692562932, -4130446006804691432, -4072410698657642967, -4012466683838341666, -3950527400304957273, -3886500774061817392, -3820288777467775968, -3751786943594814089, -3680883832433444937, -3607460442623855428, -3531389562483238811, -3452535052936037985, -3370751053395794721, -3285881101589156030, -3197757155301271700, -3106198503156390075, -3011010550911843739, -2911983463883482375, -2808890647470171482, -2701487041141041038, -2589507199690499622, -2472663129329060997, -2350641842139723534, -2223102583769914387, -2089673683729348624, -1949948966045216354, -1803483646855866339, -1649789631524907106, -1488330106094837958, -1318513295725471712, -1139685236971903433, -951121376551959675, -752016768184573709, -541474585687415681, -318492605680814263, -81947227248966622, 169425512568350963, 437052607277165029, 722551297569085274, 1027761939300002045, 1354787941578333500, 1706044619204253453, 2084319374409947591, 2492846399638817506, 2935400169348911565, 3416413484613541924, 3941127949861028145, 4515787798749165735, 5147892401484995974, 5846529325380992513, 6622819682194933019, 7490522659874903812, 8466869998278641829, 8216968526368126501, 4550693915471153825, 7628019504122306461, 6605080500893076940, 7121156327637209657, 2484871780365768829, 7179104797069433749, 7066086283825115773, 1516500120794063563, 216305945442773460, 6295963418513296140, 2889316805672339623, -2712587580543026574, 6562498853519217374, 7975754821145999232, -9223372036854775807, -9223372036854775807 };
    uint_fast8_t j = Rand->sl & 0xff;   /* j <- I(0, 256) */
    return Rand++->sl >= ipmf[j] ? map[j] : j;
}

static inline double normal(void) {
                                                        /* X_i = length of ziggurat layer i */
	static double X[__NORM_BINS__+1] = { 3.94216628254e-19, 3.72049450041e-19, 3.58270244806e-19, 3.48074762365e-19, 3.39901771719e-19, 3.33037783603e-19, 3.27094388176e-19, 3.21835771325e-19, 3.17107585418e-19, 3.1280307407e-19, 3.08845206558e-19, 3.05176506241e-19, 3.01752902926e-19, 2.98539834407e-19, 2.95509674628e-19, 2.92639979885e-19, 2.899122587e-19, 2.87311087802e-19, 2.84823463271e-19, 2.82438315352e-19, 2.80146139647e-19, 2.77938712618e-19, 2.75808869214e-19, 2.73750326983e-19, 2.71757545434e-19, 2.69825612475e-19, 2.67950151888e-19, 2.66127247304e-19, 2.6435337928e-19, 2.6262537282e-19, 2.60940353352e-19, 2.59295709543e-19, 2.57689061732e-19, 2.56118234977e-19, 2.54581235934e-19, 2.53076232924e-19, 2.51601538678e-19, 2.50155595336e-19, 2.48736961354e-19, 2.47344300031e-19, 2.45976369429e-19, 2.44632013479e-19, 2.43310154111e-19, 2.42009784271e-19, 2.40729961704e-19, 2.39469803409e-19, 2.38228480673e-19, 2.37005214619e-19, 2.35799272207e-19, 2.34609962621e-19, 2.33436634011e-19, 2.32278670547e-19, 2.31135489743e-19, 2.30006540027e-19, 2.28891298528e-19, 2.27789269059e-19, 2.26699980275e-19, 2.25622983985e-19, 2.24557853607e-19, 2.23504182749e-19, 2.22461583905e-19, 2.21429687253e-19, 2.20408139549e-19, 2.19396603103e-19, 2.18394754837e-19, 2.17402285409e-19, 2.164188984e-19, 2.15444309566e-19, 2.14478246135e-19, 2.13520446164e-19, 2.12570657924e-19, 2.11628639347e-19, 2.10694157491e-19, 2.09766988055e-19, 2.08846914916e-19, 2.079337297e-19, 2.0702723138e-19, 2.06127225897e-19, 2.05233525809e-19, 2.04345949953e-19, 2.03464323137e-19, 2.02588475842e-19, 2.01718243948e-19, 2.00853468469e-19, 1.99993995309e-19, 1.9913967503e-19, 1.9829036263e-19, 1.97445917335e-19, 1.96606202405e-19, 1.95771084943e-19, 1.94940435722e-19, 1.9411412902e-19, 1.93292042452e-19, 1.92474056827e-19, 1.91660056003e-19, 1.90849926746e-19, 1.90043558606e-19, 1.89240843788e-19, 1.88441677035e-19, 1.87645955517e-19, 1.86853578721e-19, 1.8606444835e-19, 1.85278468221e-19, 1.84495544175e-19, 1.83715583984e-19, 1.82938497262e-19, 1.82164195388e-19, 1.81392591419e-19, 1.80623600019e-19, 1.7985713738e-19, 1.79093121154e-19, 1.78331470384e-19, 1.77572105435e-19, 1.76814947933e-19, 1.76059920701e-19, 1.753069477e-19, 1.74555953971e-19, 1.73806865576e-19, 1.73059609547e-19, 1.72314113829e-19, 1.71570307233e-19, 1.70828119379e-19, 1.7008748065e-19, 1.69348322146e-19, 1.68610575631e-19, 1.67874173493e-19, 1.67139048692e-19, 1.66405134721e-19, 1.6567236556e-19, 1.64940675631e-19, 1.64209999755e-19, 1.63480273116e-19, 1.62751431209e-19, 1.62023409806e-19, 1.61296144913e-19, 1.60569572726e-19, 1.59843629593e-19, 1.59118251972e-19, 1.58393376391e-19, 1.57668939404e-19, 1.56944877552e-19, 1.56221127324e-19, 1.55497625108e-19, 1.54774307158e-19, 1.54051109542e-19, 1.53327968107e-19, 1.52604818431e-19, 1.51881595777e-19, 1.51158235054e-19, 1.50434670764e-19, 1.49710836959e-19, 1.48986667191e-19, 1.48262094465e-19, 1.47537051186e-19, 1.46811469107e-19, 1.46085279278e-19, 1.4535841199e-19, 1.44630796717e-19, 1.43902362058e-19, 1.43173035676e-19, 1.42442744238e-19, 1.41711413344e-19, 1.40978967466e-19, 1.40245329873e-19, 1.39510422558e-19, 1.38774166165e-19, 1.38036479905e-19, 1.37297281475e-19, 1.36556486972e-19, 1.35814010798e-19, 1.35069765568e-19, 1.34323662007e-19, 1.33575608847e-19, 1.32825512715e-19, 1.32073278015e-19, 1.31318806805e-19, 1.30561998669e-19, 1.29802750579e-19, 1.29040956749e-19, 1.28276508483e-19, 1.2750929401e-19, 1.26739198313e-19, 1.25966102948e-19, 1.25189885844e-19, 1.24410421101e-19, 1.23627578765e-19, 1.22841224598e-19, 1.2205121982e-19, 1.21257420848e-19, 1.20459679002e-19, 1.19657840201e-19, 1.18851744634e-19, 1.18041226403e-19, 1.17226113142e-19, 1.16406225609e-19, 1.15581377245e-19, 1.14751373693e-19, 1.13916012285e-19, 1.13075081485e-19, 1.12228360281e-19, 1.11375617531e-19, 1.10516611251e-19, 1.09651087832e-19, 1.08778781199e-19, 1.07899411881e-19, 1.07012685997e-19, 1.06118294148e-19, 1.05215910191e-19, 1.043051899e-19, 1.0338576948e-19, 1.02457263929e-19, 1.01519265222e-19, 1.00571340295e-19, 9.96130287997e-20, 9.86438405995e-20, 9.76632529648e-20, 9.66707074276e-20, 9.56656062409e-20, 9.46473083804e-20, 9.36151250173e-20, 9.25683143709e-20, 9.15060758376e-20, 9.04275432677e-20, 8.93317772338e-20, 8.82177561023e-20, 8.70843656749e-20, 8.59303871096e-20, 8.47544827642e-20, 8.35551795085e-20, 8.23308489336e-20, 8.10796837291e-20, 7.97996692841e-20, 7.84885492861e-20, 7.71437837009e-20, 7.57624969795e-20, 7.43414135785e-20, 7.28767768074e-20, 7.13642454435e-20, 6.97987602408e-20, 6.81743689448e-20, 6.64839929862e-20, 6.47191103452e-20, 6.28693148131e-20, 6.09216875483e-20, 5.88598735756e-20, 5.66626751161e-20, 5.43018136309e-20, 5.17381717445e-20, 4.89150317224e-20, 4.57447418908e-20, 4.20788025686e-20, 3.76259867224e-20, 3.16285898059e-20, 0.0};
                                                        /* Y_i = f(X_i) */
	static double Y[__NORM_BINS__+1] = { 1.45984107966e-22, 3.00666134279e-22, 4.61297288151e-22, 6.26633500492e-22, 7.95945247619e-22, 9.68746550217e-22, 1.14468770024e-21, 1.32350363044e-21, 1.50498576921e-21, 1.68896530007e-21, 1.87530253827e-21, 2.06387984237e-21, 2.25459669136e-21, 2.44736615188e-21, 2.64211227278e-21, 2.83876811879e-21, 3.03727425675e-21, 3.23757757e-21, 3.43963031579e-21, 3.6433893658e-21, 3.84881558689e-21, 4.05587333095e-21, 4.26453001043e-21, 4.47475574223e-21, 4.68652304654e-21, 4.89980659028e-21, 5.11458296721e-21, 5.3308305082e-21, 5.5485291167e-21, 5.76766012527e-21, 5.98820616992e-21, 6.21015107954e-21, 6.43347977823e-21, 6.65817819857e-21, 6.88423320459e-21, 7.1116325228e-21, 7.34036468049e-21, 7.57041895029e-21, 7.80178530014e-21, 8.03445434816e-21, 8.26841732173e-21, 8.50366602039e-21, 8.74019278201e-21, 8.97799045203e-21, 9.21705235531e-21, 9.45737227039e-21, 9.69894440593e-21, 9.94176337898e-21, 1.01858241951e-20, 1.04311222301e-20, 1.0677653213e-20, 1.09254132104e-20, 1.11743986124e-20, 1.14246061187e-20, 1.16760327269e-20, 1.19286757204e-20, 1.21825326583e-20, 1.24376013654e-20, 1.2693879923e-20, 1.29513666605e-20, 1.32100601473e-20, 1.34699591858e-20, 1.37310628045e-20, 1.39933702514e-20, 1.42568809885e-20, 1.4521594686e-20, 1.47875112175e-20, 1.50546306552e-20, 1.53229532653e-20, 1.55924795044e-20, 1.58632100153e-20, 1.61351456238e-20, 1.64082873355e-20, 1.66826363327e-20, 1.69581939719e-20, 1.72349617811e-20, 1.75129414576e-20, 1.77921348663e-20, 1.80725440373e-20, 1.83541711644e-20, 1.86370186038e-20, 1.89210888728e-20, 1.92063846482e-20, 1.94929087658e-20, 1.97806642193e-20, 2.00696541597e-20, 2.03598818948e-20, 2.06513508884e-20, 2.09440647607e-20, 2.12380272876e-20, 2.15332424009e-20, 2.18297141884e-20, 2.21274468943e-20, 2.24264449191e-20, 2.27267128206e-20, 2.30282553143e-20, 2.33310772738e-20, 2.36351837324e-20, 2.39405798832e-20, 2.42472710808e-20, 2.45552628422e-20, 2.48645608479e-20, 2.5175170944e-20, 2.54870991431e-20, 2.58003516259e-20, 2.61149347436e-20, 2.64308550193e-20, 2.67481191499e-20, 2.70667340088e-20, 2.73867066474e-20, 2.77080442982e-20, 2.80307543767e-20, 2.83548444847e-20, 2.86803224123e-20, 2.90071961414e-20, 2.93354738484e-20, 2.96651639078e-20, 2.99962748948e-20, 3.03288155897e-20, 3.06627949809e-20, 3.09982222687e-20, 3.13351068696e-20, 3.16734584202e-20, 3.20132867816e-20, 3.23546020438e-20, 3.26974145302e-20, 3.30417348029e-20, 3.33875736673e-20, 3.37349421775e-20, 3.40838516421e-20, 3.44343136293e-20, 3.4786339973e-20, 3.51399427794e-20, 3.54951344328e-20, 3.58519276026e-20, 3.62103352501e-20, 3.65703706358e-20, 3.69320473266e-20, 3.7295379204e-20, 3.76603804721e-20, 3.80270656658e-20, 3.83954496597e-20, 3.87655476775e-20, 3.91373753011e-20, 3.95109484807e-20, 3.98862835454e-20, 4.02633972133e-20, 4.06423066034e-20, 4.10230292468e-20, 4.14055830991e-20, 4.1789986553e-20, 4.21762584518e-20, 4.25644181026e-20, 4.29544852916e-20, 4.33464802983e-20, 4.3740423912e-20, 4.41363374476e-20, 4.45342427632e-20, 4.49341622781e-20, 4.53361189911e-20, 4.5740136501e-20, 4.61462390263e-20, 4.65544514274e-20, 4.69647992292e-20, 4.73773086444e-20, 4.77920065987e-20, 4.82089207569e-20, 4.86280795501e-20, 4.90495122048e-20, 4.94732487728e-20, 4.98993201633e-20, 5.03277581761e-20, 5.07585955372e-20, 5.11918659356e-20, 5.16276040629e-20, 5.20658456539e-20, 5.25066275307e-20, 5.29499876488e-20, 5.33959651452e-20, 5.38446003902e-20, 5.42959350421e-20, 5.47500121042e-20, 5.52068759864e-20, 5.566657257e-20, 5.61291492763e-20, 5.65946551399e-20, 5.70631408865e-20, 5.75346590156e-20, 5.80092638886e-20, 5.8487011823e-20, 5.89679611927e-20, 5.94521725351e-20, 5.99397086661e-20, 6.04306348026e-20, 6.09250186942e-20, 6.14229307644e-20, 6.19244442624e-20, 6.24296354262e-20, 6.29385836583e-20, 6.34513717154e-20, 6.39680859128e-20, 6.44888163458e-20, 6.5013657129e-20, 6.55427066567e-20, 6.60760678847e-20, 6.66138486374e-20, 6.71561619424e-20, 6.7703126396e-20, 6.82548665622e-20, 6.88115134113e-20, 6.93732047997e-20, 6.9940085999e-20, 7.05123102793e-20, 7.10900395534e-20, 7.16734450906e-20, 7.22627083097e-20, 7.28580216611e-20, 7.3459589613e-20, 7.4067629755e-20, 7.46823740371e-20, 7.53040701672e-20, 7.59329831907e-20, 7.65693972825e-20, 7.72136177895e-20, 7.78659735664e-20, 7.85268196595e-20, 7.91965404039e-20, 7.9875553017e-20, 8.05643117889e-20, 8.12633129964e-20, 8.19731007037e-20, 8.26942736526e-20, 8.34274935088e-20, 8.41734948075e-20, 8.49330970528e-20, 8.57072195782e-20, 8.64968999859e-20, 8.73033172957e-20, 8.81278213789e-20, 8.89719709282e-20, 8.98375832393e-20, 9.07268006979e-20, 9.16421814841e-20, 9.25868264067e-20, 9.35645614803e-20, 9.45802100126e-20, 9.56400155509e-20, 9.67523347705e-20, 9.79288516978e-20, 9.91869058575e-20, 1.00554562713e-19, 1.02084073773e-19, 1.03903609932e-19, 1.08420217249e-19};
#ifndef INFER_TIMINGS                           
    static uint_fast16_t i_max = __NORM_BINS__;
#else                                                   /* To estimate the effects of early exit alone */
    static uint_fast16_t i_max = 2*__NORM_BINS__ - 256;
#endif
    MT_FLUSH();
	uint_fast8_t i = Rand->l & 0xff;                    /* Floating-point multiplication squashes these bits, so they can be used to sample i */
	if (i < i_max) return X[i]*Rand++->sl;              /* Early exit */
    uint64_t U_1 = RANDOM_INT63();
    double sign_bit = U_1 & 0x100 ? 1. : -1.;           /* Another squashed, recyclable bit */
	uint_fast8_t j = _norm_sample_A();
    int64_t U_diff;
    static int64_t max_iE = 2269182951627975918, min_iE =  760463704284035181; /* Largest deviations of f(x) from y_i */
	static double X_0 = 3.6360066255;                   /* Beginning of tail */
    static uint_fast8_t j_inflection = 205;
    double x, *X_j = X + j;
        /* Four kinds of overhangs: 
         *  j = 0                :  Sample from tail
         *  0 < j < j_inflection :  Overhang is concave; only sample from Lower-Left triangle
         *  j = j_inflection     :  Must sample from entire overhang rectangle
         *  j > j_inflection     :  Overhangs are convex; implicitly accept point in Lower-Left triangle
         * 
         * Conditional statements are arranged such that the more likely outcomes are first. */
#ifndef SIMPLE_OVERHANGS
    if (j > j_inflection) {             /* Convex overhang */
        for (;;) {
            x = _FAST_PRNG_SAMPLE_X(X_j, U_1);
            MT_FLUSH();
            U_diff = RANDOM_INT63() - U_1;
            if (U_diff > min_iE) break;      
            if (U_diff < -max_iE) continue;
            if ( _FAST_PRNG_SAMPLE_Y(j, pow(2, 63) - (U_1 + U_diff)) < exp(-0.5*x*x) ) break;
            U_1 = RANDOM_INT63();
            }
    } else if (j == 0) {                /* Tail */
#endif
#ifdef SIMPLE_OVERHANGS
    if (j == 0) {                       /* Tail (excluding Convex overhang conditional) */
#endif
        do x = pow(X_0, -1)*exponential();
        while (exponential() < 0.5*x*x);
        x += X_0;
#ifndef SIMPLE_OVERHANGS
    } else if (j < j_inflection) {  /* Concave overhang */ 
        for (;;) {
            MT_FLUSH();
            U_diff = RANDOM_INT63() - U_1;
            if (U_diff < 0) {
                U_diff = -U_diff;
                U_1 -= U_diff; 
            }
            x = _FAST_PRNG_SAMPLE_X(X_j, U_1);
            if (U_diff > min_iE) break;
            if ( _FAST_PRNG_SAMPLE_Y(j, pow(2, 63) - (U_1 + U_diff)) < exp(-0.5*x*x) ) break;
            U_1 = RANDOM_INT63();
        } 
#endif
    } else {                        /* Inflection point or simple overhangs */                
        for (;;) {
            x = _FAST_PRNG_SAMPLE_X(X_j, U_1);
            MT_FLUSH();
            if ( _FAST_PRNG_SAMPLE_Y(j, RANDOM_INT63()) < exp(-0.5*x*x) ) break;
            U_1 = RANDOM_INT63();
        }
    }
    return sign_bit*x; 
}
