/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import java.io.Serializable;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.fraction.BigFractionField;
import org.apache.commons.math3.fraction.FractionConversionException;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.RealMatrix;

public class KolmogorovSmirnovDistribution
implements Serializable {
    private static final long serialVersionUID = -4670676796862967187L;
    private int n;

    public KolmogorovSmirnovDistribution(int n) throws NotStrictlyPositiveException {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NOT_POSITIVE_NUMBER_OF_SAMPLES, n);
        }
        this.n = n;
    }

    public double cdf(double d) throws MathArithmeticException {
        return this.cdf(d, false);
    }

    public double cdfExact(double d) throws MathArithmeticException {
        return this.cdf(d, true);
    }

    public double cdf(double d, boolean exact) throws MathArithmeticException {
        double ninv = 1.0 / (double)this.n;
        double ninvhalf = 0.5 * ninv;
        if (d <= ninvhalf) {
            return 0.0;
        }
        if (ninvhalf < d && d <= ninv) {
            double res = 1.0;
            double f = 2.0 * d - ninv;
            int i = 1;
            while (i <= this.n) {
                res *= (double)i * f;
                ++i;
            }
            return res;
        }
        if (1.0 - ninv <= d && d < 1.0) {
            return 1.0 - 2.0 * Math.pow(1.0 - d, this.n);
        }
        if (1.0 <= d) {
            return 1.0;
        }
        return exact ? this.exactK(d) : this.roundedK(d);
    }

    private double exactK(double d) throws MathArithmeticException {
        int k = (int)Math.ceil((double)this.n * d);
        FieldMatrix<BigFraction> H = this.createH(d);
        FieldMatrix<BigFraction> Hpower = H.power(this.n);
        BigFraction pFrac = Hpower.getEntry(k - 1, k - 1);
        int i = 1;
        while (i <= this.n) {
            pFrac = pFrac.multiply(i).divide(this.n);
            ++i;
        }
        return pFrac.bigDecimalValue(20, 4).doubleValue();
    }

    private double roundedK(double d) throws MathArithmeticException {
        int k = (int)Math.ceil((double)this.n * d);
        FieldMatrix<BigFraction> HBigFraction = this.createH(d);
        int m = HBigFraction.getRowDimension();
        Array2DRowRealMatrix H = new Array2DRowRealMatrix(m, m);
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < m) {
                H.setEntry(i, j, HBigFraction.getEntry(i, j).doubleValue());
                ++j;
            }
            ++i;
        }
        RealMatrix Hpower = H.power(this.n);
        double pFrac = Hpower.getEntry(k - 1, k - 1);
        int i2 = 1;
        while (i2 <= this.n) {
            pFrac *= (double)i2 / (double)this.n;
            ++i2;
        }
        return pFrac;
    }

    private FieldMatrix<BigFraction> createH(double d) throws NumberIsTooLargeException, FractionConversionException {
        int k = (int)Math.ceil((double)this.n * d);
        int m = 2 * k - 1;
        double hDouble = (double)k - (double)this.n * d;
        if (hDouble >= 1.0) {
            throw new NumberIsTooLargeException(hDouble, (Number)1.0, false);
        }
        BigFraction h = null;
        try {
            h = new BigFraction(hDouble, 1.0E-20, 10000);
        }
        catch (FractionConversionException e1) {
            try {
                h = new BigFraction(hDouble, 1.0E-10, 10000);
            }
            catch (FractionConversionException e2) {
                h = new BigFraction(hDouble, 1.0E-5, 10000);
            }
        }
        FieldElement[][] Hdata = new BigFraction[m][m];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < m) {
                Hdata[i][j] = i - j + 1 < 0 ? BigFraction.ZERO : BigFraction.ONE;
                ++j;
            }
            ++i;
        }
        BigFraction[] hPowers = new BigFraction[m];
        hPowers[0] = h;
        int i2 = 1;
        while (i2 < m) {
            hPowers[i2] = h.multiply(hPowers[i2 - 1]);
            ++i2;
        }
        i2 = 0;
        while (i2 < m) {
            Hdata[i2][0] = Hdata[i2][0].subtract(hPowers[i2]);
            Hdata[m - 1][i2] = ((BigFraction)Hdata[m - 1][i2]).subtract(hPowers[m - i2 - 1]);
            ++i2;
        }
        if (h.compareTo(BigFraction.ONE_HALF) == 1) {
            Hdata[m - 1][0] = Hdata[m - 1][0].add(h.multiply(2).subtract(1).pow(m));
        }
        i2 = 0;
        while (i2 < m) {
            int j = 0;
            while (j < i2 + 1) {
                if (i2 - j + 1 > 0) {
                    int g = 2;
                    while (g <= i2 - j + 1) {
                        Hdata[i2][j] = ((BigFraction)Hdata[i2][j]).divide(g);
                        ++g;
                    }
                }
                ++j;
            }
            ++i2;
        }
        return new Array2DRowFieldMatrix((Field)BigFractionField.getInstance(), Hdata);
    }
}

