/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.webserver;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.xmlrpc.server.XmlRpcStreamServer;
import org.apache.xmlrpc.util.ThreadPool;
import org.apache.xmlrpc.webserver.Connection;
import org.apache.xmlrpc.webserver.ConnectionServer;

public class WebServer
implements Runnable {
    protected ServerSocket serverSocket;
    private Thread listener;
    private ThreadPool pool;
    protected final List accept = new ArrayList();
    protected final List deny = new ArrayList();
    protected final XmlRpcStreamServer server = this.newXmlRpcStreamServer();
    private InetAddress address;
    private int port;
    private boolean paranoid;
    static final String HTTP_11 = "HTTP/1.1";

    protected XmlRpcStreamServer newXmlRpcStreamServer() {
        return new ConnectionServer();
    }

    public WebServer(int pPort) {
        this(pPort, null);
    }

    public WebServer(int pPort, InetAddress pAddr) {
        this.address = pAddr;
        this.port = pPort;
    }

    protected ServerSocket createServerSocket(int pPort, int backlog, InetAddress addr) throws IOException {
        return new ServerSocket(pPort, backlog, addr);
    }

    private synchronized void setupServerSocket(int backlog) throws IOException {
        int i = 1;
        while (true) {
            try {
                this.serverSocket = this.createServerSocket(this.port, backlog, this.address);
                if (this.serverSocket.getSoTimeout() <= 0) {
                    this.serverSocket.setSoTimeout(4096);
                }
                return;
            }
            catch (BindException e) {
                long l;
                if (i == 10) {
                    throw e;
                }
                long waitUntil = System.currentTimeMillis() + 1000L;
                while ((l = waitUntil - System.currentTimeMillis()) > 0L) {
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ++i;
                continue;
            }
            break;
        }
    }

    public void start() throws IOException {
        this.setupServerSocket(50);
        if (this.listener == null) {
            this.listener = new Thread((Runnable)this, "XML-RPC Weblistener");
            this.listener.start();
        }
    }

    public void setParanoid(boolean pParanoid) {
        this.paranoid = pParanoid;
    }

    protected boolean isParanoid() {
        return this.paranoid;
    }

    public void acceptClient(String pAddress) {
        this.accept.add(new AddressMatcher(pAddress));
    }

    public void denyClient(String pAddress) {
        this.deny.add(new AddressMatcher(pAddress));
    }

    protected boolean allowConnection(Socket s) {
        AddressMatcher match;
        if (!this.paranoid) {
            return true;
        }
        int l = this.deny.size();
        byte[] addr = s.getInetAddress().getAddress();
        int i = 0;
        while (i < l) {
            match = (AddressMatcher)this.deny.get(i);
            if (match.matches(addr)) {
                return false;
            }
            ++i;
        }
        l = this.accept.size();
        i = 0;
        while (i < l) {
            match = (AddressMatcher)this.accept.get(i);
            if (match.matches(addr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected ThreadPool.Task newTask(WebServer pServer, XmlRpcStreamServer pXmlRpcServer, Socket pSocket) throws IOException {
        return new Connection(pServer, pXmlRpcServer, pSocket);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[UNCONDITIONALDOLOOP]], but top level block is 20[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected ThreadPool newThreadPool() {
        return new ThreadPool(this.server.getMaxThreads(), "XML-RPC");
    }

    public synchronized void shutdown() {
        if (this.listener != null) {
            Thread l = this.listener;
            this.listener = null;
            l.interrupt();
            if (this.pool != null) {
                this.pool.shutdown();
            }
        }
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public void log(Throwable pError) {
        String msg = pError.getMessage() == null ? pError.getClass().getName() : pError.getMessage();
        this.server.getErrorLogger().log(msg, pError);
    }

    public void log(String pMessage) {
        this.server.getErrorLogger().log(pMessage);
    }

    public XmlRpcStreamServer getXmlRpcServer() {
        return this.server;
    }

    private class AddressMatcher {
        private final int[] pattern;

        AddressMatcher(String pAddress) {
            try {
                this.pattern = new int[4];
                StringTokenizer st = new StringTokenizer(pAddress, ".");
                if (st.countTokens() != 4) {
                    throw new IllegalArgumentException();
                }
                int i = 0;
                while (i < 4) {
                    String next = st.nextToken();
                    this.pattern[i] = "*".equals(next) ? 256 : (int)((byte)Integer.parseInt(next));
                    ++i;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\"" + pAddress + "\" does not represent a valid IP address");
            }
        }

        boolean matches(byte[] pAddress) {
            int i = 0;
            while (i < 4) {
                if (this.pattern[i] <= 255 && this.pattern[i] != pAddress[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

