/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public class ConfigFileLoader {
    private static final File CATALINA_BASE_FILE = new File(System.getProperty("catalina.base"));
    private static final URI CATALINA_BASE_URI = CATALINA_BASE_FILE.toURI();

    private ConfigFileLoader() {
    }

    public static InputStream getInputStream(String location) throws IOException {
        File f = new File(location);
        if (!f.isAbsolute()) {
            f = new File(CATALINA_BASE_FILE, location);
        }
        if (f.isFile()) {
            return new FileInputStream(f);
        }
        URI uri = CATALINA_BASE_URI.resolve(location);
        URL url = uri.toURL();
        return url.openConnection().getInputStream();
    }
}

