/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-02-25 23:17:53 +0100 (Tue, 25 Feb 2014) $
//  number=$Revision: 9792 $
//  type=gd

/**
 * Localized names for the "gd" locale.
 */
public class LocalizedNamesImpl_gd extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "BY",
        "BE",
        "VE",
        "BG",
        "GE",
        "HR",
        "GM",
        "DE",
        "GL",
        "GR",
        "MK",
        "MD",
        "DO",
        "PL",
        "PT",
        "AF",
        "ZA",
        "DZ",
        "AG",
        "AM",
        "AL",
        "ME",
        "AQ",
        "AR",
        "CV",
        "DK",
        "AD",
        "IT",
        "YE",
        "EE",
        "CH",
        "EG",
        "FI",
        "FR",
        "AO",
        "AI",
        "ET",
        "LV",
        "LT",
        "NA",
        "NO",
        "AT",
        "GB",
        "RU",
        "SV",
        "ES",
        "TZ",
        "EU",
        "TD",
        "JP",
        "RS",
        "CL",
        "CN",
        "ZW",
        "SK",
        "SI",
        "SE",
        "TR",
        "UA",
        "HU",
        "SA",
        "AW",
        "AZ",
        "AU",
        "BH",
        "BD",
        "BB",
        "BM",
        "BZ",
        "BJ",
        "VN",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BF",
        "BI",
        "BT",
        "NC",
        "CM",
        "KH",
        "CA",
        "KZ",
        "QA",
        "VA",
        "KE",
        "EA",
        "CY",
        "KG",
        "KI",
        "KR",
        "KP",
        "CO",
        "KM",
        "CG",
        "CD",
        "CR",
        "CI",
        "CU",
        "KW",
        "CW",
        "JE",
        "JM",
        "DG",
        "GI",
        "DJ",
        "DM",
        "MN",
        "SZ",
        "TH",
        "EC",
        "ER",
        "VI",
        "AN",
        "VG",
        "CK",
        "MH",
        "SB",
        "BV",
        "CP",
        "HM",
        "IM",
        "AC",
        "CX",
        "SH",
        "NF",
        "PN",
        "IE",
        "FJ",
        "GA",
        "GH",
        "GG",
        "GN",
        "GW",
        "GQ",
        "PG",
        "GD",
        "GP",
        "GU",
        "GT",
        "GY",
        "GF",
        "HT",
        "HN",
        "HK",
        "IS",
        "IQ",
        "IR",
        "JO",
        "IL",
        "LA",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LU",
        "MO",
        "MG",
        "ML",
        "MQ",
        "MW",
        "MY",
        "MT",
        "YT",
        "MX",
        "UM",
        "MM",
        "MC",
        "MS",
        "MR",
        "MA",
        "MZ",
        "NR",
        "AX",
        "BS",
        "KY",
        "IC",
        "CC",
        "FK",
        "FO",
        "PH",
        "MP",
        "MV",
        "MU",
        "SC",
        "TC",
        "ID",
        "IN",
        "AE",
        "FM",
        "VC",
        "KN",
        "LC",
        "MF",
        "PS",
        "US",
        "NL",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "OM",
        "PK",
        "PW",
        "PA",
        "PY",
        "PE",
        "CF",
        "CZ",
        "PF",
        "PR",
        "QO",
        "BQ",
        "IO",
        "TF",
        "RE",
        "RO",
        "RW",
        "ZM",
        "BL",
        "PM",
        "WS",
        "AS",
        "SM",
        "ST",
        "EH",
        "NZ",
        "SN",
        "GS",
        "SL",
        "SG",
        "SY",
        "SO",
        "LK",
        "SS",
        "SD",
        "SR",
        "SJ",
        "SX",
        "TW",
        "TJ",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TV",
        "TN",
        "TM",
        "WF",
        "UG",
        "UY",
        "UZ",
        "VU",
        "XK",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "An Saoghal");
    namesMap.put("002", "Afraga");
    namesMap.put("003", "Aimearaga a Tuath");
    namesMap.put("005", "Aimearaga a Deas");
    namesMap.put("009", "Roinn a' Chuain Shèimh");
    namesMap.put("011", "Afraga an Iar");
    namesMap.put("013", "Meadhan Aimearaga");
    namesMap.put("014", "Afraga an Ear");
    namesMap.put("015", "Afraga a Tuath");
    namesMap.put("017", "Meadhan Afraga");
    namesMap.put("018", "An Roinn-Afraga a Deas");
    namesMap.put("019", "An Dà Aimearaga");
    namesMap.put("021", "An Roinn-Aimearaga a Tuath");
    namesMap.put("029", "Am Muir Caraibeach");
    namesMap.put("030", "Àisea an Ear");
    namesMap.put("034", "Àisea a Deas");
    namesMap.put("035", "Àisea an Ear-Dheas");
    namesMap.put("039", "An Roinn-Eòrpa a Deas");
    namesMap.put("053", "Astràilia is Sealainn Nuadh");
    namesMap.put("054", "Na h-Eileanan Dubha");
    namesMap.put("057", "Roinn nam Meanbh-Eileanan");
    namesMap.put("061", "Poilinèis");
    namesMap.put("142", "Àisea");
    namesMap.put("143", "Meadhan Àisea");
    namesMap.put("145", "Àisea an Iar");
    namesMap.put("150", "An Roinn-Eòrpa");
    namesMap.put("151", "An Roinn-Eòrpa an Ear");
    namesMap.put("154", "An Roinn-Eòrpa a Tuath");
    namesMap.put("155", "An Roinn-Eòrpa an Iar");
    namesMap.put("419", "Aimearaga Laideannach");
    namesMap.put("AC", "Eilean na Deasgabhalach");
    namesMap.put("AE", "Na h-Iomaratan Arabach Aonaichte");
    namesMap.put("AF", "Afghanastàn");
    namesMap.put("AG", "Aintìoga is Barbuda");
    namesMap.put("AL", "Albàinia");
    namesMap.put("AM", "Airmeinia");
    namesMap.put("AN", "Eileanan Aintilia nan Tìrean Ìsle");
    namesMap.put("AO", "Angòla");
    namesMap.put("AQ", "An Antartaig");
    namesMap.put("AR", "An Argantain");
    namesMap.put("AS", "Samotha na h-Airmeireaga");
    namesMap.put("AT", "An Ostair");
    namesMap.put("AU", "Astràilia");
    namesMap.put("AW", "Arùba");
    namesMap.put("AX", "Na h-Eileanan Åland");
    namesMap.put("AZ", "Asarbaideàn");
    namesMap.put("BA", "Bosna is Hearsagobhana");
    namesMap.put("BD", "Bangladais");
    namesMap.put("BE", "A' Bheilg");
    namesMap.put("BF", "Buirciona Faso");
    namesMap.put("BG", "A' Bhulgair");
    namesMap.put("BH", "Bachrain");
    namesMap.put("BI", "Burundaidh");
    namesMap.put("BJ", "Beinin");
    namesMap.put("BM", "Bearmùda");
    namesMap.put("BN", "Brùnaigh");
    namesMap.put("BO", "Boilibhia");
    namesMap.put("BQ", "Ranntair Breatainn na h-Antartaig");
    namesMap.put("BR", "Braisil");
    namesMap.put("BS", "Na h-Eileanan Bathama");
    namesMap.put("BT", "Butàn");
    namesMap.put("BV", "Eilean Bouvet");
    namesMap.put("BW", "Botsuana");
    namesMap.put("BY", "A' Bhealaruis");
    namesMap.put("BZ", "Beilìs");
    namesMap.put("CC", "Na h-Eileanan Cocos (Keeling)");
    namesMap.put("CD", "Congo-Kinshasa");
    namesMap.put("CF", "Poblachd Meadhan Afraga");
    namesMap.put("CG", "Congo-Brazzaville");
    namesMap.put("CH", "An Eilbheis");
    namesMap.put("CK", "Eileanan Cook");
    namesMap.put("CL", "An t-Sile");
    namesMap.put("CM", "Camarun");
    namesMap.put("CN", "An t-Sìn");
    namesMap.put("CO", "Coloimbia");
    namesMap.put("CP", "Eilean Clipperton");
    namesMap.put("CR", "Costa Rìcea");
    namesMap.put("CU", "Cùba");
    namesMap.put("CV", "An Ceap Uaine");
    namesMap.put("CX", "Eilean na Nollaig");
    namesMap.put("CY", "Cìopras");
    namesMap.put("CZ", "Poblachd na Seice");
    namesMap.put("DE", "A' Ghearmailt");
    namesMap.put("DJ", "Diobùtaidh");
    namesMap.put("DK", "An Danmhairg");
    namesMap.put("DM", "Doiminicea");
    namesMap.put("DO", "A' Phoblachd Dhoiminiceach");
    namesMap.put("DZ", "Aildiria");
    namesMap.put("EA", "Ceuta is Melilla");
    namesMap.put("EC", "Eacuador");
    namesMap.put("EE", "An Eastoin");
    namesMap.put("EG", "An Èiphit");
    namesMap.put("EH", "Sathara an Iar");
    namesMap.put("ER", "Eartra");
    namesMap.put("ES", "An Spàinn");
    namesMap.put("ET", "An Itiop");
    namesMap.put("EU", "An t-Aonadh Eòrpach");
    namesMap.put("FI", "An Fhionnlann");
    namesMap.put("FJ", "Fìdi");
    namesMap.put("FK", "Na h-Eileanan Fàclannach");
    namesMap.put("FM", "Na Meanbh-Eileanan");
    namesMap.put("FO", "Na h-Eileanan Fàro");
    namesMap.put("FR", "An Fhraing");
    namesMap.put("GB", "An Rìoghachd Aonaichte");
    namesMap.put("GD", "Greanàda");
    namesMap.put("GE", "A' Chairtbheil");
    namesMap.put("GF", "Guidheàna na Frainge");
    namesMap.put("GG", "Geàrnsaidh");
    namesMap.put("GH", "Gàna");
    namesMap.put("GI", "Diobraltar");
    namesMap.put("GL", "A' Ghraonlann");
    namesMap.put("GM", "A' Ghaimbia");
    namesMap.put("GN", "Gini");
    namesMap.put("GP", "Guadalup");
    namesMap.put("GQ", "Gini Mheadhan-Chriosach");
    namesMap.put("GR", "A' Ghreug");
    namesMap.put("GS", "Seòrsea a Deas is na h-Eileanan Sandwich a Deas");
    namesMap.put("GT", "Guatamala");
    namesMap.put("GW", "Gini-Bioso");
    namesMap.put("GY", "Guidheàna");
    namesMap.put("HK", "Hong Kong SAR na Sìne");
    namesMap.put("HM", "Eilean Heard is MhicDhòmhnaill");
    namesMap.put("HN", "Hondùras");
    namesMap.put("HR", "A' Chròthais");
    namesMap.put("HT", "Haidhti");
    namesMap.put("HU", "An Ungair");
    namesMap.put("IC", "Na h-Eileanan Canàrach");
    namesMap.put("ID", "Na h-Innd Innse");
    namesMap.put("IE", "Èirinn");
    namesMap.put("IL", "Iosrael");
    namesMap.put("IM", "Eilean Manainn");
    namesMap.put("IN", "Na h-Innseachan");
    namesMap.put("IO", "Ranntair Breatannach Cuan nan Innseachan");
    namesMap.put("IQ", "Ioràc");
    namesMap.put("IR", "Ioràn");
    namesMap.put("IS", "Innis Tìle");
    namesMap.put("IT", "An Eadailt");
    namesMap.put("JE", "Deàrsaidh");
    namesMap.put("JM", "Diameuga");
    namesMap.put("JO", "Iòrdan");
    namesMap.put("JP", "An t-Seapan");
    namesMap.put("KE", "Ceinia");
    namesMap.put("KG", "Cìorgastan");
    namesMap.put("KH", "Cambuidea");
    namesMap.put("KI", "Ciribeas");
    namesMap.put("KN", "Naomh Crìstean is Nibheis");
    namesMap.put("KP", "Coirèa a Tuath");
    namesMap.put("KR", "Coirèa a Deas");
    namesMap.put("KW", "Cuibhèit");
    namesMap.put("KY", "Na h-Eileanan Caimean");
    namesMap.put("KZ", "Casachstàn");
    namesMap.put("LA", "Làthos");
    namesMap.put("LB", "Leabanon");
    namesMap.put("LC", "Naomh Lùisea");
    namesMap.put("LK", "Sri Lanca");
    namesMap.put("LR", "Libèir");
    namesMap.put("LS", "Leasoto");
    namesMap.put("LT", "An Liotuain");
    namesMap.put("LU", "Lugsamburg");
    namesMap.put("LV", "An Laitbhe");
    namesMap.put("LY", "Libia");
    namesMap.put("MA", "Moroco");
    namesMap.put("MD", "A' Mholdobha");
    namesMap.put("ME", "Am Monadh Neagrach");
    namesMap.put("MF", "Naomh Màrtainn");
    namesMap.put("MG", "Madagasgar");
    namesMap.put("MH", "Eileanan Mharshall");
    namesMap.put("MK", "A' Mhasadon");
    namesMap.put("ML", "Màili");
    namesMap.put("MM", "Miànmar (Burma)");
    namesMap.put("MN", "Dùthaich nam Mongol");
    namesMap.put("MO", "Macàthu SAR na Sìne");
    namesMap.put("MP", "Na h-Eileanan Mairianach a Tuath");
    namesMap.put("MQ", "Mairtinic");
    namesMap.put("MR", "Moratàinea");
    namesMap.put("MS", "Montsarat");
    namesMap.put("MU", "Na h-Eileanan Mhoiriseas");
    namesMap.put("MV", "Na h-Eileanan Maladaibh");
    namesMap.put("MW", "Malabhaidh");
    namesMap.put("MX", "Meagsago");
    namesMap.put("MY", "Malaidhsea");
    namesMap.put("MZ", "Mòsaimbic");
    namesMap.put("NA", "An Namaib");
    namesMap.put("NC", "Cailleann Nuadh");
    namesMap.put("NE", "Nìgeir");
    namesMap.put("NF", "Eilean Norfolk");
    namesMap.put("NG", "Nigèiria");
    namesMap.put("NI", "Niocaragua");
    namesMap.put("NL", "Na Tìrean Ìsle");
    namesMap.put("NO", "An Nirribhidh");
    namesMap.put("NP", "Neapàl");
    namesMap.put("NR", "Nabhru");
    namesMap.put("NZ", "Sealainn Nuadh");
    namesMap.put("OM", "Omàn");
    namesMap.put("PE", "Pearù");
    namesMap.put("PF", "Poilinèis na Frainge");
    namesMap.put("PG", "Gini Nuadh Phaputhach");
    namesMap.put("PH", "Na h-Eileanan Filipineach");
    namesMap.put("PK", "Pagastàn");
    namesMap.put("PL", "A' Phòlainn");
    namesMap.put("PM", "Saint Pierre is Miquelon");
    namesMap.put("PN", "Eilean Peit a' Chàirn");
    namesMap.put("PR", "Porto Rìceo");
    namesMap.put("PS", "Na Ranntairean Palastaineach");
    namesMap.put("PT", "A' Phortagail");
    namesMap.put("PW", "Palabh");
    namesMap.put("PY", "Paraguaidh");
    namesMap.put("QA", "Catar");
    namesMap.put("RO", "Romàinia");
    namesMap.put("RS", "An t-Sèirb");
    namesMap.put("RU", "An Ruis");
    namesMap.put("RW", "Rubhanda");
    namesMap.put("SA", "Aràibia nan Sabhd");
    namesMap.put("SB", "Eileanan Sholaimh");
    namesMap.put("SC", "Na h-Eileanan Sheiseall");
    namesMap.put("SD", "Sudàn");
    namesMap.put("SE", "An t-Suain");
    namesMap.put("SG", "Singeapòr");
    namesMap.put("SH", "Eilean Naomh Eilidh");
    namesMap.put("SI", "An t-Slòbhain");
    namesMap.put("SJ", "Svalbard is Jan Mayen");
    namesMap.put("SK", "An t-Slòbhac");
    namesMap.put("SL", "Siarra Leòmhann");
    namesMap.put("SN", "Seanagal");
    namesMap.put("SO", "Somàilia");
    namesMap.put("SR", "Suranam");
    namesMap.put("ST", "São Tomé is Príncipe");
    namesMap.put("SV", "An Salbhador");
    namesMap.put("SY", "Siridhea");
    namesMap.put("SZ", "Dùthaich nan Suasaidh");
    namesMap.put("TC", "Na h-Eileanan Turcach is Caiceo");
    namesMap.put("TD", "An t-Seàd");
    namesMap.put("TF", "Ranntairean a Deas na Frainge");
    namesMap.put("TH", "Dùthaich nan Tàidh");
    namesMap.put("TJ", "Taidigeastàn");
    namesMap.put("TM", "Turcmanastàn");
    namesMap.put("TN", "Tuinisea");
    namesMap.put("TR", "An Tuirc");
    namesMap.put("TT", "Trianaid is Tobago");
    namesMap.put("TV", "Tubhalu");
    namesMap.put("TW", "Taidh-Bhàn");
    namesMap.put("TZ", "An Tansan");
    namesMap.put("UA", "An Ucràin");
    namesMap.put("UM", "Meanbh-Eileanan Iomallach nan Stàitean Aonaichte");
    namesMap.put("US", "Na Stàitean Aonaichte");
    namesMap.put("UY", "Uruguaidh");
    namesMap.put("UZ", "Usbagastan");
    namesMap.put("VA", "Cathair na Bhatacain");
    namesMap.put("VC", "Naomh Bhionsant agus Eileanan Greanadach");
    namesMap.put("VE", "A' Bheiniseala");
    namesMap.put("VG", "Eileanan Breatannach na Maighdinn");
    namesMap.put("VI", "Eileanan Aimeireagach na Maighdinn");
    namesMap.put("VN", "Bhiet-Nam");
    namesMap.put("WF", "Uallas agus Futuna");
    namesMap.put("WS", "Samotha");
    namesMap.put("YE", "An Eaman");
    namesMap.put("ZA", "Afraga a Deas");
    namesMap.put("ZM", "Sàimbia");
    namesMap.put("ZW", "An t-Sìombab");
    namesMap.put("ZZ", "Ranntair Neo-Aithnichte");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "An Saoghal",
        "002": "Afraga",
        "003": "Aimearaga a Tuath",
        "005": "Aimearaga a Deas",
        "009": "Roinn a' Chuain Shèimh",
        "011": "Afraga an Iar",
        "013": "Meadhan Aimearaga",
        "014": "Afraga an Ear",
        "015": "Afraga a Tuath",
        "017": "Meadhan Afraga",
        "018": "An Roinn-Afraga a Deas",
        "019": "An Dà Aimearaga",
        "021": "An Roinn-Aimearaga a Tuath",
        "029": "Am Muir Caraibeach",
        "030": "Àisea an Ear",
        "034": "Àisea a Deas",
        "035": "Àisea an Ear-Dheas",
        "039": "An Roinn-Eòrpa a Deas",
        "053": "Astràilia is Sealainn Nuadh",
        "054": "Na h-Eileanan Dubha",
        "057": "Roinn nam Meanbh-Eileanan",
        "061": "Poilinèis",
        "142": "Àisea",
        "143": "Meadhan Àisea",
        "145": "Àisea an Iar",
        "150": "An Roinn-Eòrpa",
        "151": "An Roinn-Eòrpa an Ear",
        "154": "An Roinn-Eòrpa a Tuath",
        "155": "An Roinn-Eòrpa an Iar",
        "419": "Aimearaga Laideannach",
        "AC": "Eilean na Deasgabhalach",
        "AE": "Na h-Iomaratan Arabach Aonaichte",
        "AF": "Afghanastàn",
        "AG": "Aintìoga is Barbuda",
        "AL": "Albàinia",
        "AM": "Airmeinia",
        "AN": "Eileanan Aintilia nan Tìrean Ìsle",
        "AO": "Angòla",
        "AQ": "An Antartaig",
        "AR": "An Argantain",
        "AS": "Samotha na h-Airmeireaga",
        "AT": "An Ostair",
        "AU": "Astràilia",
        "AW": "Arùba",
        "AX": "Na h-Eileanan Åland",
        "AZ": "Asarbaideàn",
        "BA": "Bosna is Hearsagobhana",
        "BD": "Bangladais",
        "BE": "A' Bheilg",
        "BF": "Buirciona Faso",
        "BG": "A' Bhulgair",
        "BH": "Bachrain",
        "BI": "Burundaidh",
        "BJ": "Beinin",
        "BM": "Bearmùda",
        "BN": "Brùnaigh",
        "BO": "Boilibhia",
        "BQ": "Ranntair Breatainn na h-Antartaig",
        "BR": "Braisil",
        "BS": "Na h-Eileanan Bathama",
        "BT": "Butàn",
        "BV": "Eilean Bouvet",
        "BW": "Botsuana",
        "BY": "A' Bhealaruis",
        "BZ": "Beilìs",
        "CC": "Na h-Eileanan Cocos (Keeling)",
        "CD": "Congo-Kinshasa",
        "CF": "Poblachd Meadhan Afraga",
        "CG": "Congo-Brazzaville",
        "CH": "An Eilbheis",
        "CK": "Eileanan Cook",
        "CL": "An t-Sile",
        "CM": "Camarun",
        "CN": "An t-Sìn",
        "CO": "Coloimbia",
        "CP": "Eilean Clipperton",
        "CR": "Costa Rìcea",
        "CU": "Cùba",
        "CV": "An Ceap Uaine",
        "CX": "Eilean na Nollaig",
        "CY": "Cìopras",
        "CZ": "Poblachd na Seice",
        "DE": "A' Ghearmailt",
        "DJ": "Diobùtaidh",
        "DK": "An Danmhairg",
        "DM": "Doiminicea",
        "DO": "A' Phoblachd Dhoiminiceach",
        "DZ": "Aildiria",
        "EA": "Ceuta is Melilla",
        "EC": "Eacuador",
        "EE": "An Eastoin",
        "EG": "An Èiphit",
        "EH": "Sathara an Iar",
        "ER": "Eartra",
        "ES": "An Spàinn",
        "ET": "An Itiop",
        "EU": "An t-Aonadh Eòrpach",
        "FI": "An Fhionnlann",
        "FJ": "Fìdi",
        "FK": "Na h-Eileanan Fàclannach",
        "FM": "Na Meanbh-Eileanan",
        "FO": "Na h-Eileanan Fàro",
        "FR": "An Fhraing",
        "GB": "An Rìoghachd Aonaichte",
        "GD": "Greanàda",
        "GE": "A' Chairtbheil",
        "GF": "Guidheàna na Frainge",
        "GG": "Geàrnsaidh",
        "GH": "Gàna",
        "GI": "Diobraltar",
        "GL": "A' Ghraonlann",
        "GM": "A' Ghaimbia",
        "GN": "Gini",
        "GP": "Guadalup",
        "GQ": "Gini Mheadhan-Chriosach",
        "GR": "A' Ghreug",
        "GS": "Seòrsea a Deas is na h-Eileanan Sandwich a Deas",
        "GT": "Guatamala",
        "GW": "Gini-Bioso",
        "GY": "Guidheàna",
        "HK": "Hong Kong SAR na Sìne",
        "HM": "Eilean Heard is MhicDhòmhnaill",
        "HN": "Hondùras",
        "HR": "A' Chròthais",
        "HT": "Haidhti",
        "HU": "An Ungair",
        "IC": "Na h-Eileanan Canàrach",
        "ID": "Na h-Innd Innse",
        "IE": "Èirinn",
        "IL": "Iosrael",
        "IM": "Eilean Manainn",
        "IN": "Na h-Innseachan",
        "IO": "Ranntair Breatannach Cuan nan Innseachan",
        "IQ": "Ioràc",
        "IR": "Ioràn",
        "IS": "Innis Tìle",
        "IT": "An Eadailt",
        "JE": "Deàrsaidh",
        "JM": "Diameuga",
        "JO": "Iòrdan",
        "JP": "An t-Seapan",
        "KE": "Ceinia",
        "KG": "Cìorgastan",
        "KH": "Cambuidea",
        "KI": "Ciribeas",
        "KN": "Naomh Crìstean is Nibheis",
        "KP": "Coirèa a Tuath",
        "KR": "Coirèa a Deas",
        "KW": "Cuibhèit",
        "KY": "Na h-Eileanan Caimean",
        "KZ": "Casachstàn",
        "LA": "Làthos",
        "LB": "Leabanon",
        "LC": "Naomh Lùisea",
        "LK": "Sri Lanca",
        "LR": "Libèir",
        "LS": "Leasoto",
        "LT": "An Liotuain",
        "LU": "Lugsamburg",
        "LV": "An Laitbhe",
        "LY": "Libia",
        "MA": "Moroco",
        "MD": "A' Mholdobha",
        "ME": "Am Monadh Neagrach",
        "MF": "Naomh Màrtainn",
        "MG": "Madagasgar",
        "MH": "Eileanan Mharshall",
        "MK": "A' Mhasadon",
        "ML": "Màili",
        "MM": "Miànmar (Burma)",
        "MN": "Dùthaich nam Mongol",
        "MO": "Macàthu SAR na Sìne",
        "MP": "Na h-Eileanan Mairianach a Tuath",
        "MQ": "Mairtinic",
        "MR": "Moratàinea",
        "MS": "Montsarat",
        "MU": "Na h-Eileanan Mhoiriseas",
        "MV": "Na h-Eileanan Maladaibh",
        "MW": "Malabhaidh",
        "MX": "Meagsago",
        "MY": "Malaidhsea",
        "MZ": "Mòsaimbic",
        "NA": "An Namaib",
        "NC": "Cailleann Nuadh",
        "NE": "Nìgeir",
        "NF": "Eilean Norfolk",
        "NG": "Nigèiria",
        "NI": "Niocaragua",
        "NL": "Na Tìrean Ìsle",
        "NO": "An Nirribhidh",
        "NP": "Neapàl",
        "NR": "Nabhru",
        "NZ": "Sealainn Nuadh",
        "OM": "Omàn",
        "PE": "Pearù",
        "PF": "Poilinèis na Frainge",
        "PG": "Gini Nuadh Phaputhach",
        "PH": "Na h-Eileanan Filipineach",
        "PK": "Pagastàn",
        "PL": "A' Phòlainn",
        "PM": "Saint Pierre is Miquelon",
        "PN": "Eilean Peit a' Chàirn",
        "PR": "Porto Rìceo",
        "PS": "Na Ranntairean Palastaineach",
        "PT": "A' Phortagail",
        "PW": "Palabh",
        "PY": "Paraguaidh",
        "QA": "Catar",
        "RO": "Romàinia",
        "RS": "An t-Sèirb",
        "RU": "An Ruis",
        "RW": "Rubhanda",
        "SA": "Aràibia nan Sabhd",
        "SB": "Eileanan Sholaimh",
        "SC": "Na h-Eileanan Sheiseall",
        "SD": "Sudàn",
        "SE": "An t-Suain",
        "SG": "Singeapòr",
        "SH": "Eilean Naomh Eilidh",
        "SI": "An t-Slòbhain",
        "SJ": "Svalbard is Jan Mayen",
        "SK": "An t-Slòbhac",
        "SL": "Siarra Leòmhann",
        "SN": "Seanagal",
        "SO": "Somàilia",
        "SR": "Suranam",
        "ST": "São Tomé is Príncipe",
        "SV": "An Salbhador",
        "SY": "Siridhea",
        "SZ": "Dùthaich nan Suasaidh",
        "TC": "Na h-Eileanan Turcach is Caiceo",
        "TD": "An t-Seàd",
        "TF": "Ranntairean a Deas na Frainge",
        "TH": "Dùthaich nan Tàidh",
        "TJ": "Taidigeastàn",
        "TM": "Turcmanastàn",
        "TN": "Tuinisea",
        "TR": "An Tuirc",
        "TT": "Trianaid is Tobago",
        "TV": "Tubhalu",
        "TW": "Taidh-Bhàn",
        "TZ": "An Tansan",
        "UA": "An Ucràin",
        "UM": "Meanbh-Eileanan Iomallach nan Stàitean Aonaichte",
        "US": "Na Stàitean Aonaichte",
        "UY": "Uruguaidh",
        "UZ": "Usbagastan",
        "VA": "Cathair na Bhatacain",
        "VC": "Naomh Bhionsant agus Eileanan Greanadach",
        "VE": "A' Bheiniseala",
        "VG": "Eileanan Breatannach na Maighdinn",
        "VI": "Eileanan Aimeireagach na Maighdinn",
        "VN": "Bhiet-Nam",
        "WF": "Uallas agus Futuna",
        "WS": "Samotha",
        "YE": "An Eaman",
        "ZA": "Afraga a Deas",
        "ZM": "Sàimbia",
        "ZW": "An t-Sìombab",
        "ZZ": "Ranntair Neo-Aithnichte"
    };
  }-*/;
}
