/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.jetty.JettyServerAdapter;
import ch.qos.logback.access.joran.JoranConfigurator;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.FilterAttachable;
import ch.qos.logback.core.spi.FilterAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.FileUtil;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.LifeCycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestLogImpl
extends ContextBase
implements RequestLog,
AppenderAttachable<IAccessEvent>,
FilterAttachable<IAccessEvent> {
    public static final String DEFAULT_CONFIG_FILE = "etc" + File.separatorChar + "logback-access.xml";
    AppenderAttachableImpl<IAccessEvent> aai = new AppenderAttachableImpl();
    FilterAttachableImpl<IAccessEvent> fai = new FilterAttachableImpl();
    String fileName;
    String resource;
    boolean started = false;
    boolean quiet = false;

    public RequestLogImpl() {
        this.putObject("EVALUATOR_MAP", new HashMap());
    }

    public void log(Request jettyRequest, Response jettyResponse) {
        JettyServerAdapter adapter = new JettyServerAdapter(jettyRequest, jettyResponse);
        AccessEvent accessEvent = new AccessEvent((HttpServletRequest)jettyRequest, (HttpServletResponse)jettyResponse, adapter);
        if (this.getFilterChainDecision(accessEvent) == FilterReply.DENY) {
            return;
        }
        this.aai.appendLoopOnAppenders((Object)accessEvent);
    }

    private void addInfo(String msg) {
        this.getStatusManager().add((Status)new InfoStatus(msg, (Object)this));
    }

    private void addError(String msg) {
        this.getStatusManager().add((Status)new ErrorStatus(msg, (Object)this));
    }

    public void start() {
        URL configURL = this.getConfigurationFileURL();
        if (configURL != null) {
            this.runJoranOnFile(configURL);
        } else {
            this.addError("Could not find configuration file for logback-access");
        }
        if (!this.isQuiet()) {
            StatusPrinter.print((StatusManager)this.getStatusManager());
        }
        this.started = true;
    }

    URL getConfigurationFileURL() {
        if (this.fileName != null) {
            this.addInfo("Will use configuration file [" + this.fileName + "]");
            File file = new File(this.fileName);
            if (!file.exists()) {
                return null;
            }
            return FileUtil.fileToURL((File)file);
        }
        if (this.resource != null) {
            this.addInfo("Will use configuration resource [" + this.resource + "]");
            return ((Object)((Object)this)).getClass().getResource(this.resource);
        }
        String jettyHomeProperty = OptionHelper.getSystemProperty((String)"jetty.home");
        String defaultConfigFile = DEFAULT_CONFIG_FILE;
        if (!OptionHelper.isEmpty((String)jettyHomeProperty)) {
            defaultConfigFile = jettyHomeProperty + File.separatorChar + DEFAULT_CONFIG_FILE;
        } else {
            this.addInfo("[jetty.home] system property not set.");
        }
        File file = new File(defaultConfigFile);
        this.addInfo("Assuming default configuration file [" + defaultConfigFile + "]");
        if (!file.exists()) {
            return null;
        }
        return FileUtil.fileToURL((File)file);
    }

    private void runJoranOnFile(URL configURL) {
        try {
            JoranConfigurator jc = new JoranConfigurator();
            jc.setContext((Context)this);
            jc.doConfigure(configURL);
            if (this.getName() == null) {
                this.setName("LogbackRequestLog");
            }
        }
        catch (JoranException joranException) {
            // empty catch block
        }
    }

    public void stop() {
        this.aai.detachAndStopAllAppenders();
        this.started = false;
    }

    public boolean isRunning() {
        return this.started;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStarting() {
        return false;
    }

    public boolean isStopping() {
        return false;
    }

    public boolean isStopped() {
        return !this.started;
    }

    public boolean isFailed() {
        return false;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void addAppender(Appender<IAccessEvent> newAppender) {
        this.aai.addAppender(newAppender);
    }

    public Iterator<Appender<IAccessEvent>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    public Appender<IAccessEvent> getAppender(String name) {
        return this.aai.getAppender(name);
    }

    public boolean isAttached(Appender<IAccessEvent> appender) {
        return this.aai.isAttached(appender);
    }

    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    public boolean detachAppender(Appender<IAccessEvent> appender) {
        return this.aai.detachAppender(appender);
    }

    public boolean detachAppender(String name) {
        return this.aai.detachAppender(name);
    }

    public void addFilter(Filter<IAccessEvent> newFilter) {
        this.fai.addFilter(newFilter);
    }

    public void clearAllFilters() {
        this.fai.clearAllFilters();
    }

    public List<Filter<IAccessEvent>> getCopyOfAttachedFiltersList() {
        return this.fai.getCopyOfAttachedFiltersList();
    }

    public FilterReply getFilterChainDecision(IAccessEvent event) {
        return this.fai.getFilterChainDecision((Object)event);
    }

    public void addLifeCycleListener(LifeCycle.Listener listener) {
    }

    public void removeLifeCycleListener(LifeCycle.Listener listener) {
    }
}

