/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.console.ProjectLogInfo;
import org.eclipse.codewind.ui.internal.actions.HideAllLogsAction;
import org.eclipse.codewind.ui.internal.actions.LogFileAction;
import org.eclipse.codewind.ui.internal.actions.ShowAllLogsAction;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;

public class LogFileActionProvider
extends CommonActionProvider {
    private ShowAllLogsAction showAllLogsAction;
    private HideAllLogsAction hideAllLogsAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.showAllLogsAction = new ShowAllLogsAction();
        this.hideAllLogsAction = new HideAllLogsAction();
    }

    public void fillContextMenu(IMenuManager menu) {
        CodewindEclipseApplication app;
        Object obj;
        ICommonViewerSite viewSite = this.getActionSite().getViewSite();
        ISelection selection = viewSite.getSelectionProvider().getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindEclipseApplication && (app = (CodewindEclipseApplication)obj).isAvailable() && app.getLogInfos() != null && !app.getLogInfos().isEmpty()) {
            MenuManager menuMgr = new MenuManager(Messages.ShowLogFilesMenu, "ShowLogFiles");
            this.showAllLogsAction.setApp(app);
            menuMgr.add((IAction)this.showAllLogsAction);
            this.hideAllLogsAction.setApp(app);
            menuMgr.add((IAction)this.hideAllLogsAction);
            menuMgr.add((IContributionItem)new Separator());
            for (ProjectLogInfo logInfo : app.getLogInfos()) {
                menuMgr.add((IAction)new LogFileAction(app, logInfo, viewSite));
            }
            menu.appendToGroup("group.show", (IContributionItem)menuMgr);
        }
    }
}

