/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.LogLevels;
import org.eclipse.codewind.core.internal.cli.OtherUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.wizards.LogLevelSelectionDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;

public class LogLevelAction
extends SelectionProviderAction {
    private CodewindConnection conn;
    private LogLevels logLevels;

    public LogLevelAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.LogLevelAction);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindConnection) {
            this.conn = (CodewindConnection)obj;
            this.setEnabled(this.conn.isConnected());
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.conn == null) {
            Logger.logError((String)"LogLevelAction ran but no connection was selected");
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.LogLevelsFetchTaskLabel, (Object)LogLevelAction.this.conn.getName()), (int)100);
                    LogLevelAction.this.logLevels = OtherUtil.getLoglevels((String)LogLevelAction.this.conn.getName(), (String)LogLevelAction.this.conn.getConid(), (IProgressMonitor)mon.split(100));
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e, "An error occurred trying to fetch the server log levels for connection: " + LogLevelAction.this.conn.getName());
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Logger.logError((String)("An error occurred getting the log levels for connection: " + this.conn.getName()), (Throwable)e);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LogLevelsFetchErrorTitle, (String)NLS.bind((String)Messages.LogLevelsFetchError, (Object[])new String[]{this.conn.getName(), cause.getLocalizedMessage()}));
            return;
        }
        catch (InterruptedException e) {
            return;
        }
        LogLevelSelectionDialog dialog = new LogLevelSelectionDialog(Display.getDefault().getActiveShell(), this.logLevels);
        if (dialog.open() == 0) {
            final String level = dialog.getSelectedLevel();
            if (!this.logLevels.getCurrentLevel().equals(level)) {
                Job job = new Job(NLS.bind((String)Messages.LogLevelSetJobLabel, (Object[])new String[]{this.conn.getName(), level})){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            OtherUtil.setLoglevels((String)LogLevelAction.this.conn.getName(), (String)level, (String)LogLevelAction.this.conn.getConid(), (IProgressMonitor)monitor);
                        }
                        catch (Exception e) {
                            Logger.logError((String)("An error occurred updating the log level for the " + LogLevelAction.this.conn.getName() + " connection to: " + level), (Throwable)e);
                            return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.LogLevelSetError, (Object[])new String[]{level, LogLevelAction.this.conn.getName()}), (Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
    }

    public boolean showAction() {
        return CodewindCorePlugin.getDefault().getPreferenceStore().getBoolean("enableSupportFeatures");
    }
}

