/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.console;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class FileConsoleMonitorThread
extends Thread {
    private static final int DELAY_MS = 1000;
    private final File inputFile;
    private BufferedReader inputReader;
    private final IOConsoleOutputStream output;
    private long fileLength = -1L;
    private volatile boolean run = true;

    public FileConsoleMonitorThread(String consoleName, File inputFile, IOConsoleOutputStream output) {
        this.inputFile = inputFile;
        this.output = output;
        this.setPriority(2);
        this.setDaemon(true);
        this.setName(consoleName + " MonitorThread");
    }

    @Override
    public void run() {
        while (this.run && !Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                if (this.inputReader != null && this.fileLength != -1L && this.fileLength > this.inputFile.length()) {
                    this.inputReader.close();
                    this.inputReader = null;
                }
                if (this.inputReader == null && this.inputFile.exists()) {
                    this.inputReader = new BufferedReader(new FileReader(this.inputFile));
                }
                if (this.inputReader == null) {
                    return;
                }
                this.fileLength = this.inputFile.length();
                String s = this.inputReader.readLine();
                while (s != null) {
                    this.output.write(s + System.lineSeparator());
                    s = this.inputReader.readLine();
                }
            }
            catch (IOException e) {
                Logger.logError("Error updating application log for file " + this.inputFile.getAbsolutePath(), e);
            }
        }
        try {
            if (this.inputReader != null) {
                this.inputReader.close();
            }
        }
        catch (IOException e) {
            Logger.logError(e);
        }
    }

    void disable() {
        this.run = false;
    }
}

