/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.prefs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.ImagePushRegistryInfo;
import org.eclipse.codewind.core.internal.connection.RegistryInfo;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class RegistryManagementComposite
extends Composite {
    private final CodewindConnection connection;
    private final List<RegistryInfo> regList;
    private final ImagePushRegistryInfo pushReg;
    private List<RegEntry> regEntries;
    private boolean supportsPushReg = false;
    private Table regTable;
    private Button addButton;
    private Button removeButton;
    private Button pushRegButton;
    private Color gray;

    public RegistryManagementComposite(Composite parent, CodewindConnection connection, List<RegistryInfo> regList, ImagePushRegistryInfo pushReg) {
        super(parent, 0);
        this.connection = connection;
        this.regList = regList;
        this.pushReg = pushReg;
        this.regEntries = this.getRegEntries(regList, pushReg);
        this.supportsPushReg = !connection.isLocal();
        this.createControl();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 5;
        this.setLayout((Layout)layout);
        Text description = new Text((Composite)this, 74);
        description.setText("");
        description.setBackground(this.getBackground());
        description.setForeground(this.getForeground());
        description.setLayoutData((Object)new GridData(4, 3, true, false, 1, 1));
        Link learnMoreLink = new Link((Composite)this, 0);
        learnMoreLink.setText("<a>" + Messages.RegMgmtLearnMoreLink + "</a>");
        learnMoreLink.setLayoutData((Object)new GridData(3, 3, false, false, 1, 1));
        learnMoreLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.getExternalBrowser();
                    URL url = new URL("https://www.eclipse.org/codewind/image-registry-credentials.html");
                    browser.openURL(url);
                }
                catch (Exception e) {
                    Logger.logError((String)"An error occurred trying to open an external browser at: https://www.eclipse.org/codewind/mdteclipseworkingwithtemplates.html", (Throwable)e);
                }
            }
        });
        new Label((Composite)this, 0).setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        Composite tableComp = new Composite((Composite)this, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableColumnLayout);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.regTable = new Table(tableComp, 68354);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 100;
        this.regTable.setLayoutData((Object)data);
        TableColumn addressColumn = new TableColumn(this.regTable, 0);
        addressColumn.setText(Messages.RegMgmtAddressColumn);
        addressColumn.setResizable(true);
        TableColumn usernameColumn = new TableColumn(this.regTable, 0);
        usernameColumn.setText(Messages.RegMgmtUsernameColumn);
        usernameColumn.setResizable(true);
        TableColumn namespaceColumn = null;
        TableColumn pushColumn = null;
        if (this.supportsPushReg) {
            namespaceColumn = new TableColumn(this.regTable, 0);
            namespaceColumn.setText(Messages.RegMgmtNamespaceColumn);
            namespaceColumn.setResizable(true);
            pushColumn = new TableColumn(this.regTable, 0);
            pushColumn.setText(Messages.RegMgmtPushRegColumn);
            pushColumn.setResizable(true);
        }
        this.regTable.setHeaderVisible(true);
        this.regTable.setLinesVisible(true);
        this.regTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RegistryManagementComposite.this.updateButtons();
            }
        });
        this.addButton = new Button((Composite)this, 8);
        this.addButton.setText(Messages.RegMgmtAddButton);
        this.addButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.pushRegButton = new Button((Composite)this, 8);
        this.pushRegButton.setText(Messages.RegMgmtSetPushButton);
        this.pushRegButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.removeButton = new Button((Composite)this, 8);
        this.removeButton.setText(Messages.RegMgmtRemoveButton);
        this.removeButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RegEntry regEntry;
                AddDialog dialog = new AddDialog(RegistryManagementComposite.this.getShell());
                if (dialog.open() == 0 && (regEntry = dialog.getNewRegEntry()) != null) {
                    if (regEntry.isPushReg) {
                        RegistryManagementComposite.this.regEntries.stream().forEach(entry -> {
                            entry.isPushReg = false;
                        });
                    }
                    RegistryManagementComposite.this.regEntries.add(regEntry);
                    RegistryManagementComposite.this.createItems();
                }
            }
        });
        this.pushRegButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] items = RegistryManagementComposite.this.regTable.getSelection();
                if (items.length != 1) {
                    return;
                }
                RegEntry pushReg = (RegEntry)items[0].getData();
                if (pushReg.namespace == null || pushReg.namespace.isEmpty()) {
                    NamespaceDialog dialog = new NamespaceDialog(RegistryManagementComposite.this.getShell());
                    if (dialog.open() == 0) {
                        pushReg.namespace = dialog.getNamespace();
                    } else {
                        return;
                    }
                }
                RegistryManagementComposite.this.regEntries.stream().forEach(entry -> {
                    entry.isPushReg = entry.address.equals(pushReg.address);
                });
                RegistryManagementComposite.this.createItems();
                RegistryManagementComposite.this.updateButtons();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Arrays.stream(RegistryManagementComposite.this.regTable.getSelection()).forEach(item -> RegistryManagementComposite.this.regEntries.remove(item.getData()));
                RegistryManagementComposite.this.createItems();
            }
        });
        String descText = this.supportsPushReg ? Messages.RegMgmtDescription : Messages.RegMgmtLocalDescription;
        description.setText(descText);
        Arrays.stream(this.regTable.getColumns()).forEach(TableColumn::pack);
        tableColumnLayout.setColumnData((Widget)addressColumn, (ColumnLayoutData)new ColumnWeightData(10, Math.max(250, addressColumn.getWidth()), true));
        tableColumnLayout.setColumnData((Widget)usernameColumn, (ColumnLayoutData)new ColumnWeightData(4, Math.max(75, usernameColumn.getWidth()), true));
        if (this.supportsPushReg) {
            tableColumnLayout.setColumnData((Widget)namespaceColumn, (ColumnLayoutData)new ColumnWeightData(4, Math.max(75, namespaceColumn.getWidth()), true));
            tableColumnLayout.setColumnData((Widget)pushColumn, (ColumnLayoutData)new ColumnWeightData(1, Math.max(20, pushColumn.getWidth()), true));
        }
        this.createItems();
        this.updateButtons();
    }

    private void createItems() {
        this.regTable.removeAll();
        for (RegEntry regEntry : this.regEntries) {
            TableItem item = new TableItem(this.regTable, 0);
            item.setData((Object)regEntry);
            item.setText(0, regEntry.address);
            item.setText(1, regEntry.username);
            if (!this.supportsPushReg) continue;
            item.setText(2, regEntry.namespace == null ? "" : regEntry.namespace);
            item.setForeground(2, regEntry.isPushReg ? item.getForeground() : this.getGray(item));
            item.setText(3, regEntry.isPushReg ? Messages.RegMgmtPushRegTrue : Messages.RegMgmtPushRegFalse);
        }
    }

    private Color getGray(TableItem item) {
        if (this.gray == null) {
            Color fg = item.getForeground();
            Color bg = item.getBackground();
            this.gray = new Color(fg.getDevice(), (fg.getRed() + bg.getRed()) / 2, (fg.getGreen() + bg.getGreen()) / 2, (fg.getBlue() + bg.getBlue()) / 2);
        }
        return this.gray;
    }

    public void dispose() {
        if (this.gray != null) {
            this.gray.dispose();
        }
    }

    private void updateButtons() {
        this.removeButton.setEnabled(this.regTable.getSelection().length > 0);
        this.pushRegButton.setEnabled(this.regTable.getSelectionCount() == 1 && !((RegEntry)this.regTable.getSelection()[0].getData()).isPushReg);
    }

    private List<RegEntry> getRegEntries(List<RegistryInfo> infos, ImagePushRegistryInfo pushReg) {
        ArrayList<RegEntry> entries = new ArrayList<RegEntry>(infos.size());
        for (RegistryInfo info : infos) {
            RegEntry entry = new RegEntry(info);
            if (pushReg != null && pushReg.getAddress().equals(info.getAddress())) {
                entry.isPushReg = true;
                entry.namespace = pushReg.getNamespace();
            }
            entries.add(entry);
        }
        return entries;
    }

    public IStatus updateRegistries(IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RegUpdateTask, (int)100);
        MultiStatus multiStatus = new MultiStatus("org.eclipse.codewind.core", 4, Messages.RegMgmtUpdateError, null);
        for (RegistryInfo info : this.regList) {
            RegEntry entry = this.getRegEntry(info.getAddress());
            if (entry == null) {
                try {
                    this.connection.requestRemoveRegistry(info.getAddress(), info.getUsername());
                }
                catch (Exception e) {
                    Logger.logError((String)("Failed to remove registry: " + info.getAddress()), (Throwable)e);
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.codewind.core", NLS.bind((String)Messages.RegMgmtRemoveFailed, (Object)info.getAddress()), (Throwable)e));
                }
            }
            if (mon.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            mon.worked(25);
            mon.setWorkRemaining(100);
        }
        for (RegEntry entry : this.regEntries) {
            RegistryInfo info = this.getRegInfo(entry.address);
            if (info == null) {
                try {
                    this.connection.requestAddRegistry(entry.address, entry.username, entry.password);
                }
                catch (Exception e) {
                    Logger.logError((String)("Failed to add registry: " + entry.address), (Throwable)e);
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.codewind.core", NLS.bind((String)Messages.RegMgmtAddFailed, (Object)entry.address), (Throwable)e));
                }
            }
            if (mon.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            mon.worked(25);
            mon.setWorkRemaining(100);
            if (entry.isPushReg) {
                try {
                    this.connection.requestSetPushRegistry(entry.address, entry.namespace == null ? "" : entry.namespace);
                }
                catch (Exception e) {
                    Logger.logError((String)("Failed to set the push registry: " + info.getAddress()), (Throwable)e);
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.codewind.core", NLS.bind((String)Messages.RegMgmtSetPushRegFailed, (Object)info.getAddress()), (Throwable)e));
                }
            }
            if (mon.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            mon.worked(25);
            mon.setWorkRemaining(100);
        }
        if (multiStatus.getChildren().length > 0) {
            return multiStatus;
        }
        return Status.OK_STATUS;
    }

    public boolean hasChanges() {
        for (RegistryInfo info : this.regList) {
            RegEntry entry = this.getRegEntry(info.getAddress());
            if (entry != null) continue;
            return true;
        }
        for (RegEntry entry : this.regEntries) {
            RegistryInfo info = this.getRegInfo(entry.address);
            if (info == null) {
                return true;
            }
            if (!entry.isPushReg || this.pushReg != null && this.pushReg.getAddress().equals(entry.address)) continue;
            return true;
        }
        return false;
    }

    private RegEntry getRegEntry(String address) {
        for (RegEntry entry : this.regEntries) {
            if (!address.equals(entry.address)) continue;
            return entry;
        }
        return null;
    }

    private RegistryInfo getRegInfo(String address) {
        for (RegistryInfo info : this.regList) {
            if (!address.equals(info.getAddress())) continue;
            return info;
        }
        return null;
    }

    private class NamespaceDialog
    extends TitleAreaDialog {
        private String namespace;

        public NamespaceDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.RegMgmtNamespaceDialogShell);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createButtonBar(Composite parent) {
            return super.createButtonBar(parent);
        }

        protected Control createDialogArea(Composite parent) {
            this.setTitleImage(CodewindUIPlugin.getImage("codewindBanner.png"));
            this.setTitle(Messages.RegMgmtNamespaceDialogTitle);
            this.setMessage(Messages.RegMgmtNamespaceDialogMessage);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 11;
            layout.marginWidth = 9;
            layout.horizontalSpacing = 5;
            layout.verticalSpacing = 7;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            data.minimumWidth = 300;
            composite.setLayoutData((Object)data);
            composite.setFont(parent.getFont());
            Label namespaceLabel = new Label(composite, 0);
            namespaceLabel.setText(Messages.RegMgmtAddDialogNamespaceLabel);
            data = new GridData(1, 2, false, false);
            data.horizontalIndent = 15;
            namespaceLabel.setLayoutData((Object)data);
            final Text namespaceText = new Text(composite, 2048);
            namespaceText.setLayoutData((Object)new GridData(4, 4, true, false));
            namespaceText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NamespaceDialog.this.namespace = namespaceText.getText().trim();
                    NamespaceDialog.this.enableOKButton(NamespaceDialog.this.validate());
                }
            });
            namespaceText.setFocus();
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.enableOKButton(true);
        }

        protected void enableOKButton(boolean value) {
            this.getButton(0).setEnabled(value);
        }

        private boolean validate() {
            this.setErrorMessage(null);
            return true;
        }

        public String getNamespace() {
            return this.namespace;
        }

        protected Point getInitialSize() {
            Point point = super.getInitialSize();
            return new Point(650, point.y);
        }
    }

    private class AddDialog
    extends TitleAreaDialog {
        private String address;
        private String namespace;
        private String username;
        private String password;
        private boolean isPushReg;

        public AddDialog(Shell parentShell) {
            super(parentShell);
            this.isPushReg = false;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.RegMgmtAddDialogShell);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createButtonBar(Composite parent) {
            return super.createButtonBar(parent);
        }

        protected Control createDialogArea(Composite parent) {
            this.setTitleImage(CodewindUIPlugin.getImage("codewindBanner.png"));
            this.setTitle(Messages.RegMgmtAddDialogTitle);
            this.setMessage(Messages.RegMgmtAddDialogMessage);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 11;
            layout.marginWidth = 9;
            layout.horizontalSpacing = 5;
            layout.verticalSpacing = 7;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            data.minimumWidth = 300;
            composite.setLayoutData((Object)data);
            composite.setFont(parent.getFont());
            Label label = new Label(composite, 0);
            label.setText(Messages.RegMgmtAddDialogAddressLabel);
            label.setLayoutData((Object)new GridData(1, 2, false, false));
            final Text addressText = new Text(composite, 2048);
            addressText.setLayoutData((Object)new GridData(4, 4, true, false));
            label = new Label(composite, 0);
            label.setText(Messages.RegMgmtAddDialogUsernameLabel);
            label.setLayoutData((Object)new GridData(1, 2, false, false));
            final Text usernameText = new Text(composite, 2048);
            usernameText.setLayoutData((Object)new GridData(4, 4, true, false));
            label = new Label(composite, 0);
            label.setText(Messages.RegMgmtAddDialogPasswordLabel);
            label.setLayoutData((Object)new GridData(1, 2, false, false));
            final Text passwordText = new Text(composite, 0x400800);
            passwordText.setLayoutData((Object)new GridData(4, 4, true, false));
            addressText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddDialog.this.address = addressText.getText().trim();
                    AddDialog.this.enableOKButton(AddDialog.this.validate());
                }
            });
            usernameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddDialog.this.username = usernameText.getText().trim();
                    AddDialog.this.enableOKButton(AddDialog.this.validate());
                }
            });
            passwordText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddDialog.this.password = passwordText.getText().trim();
                    AddDialog.this.enableOKButton(AddDialog.this.validate());
                }
            });
            if (RegistryManagementComposite.this.supportsPushReg) {
                Label spacer = new Label(composite, 0);
                spacer.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
                final Button pushButton = new Button(composite, 32);
                pushButton.setText(Messages.RegMgmtAddDialogPushRegLabel);
                pushButton.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
                final Label namespaceLabel = new Label(composite, 0);
                namespaceLabel.setText(Messages.RegMgmtAddDialogNamespaceLabel);
                data = new GridData(1, 2, false, false);
                data.horizontalIndent = 15;
                namespaceLabel.setLayoutData((Object)data);
                final Text namespaceText = new Text(composite, 2048);
                namespaceText.setLayoutData((Object)new GridData(4, 4, true, false));
                pushButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        namespaceLabel.setVisible(pushButton.getSelection());
                        namespaceText.setVisible(pushButton.getSelection());
                        AddDialog.this.isPushReg = pushButton.getSelection();
                        AddDialog.this.enableOKButton(AddDialog.this.validate());
                    }
                });
                namespaceText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        AddDialog.this.namespace = namespaceText.getText().trim();
                        AddDialog.this.enableOKButton(AddDialog.this.validate());
                    }
                });
                pushButton.setSelection(false);
                namespaceLabel.setVisible(false);
                namespaceText.setVisible(false);
            }
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.enableOKButton(false);
        }

        protected void enableOKButton(boolean value) {
            this.getButton(0).setEnabled(value);
        }

        private boolean validate() {
            if (this.address == null || this.address.isEmpty()) {
                this.setErrorMessage(Messages.RegMgmtAddDialogNoAddress);
                return false;
            }
            if (RegistryManagementComposite.this.getRegEntry(this.address) != null) {
                this.setErrorMessage(Messages.RegMgmtAddDialogAddressInUse);
                return false;
            }
            if (this.username == null || this.username.isEmpty()) {
                this.setErrorMessage(Messages.RegMgmtAddDialogNoUsername);
                return false;
            }
            if (this.password == null || this.password.isEmpty()) {
                this.setErrorMessage(Messages.RegMgmtAddDialogNoPassword);
                return false;
            }
            this.setErrorMessage(null);
            return true;
        }

        public RegEntry getNewRegEntry() {
            if (!(this.address == null || this.address.isEmpty() || this.username == null || this.username.isEmpty() || this.password == null || this.password.isEmpty())) {
                return new RegEntry(this.address, this.namespace, this.username, this.password, this.isPushReg);
            }
            return null;
        }
    }

    private static class RegEntry {
        public final String address;
        public String namespace;
        public final String username;
        public final String password;
        public boolean isPushReg = false;

        public RegEntry(String address, String namespace, String username, String password, boolean isPush) {
            this.address = address;
            this.namespace = namespace;
            this.username = username;
            this.password = password;
            this.isPushReg = isPush;
        }

        public RegEntry(RegistryInfo info) {
            this.address = info.getAddress();
            this.username = info.getUsername();
            this.password = null;
        }
    }
}

