/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.connection;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindObjectFactory;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CodewindConnectionManager {
    private static CodewindConnectionManager instance;
    public static final String CONNECTION_LIST_PREFSKEY = "codewindConnections";
    public static final String NAME_KEY = "name";
    public static final String URI_KEY = "uri";
    private List<CodewindConnection> connections = new ArrayList<CodewindConnection>();

    private CodewindConnectionManager() {
        instance = this;
        this.loadFromPreferences();
    }

    private static CodewindConnectionManager instance() {
        if (instance == null) {
            instance = new CodewindConnectionManager();
        }
        return instance;
    }

    public static synchronized void add(CodewindConnection connection) {
        if (connection == null) {
            Logger.logError("Null connection passed to be added");
            return;
        }
        CodewindConnectionManager.instance().connections.add(connection);
        Logger.log("Added a new connection: " + connection.getBaseURI());
        CodewindConnectionManager.instance().writeToPreferences();
    }

    public static synchronized List<CodewindConnection> activeConnections() {
        return Collections.unmodifiableList(CodewindConnectionManager.instance().connections);
    }

    public static synchronized CodewindConnection getActiveConnection(String baseUrl) {
        for (CodewindConnection conn : CodewindConnectionManager.activeConnections()) {
            if (conn.getBaseURI() == null || !conn.getBaseURI().toString().equals(baseUrl)) continue;
            return conn;
        }
        return null;
    }

    public static synchronized CodewindConnection getActiveConnectionByName(String name) {
        for (CodewindConnection conn : CodewindConnectionManager.activeConnections()) {
            if (name == null || !name.equals(conn.getName())) continue;
            return conn;
        }
        return null;
    }

    public static synchronized int activeConnectionsCount() {
        return CodewindConnectionManager.instance().connections.size();
    }

    static synchronized boolean remove(String baseUrl) {
        boolean removeResult = false;
        CodewindConnection connection = CodewindConnectionManager.getActiveConnection(baseUrl.toString());
        if (connection != null) {
            List<CodewindApplication> apps = connection.getApps();
            connection.close();
            removeResult = CodewindConnectionManager.instance().connections.remove(connection);
            CoreUtil.removeConnection(apps);
        }
        if (!removeResult) {
            Logger.logError("Tried to remove connection " + baseUrl + ", but it didn't exist");
        }
        CodewindConnectionManager.instance().writeToPreferences();
        CoreUtil.updateAll();
        return removeResult;
    }

    public static synchronized void clear() {
        Logger.log("Clearing " + CodewindConnectionManager.instance().connections.size() + " connections");
        Iterator<CodewindConnection> it = CodewindConnectionManager.instance().connections.iterator();
        while (it.hasNext()) {
            CodewindConnection connection = it.next();
            connection.close();
            it.remove();
        }
    }

    private void writeToPreferences() {
        JSONArray jsonArray = new JSONArray();
        for (CodewindConnection conn : CodewindConnectionManager.activeConnections()) {
            if (conn.isLocal()) continue;
            try {
                JSONObject obj = new JSONObject();
                obj.put(NAME_KEY, (Object)conn.getName());
                obj.put(URI_KEY, (Object)conn.getBaseURI());
                jsonArray.put((Object)obj);
            }
            catch (JSONException e) {
                Logger.logError("An error occurred trying to add connection to the preferences: " + conn.getBaseURI(), e);
            }
        }
        Logger.log("Writing connections to preferences: " + jsonArray.toString());
        CodewindCorePlugin.getDefault().getPreferenceStore().setValue(CONNECTION_LIST_PREFSKEY, jsonArray.toString());
    }

    private void loadFromPreferences() {
        CodewindConnectionManager.clear();
        String storedConnections = CodewindCorePlugin.getDefault().getPreferenceStore().getString(CONNECTION_LIST_PREFSKEY).trim();
        if (storedConnections == null || storedConnections.isEmpty()) {
            Logger.log("The preferences do not contain any connections");
            return;
        }
        Logger.log("Reading connections from preferences: \"" + storedConnections + "\"");
        try {
            JSONArray array = new JSONArray(storedConnections);
            for (int i = 0; i < array.length(); ++i) {
                try {
                    JSONObject obj = array.getJSONObject(i);
                    String name = obj.getString(NAME_KEY);
                    String uriStr = obj.getString(URI_KEY);
                    URI uri = new URI(uriStr);
                    CodewindConnection connection = CodewindObjectFactory.createCodewindConnection(name, uri, false);
                    connection.connect((IProgressMonitor)new NullProgressMonitor());
                    CodewindConnectionManager.add(connection);
                    continue;
                }
                catch (CodewindConnectionException e) {
                    Logger.logError("Fatal error trying to create connection for url: " + e.connectionUrl, e);
                }
            }
        }
        catch (Exception e) {
            Logger.logError("Error loading connection from preferences", e);
        }
    }

    public static boolean removeConnection(String connectionUrl) {
        CodewindConnectionManager.remove(connectionUrl);
        return true;
    }
}

