/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.eventmanager;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.ebam.emf.interfaces.IAlarmTransactions;
import org.eclipse.ebam.emf.interfaces.ICEPTransaction;
import org.eclipse.ebam.event.IEbamEvent;
import org.eclipse.ebam.eventmanager.DBStorage;
import org.eclipse.ebam.eventmanager.alarm.AlarmEvent;
import org.eclipse.ebam.eventmanager.interfaces.IEbamEventManager;
import org.eclipse.ebam.eventmanager.manager.ConfigurationManagerReader;
import org.eclipse.ebam.eventmanager.manager.SendAlarmThread;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EbamEventManager
implements IEbamEventManager {
    private static Logger logger = LoggerFactory.getLogger(EbamEventManager.class);
    private ConfigurationManagerReader configurationReader;
    private AtomicReference<IAlarmTransactions> alarmReference = new AtomicReference();
    private AtomicReference<ICEPTransaction> cepReference = new AtomicReference();
    private IAlarmTransactions alarmTransaction;
    private ICEPTransaction cepTransaction;

    protected void activate(ComponentContext componentContext) {
        try {
            logger.info("+++++++++++Activating component+++++++++");
            logger.info("+++++++++Initializing the event manager +++++++++++++");
            this.alarmTransaction = this.alarmReference.get();
            this.cepTransaction = this.cepReference.get();
            this.configurationReader = ConfigurationManagerReader.getInstance(componentContext.getBundleContext());
            this.init();
        }
        catch (Exception e) {
            logger.error("activate" + e.getMessage(), (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
    }

    public void init() {
        logger.info("+++++++++INIT : Initializing the event mamager +++++++++++++");
        Thread th = new Thread(new SendAlarmThread(this.alarmTransaction));
        th.start();
    }

    public void processEvent(IEbamEvent event) {
        Object ev;
        if (event.getSbiAlarm() != null) {
            ev = new AlarmEvent();
            ev.init(this.alarmTransaction);
            ev.createNewAlarm(event);
        }
        if (event.isPersist()) {
            ev = new DBStorage();
            ev.init(this.cepTransaction);
            ev.storeOnDB(event);
        }
    }

    public void setAlarmTransactions(IAlarmTransactions a) {
        this.alarmReference.set(a);
    }

    public void unsetAlarmTransactions(IAlarmTransactions a) {
        this.alarmReference.compareAndSet(a, null);
    }

    public void setCEPTransaction(ICEPTransaction c) {
        this.cepReference.set(c);
    }

    public void unsetCEPTransaction(ICEPTransaction c) {
        this.cepReference.compareAndSet(c, null);
    }
}

