/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.dirwatcher;

import java.io.File;
import java.io.FileFilter;
import java.util.TimerTask;
import org.eclipse.ebpm.dirwatcher.DirFilterWatcher;
import org.eclipse.ebpm.dirwatcher.IDirectoryPoller;

public abstract class AbstractDirectoryPoller
extends TimerTask
implements IDirectoryPoller {
    protected DirFilterWatcher dfw;
    protected File directory = null;

    public AbstractDirectoryPoller(String location) {
        this(location, "");
    }

    public AbstractDirectoryPoller(String location, String filter) {
        this(new File(location), new String[]{filter});
    }

    public AbstractDirectoryPoller(String location, String[] filters) {
        this(new File(location), filters);
    }

    public AbstractDirectoryPoller(File directoryFile, String[] filters) {
        this.directory = directoryFile;
        this.dfw = new DirFilterWatcher(filters);
        this.createDirectoryIfNotExist(directoryFile);
    }

    protected void createDirectoryIfNotExist(File directoryFile) {
        if (!directoryFile.exists()) {
            directoryFile.mkdirs();
        }
    }

    protected File[] snapshot(File directoryFile, FileFilter fileFilter) {
        return directoryFile.listFiles(fileFilter);
    }
}

