/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.sharedobject;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.ecf.core.events.IContainerConnectedEvent;
import org.eclipse.ecf.core.events.IContainerDisconnectedEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.sharedobject.BaseSharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerTransaction;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContext;
import org.eclipse.ecf.core.sharedobject.ISharedObjectTransactionConfig;
import org.eclipse.ecf.core.sharedobject.ISharedObjectTransactionParticipantsFilter;
import org.eclipse.ecf.core.sharedobject.SharedObjectAddAbortException;
import org.eclipse.ecf.core.sharedobject.TransactionSharedObjectConfiguration;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectActivatedEvent;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectCommitEvent;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectCreateResponseEvent;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectMessageEvent;
import org.eclipse.ecf.core.sharedobject.events.SharedObjectCommitEvent;
import org.eclipse.ecf.core.util.Event;
import org.eclipse.ecf.core.util.IEventProcessor;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.core.sharedobject.Messages;
import org.eclipse.osgi.util.NLS;

public class TwoPhaseCommitEventProcessor
implements IEventProcessor,
ISharedObjectContainerTransaction {
    BaseSharedObject sharedObject = null;
    byte transactionState = 0;
    Object lock = new Object();
    List participants = new Vector();
    Map failed = new HashMap();
    int timeout = 30000;
    int minFailedToAbort = 0;
    long identifier = 0L;
    ISharedObjectTransactionParticipantsFilter participantsFilter = null;
    static /* synthetic */ Class class$0;

    public TwoPhaseCommitEventProcessor(BaseSharedObject bse, ISharedObjectTransactionConfig config) {
        this.sharedObject = bse;
        if (config == null) {
            config = new TransactionSharedObjectConfiguration();
        }
        this.timeout = config.getTimeout();
        this.participantsFilter = config.getParticipantsFilter();
    }

    protected void trace(String msg) {
        Trace.trace((String)"org.eclipse.ecf.sharedobject", (String)msg);
    }

    protected void traceStack(String msg, Throwable t) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.sharedobject.TwoPhaseCommitEventProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.catching((String)"org.eclipse.ecf.sharedobject", (String)"org.eclipse.ecf.sharedobject/debug/exceptions/catching", (Class)clazz, (String)"traceStack", (Throwable)t);
    }

    protected int getTimeout() {
        return this.timeout;
    }

    protected int getMinFailedToAbort() {
        return this.minFailedToAbort;
    }

    protected boolean isPrimary() {
        return this.getSharedObject().isPrimary();
    }

    protected BaseSharedObject getSharedObject() {
        return this.sharedObject;
    }

    protected ID getHomeID() {
        return this.getSharedObject().getHomeContainerID();
    }

    protected void addParticipants(ID[] ids) {
        if (ids != null) {
            int i = 0;
            while (i < ids.length) {
                this.trace("addParticipant(" + ids[i] + ")");
                if (!this.getHomeID().equals((Object)ids[i])) {
                    this.participants.add(ids[i]);
                }
                ++i;
            }
        }
    }

    protected void removeParticipant(ID id) {
        if (id != null) {
            this.trace("removeParticipant(" + id + ")");
            this.participants.remove(id);
        }
    }

    protected void addFailed(ID remote, Throwable failure) {
        if (remote != null && failure != null) {
            this.trace("addFailed(" + remote + "," + failure + ")");
            this.failed.put(remote, failure);
        }
    }

    protected ISharedObjectContext getContext() {
        return this.getSharedObject().getContext();
    }

    public boolean processEvent(Event event) {
        ISharedObjectMessageEvent some;
        Object data;
        if (event instanceof ISharedObjectActivatedEvent) {
            this.handleActivated((ISharedObjectActivatedEvent)event);
        } else if (event instanceof IContainerConnectedEvent) {
            this.handleJoined((IContainerConnectedEvent)event);
        } else if (event instanceof ISharedObjectCreateResponseEvent) {
            this.handleCreateResponse((ISharedObjectCreateResponseEvent)event);
        } else if (event instanceof IContainerDisconnectedEvent) {
            this.handleDeparted((IContainerDisconnectedEvent)event);
        } else if (event instanceof ISharedObjectMessageEvent && (data = (some = (ISharedObjectMessageEvent)event).getData()) instanceof ISharedObjectCommitEvent) {
            this.localCommitted();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleActivated(ISharedObjectActivatedEvent event) {
        this.trace("handleActivated(" + event + ")");
        Object object = this.lock;
        synchronized (object) {
            if (this.isPrimary()) {
                this.handlePrimaryActivated(event);
            } else {
                this.handleReplicaActivated(event);
            }
            this.lock.notifyAll();
        }
    }

    protected void replicateTo(ID[] remotes) {
        this.getSharedObject().replicateToRemoteContainers(remotes);
    }

    protected void handlePrimaryActivated(ISharedObjectActivatedEvent event) {
        this.trace("handlePrimaryActivated(" + event + ")");
        if (this.getContext().getConnectedID() != null) {
            ID[] groupMembers = this.getContext().getGroupMemberIDs();
            ID[] transactionParticipants = null;
            if (this.participantsFilter != null) {
                transactionParticipants = this.participantsFilter.filterParticipants(groupMembers);
            }
            if (transactionParticipants == null) {
                this.replicateTo(null);
                transactionParticipants = groupMembers;
            } else {
                this.replicateTo(transactionParticipants);
            }
            this.addParticipants(transactionParticipants);
            this.setTransactionState((byte)1);
        } else {
            this.setTransactionState((byte)3);
        }
    }

    private long getNextIdentifier() {
        return this.identifier++;
    }

    protected void handleReplicaActivated(ISharedObjectActivatedEvent event) {
        this.trace("handleReplicaActivated(" + event + ")");
        try {
            this.getContext().sendCreateResponse(this.getHomeID(), null, this.getNextIdentifier());
            this.setTransactionState((byte)2);
        }
        catch (Exception except) {
            this.traceStack("handleReplicaActivated(" + event + ")", except);
            this.setTransactionState((byte)4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleJoined(IContainerConnectedEvent event) {
        this.trace("handleJoined(" + event + ")");
        if (this.isPrimary() && this.getTransactionState() == 1) {
            Object object = this.lock;
            synchronized (object) {
                ID[] newMember = new ID[]{event.getTargetID()};
                this.replicateTo(newMember);
                this.addParticipants(newMember);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreateResponse(ISharedObjectCreateResponseEvent event) {
        this.trace("handleCreateResponse(" + event + ")");
        if (this.isPrimary()) {
            Object object = this.lock;
            synchronized (object) {
                Throwable except = event.getException();
                ID remoteID = event.getRemoteContainerID();
                long ident = event.getSequence();
                if (this.getTransactionState() == 1) {
                    if (except == null) {
                        this.removeParticipant(remoteID);
                    } else {
                        this.addFailed(remoteID, except);
                    }
                } else {
                    this.handleVotingCompletedCreateResponse(remoteID, except, ident);
                }
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDeparted(IContainerDisconnectedEvent event) {
        this.trace("handleDeparted(" + event + ")");
        if (this.isPrimary()) {
            ID remoteID = event.getTargetID();
            Object object = this.lock;
            synchronized (object) {
                if (this.getTransactionState() == 1) {
                    this.addFailed(remoteID, new Exception("Container " + remoteID + " left"));
                }
                this.lock.notifyAll();
            }
        }
    }

    protected void handleVotingCompletedCreateResponse(ID fromID, Throwable e, long identifier1) {
        this.trace("handleVotingCompletedCreateResponse(" + fromID + "," + e + "," + identifier1 + ")");
        if (e == null) {
            try {
                this.getSharedObject().getContext().sendMessage(fromID, new SharedObjectCommitEvent(this.getSharedObject().getID()));
            }
            catch (Exception e2) {
                this.traceStack("Exception in sendCommit to " + fromID, e2);
            }
        } else {
            this.handlePostCommitFailure(fromID, e, identifier1);
        }
    }

    protected void handlePostCommitFailure(ID fromID, Throwable e, long identifier1) {
        this.trace("handlePostCommitFailure(" + fromID + "," + e + "," + identifier1 + ")");
    }

    protected void sendCommit() throws SharedObjectAddAbortException {
        try {
            this.getContext().sendMessage(null, new SharedObjectCommitEvent(this.getSharedObject().getID()));
        }
        catch (Exception e2) {
            this.doTMAbort((Throwable)((Object)new SharedObjectAddAbortException(Messages.TwoPhaseCommitEventProcessor_Exception_Shared_Object_Add_Abort, e2, this.getTimeout())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getTransactionState() {
        Object object = this.lock;
        synchronized (object) {
            return this.transactionState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTransactionState(byte state) {
        Object object = this.lock;
        synchronized (object) {
            this.transactionState = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToCommit() throws SharedObjectAddAbortException {
        if (this.getTransactionState() == 3) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            long end = System.currentTimeMillis() + (long)this.getTimeout();
            try {
                while (!this.isVotingCompleted()) {
                    long wait = end - System.currentTimeMillis();
                    this.trace("waitForFinish waiting " + wait + "ms on " + this.getSharedObject().getID());
                    if (wait <= 0L) {
                        throw new SharedObjectAddAbortException(NLS.bind((String)Messages.TwoPhaseCommitEventProcessor_Exception_Commit_Timeout, (Object[])new Object[]{this.getSharedObject().getID(), this.getHomeID()}), null, this.getTimeout());
                    }
                    this.lock.wait(wait);
                }
            }
            catch (Exception except) {
                this.doTMAbort(except);
            }
            this.doTMCommit();
        }
    }

    protected void doTMAbort(Throwable except) throws SharedObjectAddAbortException {
        this.trace("doTMAbort:" + except);
        this.setTransactionState((byte)4);
        this.getSharedObject().destroySelf();
        if (except instanceof SharedObjectAddAbortException) {
            throw (SharedObjectAddAbortException)((Object)except);
        }
        throw new SharedObjectAddAbortException(Messages.TwoPhaseCommitEventProcessor_Exception_Shared_Object_Add_Abort, except, this.getTimeout());
    }

    protected void doTMCommit() throws SharedObjectAddAbortException {
        this.trace("doTMCommit");
        if (this.getSharedObject().getConnectedID() != null) {
            this.sendCommit();
        }
        this.localCommitted();
    }

    protected void localCommitted() {
        this.trace("localCommitted()");
        this.setTransactionState((byte)3);
        this.getSharedObject().creationCompleted();
    }

    protected boolean isVotingCompleted() throws SharedObjectAddAbortException {
        if (this.getTransactionState() == 3) {
            return true;
        }
        if (this.failed.size() > this.getMinFailedToAbort()) {
            this.trace("isVotingCompleted:aborting:failed>" + this.getMinFailedToAbort() + ":failed=" + this.failed);
            throw new SharedObjectAddAbortException(Messages.TwoPhaseCommitEventProcessor_Exception_Shared_Object_Add_Abort, this.participants, this.failed, this.getTimeout());
        }
        if (this.getTransactionState() == 1 && this.participants.size() == 0) {
            this.trace("isVotingCompleted() returning true");
            return true;
        }
        this.trace("isVotingCompleted:false");
        return false;
    }
}

