/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart;

import eglx.lang.AnyException;
import eglx.lang.DynamicAccessException;
import eglx.lang.EAny;
import eglx.lang.InvocationException;
import eglx.lang.TypeCastException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Delegate {
    private Object target;
    private Method method;
    private String signature;

    public static boolean ezeIsa(Object obj, String sig) {
        if (obj instanceof EAny) {
            obj = ((EAny)obj).ezeUnbox();
        }
        return obj instanceof Delegate && ((Delegate)obj).signature.equals(sig);
    }

    public static Delegate ezeCast(Object obj, String sig) throws TypeCastException {
        if (obj instanceof EAny) {
            obj = ((EAny)obj).ezeUnbox();
        }
        if (Delegate.ezeIsa(obj, sig)) {
            return (Delegate)obj;
        }
        TypeCastException tcx = new TypeCastException();
        tcx.castToName = sig;
        tcx.actualTypeName = obj == null ? "null" : obj.getClass().getName();
        throw tcx.fillInMessage("EGL0007E", obj, tcx.actualTypeName, tcx.castToName);
    }

    public Delegate(String methodName, String signature, Object target, Class ... argTypes) {
        this.target = target;
        this.signature = signature;
        try {
            this.method = target.getClass().getDeclaredMethod(methodName, argTypes);
        }
        catch (Exception ex) {
            DynamicAccessException dax = new DynamicAccessException();
            dax.key = methodName;
            dax.initCause(ex);
            throw dax.fillInMessage("EGL0014E", methodName, ex);
        }
    }

    public Object invoke(Object ... args) throws AnyException {
        boolean accessibleSet = true;
        try {
            accessibleSet = this.method.isAccessible();
            if (!accessibleSet) {
                this.method.setAccessible(true);
                Object ret = this.method.invoke(this.target, args);
                this.method.setAccessible(false);
                return ret;
            }
            return this.method.invoke(this.target, args);
        }
        catch (Throwable problem) {
            if (!accessibleSet) {
                this.method.setAccessible(false);
            }
            if (problem instanceof InvocationTargetException && (problem = ((InvocationTargetException)problem).getTargetException()) instanceof AnyException) {
                throw (AnyException)problem;
            }
            InvocationException ix = new InvocationException();
            ix.name = this.method.getName();
            ix.initCause(problem);
            throw ix.fillInMessage("EGL0013E", ix.name, problem);
        }
    }

    public Object getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getSignature() {
        return this.signature;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(100);
        buf.append(this.target.getClass().getCanonicalName());
        buf.append('.');
        buf.append(this.method.getName());
        return buf.toString();
    }
}

