/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.registry.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public class DefaultRegistryHttpContext
implements HttpContext {
    private HttpContext delegate;
    private List resourceMappings;
    private Properties mimeMappings;

    public DefaultRegistryHttpContext(HttpContext delegate) {
        this.delegate = delegate;
    }

    public void addResourceMapping(Bundle contributingBundle, String path) {
        if (this.resourceMappings == null) {
            this.resourceMappings = new ArrayList();
        }
        this.resourceMappings.add(new ResourceMapping(contributingBundle, path));
    }

    public void addMimeMapping(String mimeExtension, String mimeType) {
        if (this.mimeMappings == null) {
            this.mimeMappings = new Properties();
        }
        ((Hashtable)this.mimeMappings).put(mimeExtension, mimeType);
    }

    public String getMimeType(String name) {
        String mimeExtension;
        String mimeType;
        int dotIndex;
        if (this.mimeMappings != null && (dotIndex = name.lastIndexOf(46)) != -1 && (mimeType = this.mimeMappings.getProperty(mimeExtension = name.substring(dotIndex + 1))) != null) {
            return mimeType;
        }
        return this.delegate.getMimeType(name);
    }

    public boolean handleSecurity(HttpServletRequest arg0, HttpServletResponse arg1) throws IOException {
        return this.delegate.handleSecurity(arg0, arg1);
    }

    public URL getResource(String name) {
        if (this.resourceMappings == null) {
            return null;
        }
        Iterator it = this.resourceMappings.iterator();
        while (it.hasNext()) {
            ResourceMapping mapping = (ResourceMapping)it.next();
            URL resourceURL = mapping.getResource(name);
            if (resourceURL == null) continue;
            return resourceURL;
        }
        return null;
    }

    public Set getResourcePaths(String path) {
        if (this.resourceMappings == null || path == null || !path.startsWith("/")) {
            return null;
        }
        HashSet result = null;
        Iterator it = this.resourceMappings.iterator();
        while (it.hasNext()) {
            ResourceMapping mapping = (ResourceMapping)it.next();
            Set resourcePaths = mapping.getResourcePaths(path);
            if (resourcePaths == null) continue;
            if (result == null) {
                result = new HashSet();
            }
            result.addAll(resourcePaths);
        }
        return result;
    }

    public static class ResourceMapping {
        private Bundle bundle;
        private String bundlePath;

        public ResourceMapping(Bundle bundle, String path) {
            this.bundle = bundle;
            if (path != null) {
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.length() == 0) {
                    path = null;
                }
            }
            this.bundlePath = path;
        }

        public URL getResource(String resourceName) {
            String file;
            Enumeration entryPaths;
            int lastSlash;
            if (this.bundlePath != null) {
                resourceName = String.valueOf(this.bundlePath) + resourceName;
            }
            if ((lastSlash = resourceName.lastIndexOf(47)) == -1) {
                return null;
            }
            String path = resourceName.substring(0, lastSlash);
            if (path.length() == 0) {
                path = "/";
            }
            if ((entryPaths = this.bundle.findEntries(path, file = this.sanitizeEntryName(resourceName.substring(lastSlash + 1)), false)) != null && entryPaths.hasMoreElements()) {
                return (URL)entryPaths.nextElement();
            }
            return null;
        }

        private String sanitizeEntryName(String name) {
            StringBuffer buffer = null;
            int i = 0;
            while (i < name.length()) {
                char c = name.charAt(i);
                switch (c) {
                    case '*': 
                    case '\\': {
                        if (buffer == null) {
                            buffer = new StringBuffer(name.length() + 16);
                            buffer.append(name.substring(0, i));
                        }
                        buffer.append('\\').append(c);
                        break;
                    }
                    default: {
                        if (buffer == null) break;
                        buffer.append(c);
                    }
                }
                ++i;
            }
            return buffer == null ? name : buffer.toString();
        }

        public Set getResourcePaths(String path) {
            Enumeration entryPaths;
            if (this.bundlePath != null) {
                path = String.valueOf(this.bundlePath) + path;
            }
            if ((entryPaths = this.bundle.findEntries(path, null, false)) == null) {
                return null;
            }
            HashSet<String> result = new HashSet<String>();
            while (entryPaths.hasMoreElements()) {
                URL entryURL = (URL)entryPaths.nextElement();
                String entryPath = entryURL.getFile();
                if (this.bundlePath == null) {
                    result.add(entryPath);
                    continue;
                }
                result.add(entryPath.substring(this.bundlePath.length()));
            }
            return result;
        }
    }
}

