/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.databinding.internal;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.map.IMapProperty;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.property.value.ValueProperty;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.databinding.IEMFMapProperty;
import org.eclipse.emf.databinding.IEMFSetProperty;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.databinding.internal.EMFListPropertyDecorator;
import org.eclipse.emf.databinding.internal.EMFMapPropertyDecorator;
import org.eclipse.emf.databinding.internal.EMFObservableListDecorator;
import org.eclipse.emf.databinding.internal.EMFObservableMapDecorator;
import org.eclipse.emf.databinding.internal.EMFObservableValueDecorator;
import org.eclipse.emf.databinding.internal.EMFSetPropertyDecorator;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EMFValuePropertyDecorator
extends ValueProperty
implements IEMFValueProperty {
    private final IValueProperty delegate;
    private final EStructuralFeature eStructuralFeature;

    public EMFValuePropertyDecorator(IValueProperty delegate, EStructuralFeature eStructuralFeature) {
        this.delegate = delegate;
        this.eStructuralFeature = eStructuralFeature;
    }

    public EStructuralFeature getStructuralFeature() {
        return this.eStructuralFeature;
    }

    public Object getValueType() {
        return this.delegate.getValueType();
    }

    public IEMFValueProperty value(EStructuralFeature feature) {
        return this.value(FeaturePath.fromList(feature));
    }

    public IEMFValueProperty value(FeaturePath featurePath) {
        return this.value(EMFProperties.value(featurePath));
    }

    public IEMFValueProperty value(IEMFValueProperty property) {
        return new EMFValuePropertyDecorator(super.value((IValueProperty)property), property.getStructuralFeature());
    }

    public IEMFListProperty list(EStructuralFeature feature) {
        return this.list(EMFProperties.list(feature));
    }

    public IEMFListProperty list(IEMFListProperty property) {
        return new EMFListPropertyDecorator(super.list((IListProperty)property), property.getStructuralFeature());
    }

    public IEMFSetProperty set(EStructuralFeature feature) {
        return this.set(EMFProperties.set(feature));
    }

    public IEMFSetProperty set(IEMFSetProperty property) {
        return new EMFSetPropertyDecorator(super.set((ISetProperty)property), property.getStructuralFeature());
    }

    public IEMFMapProperty map(EStructuralFeature feature) {
        return this.map(EMFProperties.map(feature));
    }

    public IEMFMapProperty map(IEMFMapProperty property) {
        return new EMFMapPropertyDecorator(super.map((IMapProperty)property), property.getStructuralFeature());
    }

    public IObservableValue observe(Object source) {
        return new EMFObservableValueDecorator(this.delegate.observe(source), this.eStructuralFeature);
    }

    public IObservableValue observe(Realm realm, Object source) {
        return new EMFObservableValueDecorator(this.delegate.observe(realm, source), this.eStructuralFeature);
    }

    public IObservableFactory valueFactory() {
        return this.delegate.valueFactory();
    }

    public IObservableFactory valueFactory(Realm realm) {
        return this.delegate.valueFactory(realm);
    }

    public IObservableValue observeDetail(IObservableValue master) {
        return new EMFObservableValueDecorator(this.delegate.observeDetail(master), this.eStructuralFeature);
    }

    public IObservableList observeDetail(IObservableList master) {
        return new EMFObservableListDecorator(this.delegate.observeDetail(master), this.eStructuralFeature);
    }

    public IObservableMap observeDetail(IObservableSet master) {
        return new EMFObservableMapDecorator(this.delegate.observeDetail(master), this.eStructuralFeature);
    }

    public IObservableMap observeDetail(IObservableMap master) {
        return new EMFObservableMapDecorator(this.delegate.observeDetail(master), this.eStructuralFeature);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

