/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.keybindings.generic;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.fx.ui.keybindings.KeyLookup;
import org.eclipse.fx.ui.keybindings.KeySequence;
import org.eclipse.fx.ui.keybindings.KeyStroke;
import org.eclipse.fx.ui.keybindings.ParseException;
import org.eclipse.fx.ui.keybindings.Trigger;
import org.eclipse.fx.ui.keybindings.TriggerSequence;
import org.eclipse.fx.ui.keybindings.generic.KeyStrokeImpl;
import org.eclipse.fx.ui.keybindings.generic.TriggerSequenceImpl;
import org.eclipse.fx.ui.keybindings.generic.Util;
import org.eclipse.jdt.annotation.NonNull;

public class KeySequenceImpl
extends TriggerSequenceImpl
implements KeySequence {
    private static final @NonNull KeySequenceImpl EMPTY_KEY_SEQUENCE = new KeySequenceImpl(new KeyStroke[0]);
    private static final String KEY_STROKE_DELIMITER = " ";
    private static final String KEY_STROKE_DELIMITERS = " \b\r\u007f\u001b\f\n\u0000\t\u000b";

    public int compareTo(KeySequence o) {
        return Util.compare(this.getTriggers(), o.getTriggers());
    }

    KeySequenceImpl(KeyStroke[] triggers) {
        super((Trigger[])triggers);
    }

    public final @NonNull TriggerSequence[] getPrefixes() {
        int numberOfPrefixes = this.getTriggers().length;
        TriggerSequence[] prefixes = new TriggerSequence[numberOfPrefixes];
        prefixes[0] = KeySequenceImpl.getInstance();
        int i = 0;
        while (i < numberOfPrefixes - 1) {
            KeyStroke[] prefixKeyStrokes = new KeyStroke[i + 1];
            System.arraycopy(this.getTriggers(), 0, prefixKeyStrokes, 0, i + 1);
            prefixes[i + 1] = KeySequenceImpl.getInstance(prefixKeyStrokes);
            ++i;
        }
        return prefixes;
    }

    public String format() {
        return null;
    }

    static final @NonNull KeySequence getInstance() {
        return EMPTY_KEY_SEQUENCE;
    }

    static final @NonNull KeySequence getInstance(@NonNull KeyStroke[] keyStrokes) {
        return new KeySequenceImpl(keyStrokes);
    }

    static final @NonNull KeySequence getInstance(@NonNull KeySequence keySequence, @NonNull KeyStroke keyStroke) {
        KeyStroke[] oldKeyStrokes = keySequence.getKeyStrokes();
        int oldKeyStrokeLength = oldKeyStrokes.length;
        KeyStroke[] newKeyStrokes = new KeyStroke[oldKeyStrokeLength + 1];
        System.arraycopy(oldKeyStrokes, 0, newKeyStrokes, 0, oldKeyStrokeLength);
        newKeyStrokes[oldKeyStrokeLength] = keyStroke;
        return new KeySequenceImpl(newKeyStrokes);
    }

    static final @NonNull KeySequence getInstance(@NonNull KeyLookup lookup, @NonNull String string) throws ParseException {
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, KEY_STROKE_DELIMITERS);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                keyStrokes.add(KeyStrokeImpl.getInstance(lookup, stringTokenizer.nextToken()));
            }
            KeyStroke[] keyStrokeArray = keyStrokes.toArray(new KeyStroke[keyStrokes.size()]);
            return new KeySequenceImpl(keyStrokeArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException("Could not construct key sequence with these key strokes: " + keyStrokes);
        }
        catch (NullPointerException nullPointerException) {
            throw new ParseException("Could not construct key sequence with these key strokes: " + keyStrokes);
        }
    }

    public final @NonNull KeyStroke[] getKeyStrokes() {
        int triggerLength = this.getTriggers().length;
        KeyStroke[] keyStrokes = new KeyStroke[triggerLength];
        System.arraycopy(this.getTriggers(), 0, keyStrokes, 0, triggerLength);
        return keyStrokes;
    }
}

