/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.model;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.EqualsHashCode;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.util.GenModelUtil2;

@Accessors
@EqualsHashCode
public class TypeReference {
    private final String packageName;
    private final List<String> simpleNames;
    private final List<TypeReference> typeArguments;

    public static TypeReference typeRef(String name, TypeReference ... arguments) {
        return new TypeReference(name, (List<TypeReference>)((List)Conversions.doWrapArray((Object)arguments)));
    }

    @Deprecated
    public static TypeReference guessTypeRef(String name, TypeReference ... arguments) {
        return new TypeReference(name, (List)Conversions.doWrapArray((Object)arguments), false);
    }

    public static TypeReference typeRef(Class<?> clazz, TypeReference ... arguments) {
        return new TypeReference(clazz, (List<TypeReference>)((List)Conversions.doWrapArray((Object)arguments)));
    }

    public static TypeReference typeRef(EClass clazz, IXtextGeneratorLanguage language) {
        ResourceSet _resourceSet = language.getResourceSet();
        return new TypeReference(clazz, _resourceSet);
    }

    public TypeReference(String qualifiedName) {
        this(qualifiedName, (List<TypeReference>)null);
    }

    public TypeReference(String qualifiedName, List<TypeReference> arguments) {
        this(qualifiedName, arguments, true);
    }

    private TypeReference(String qualifiedName, List<TypeReference> arguments, boolean strict) {
        this(TypeReference.getPackageName(qualifiedName, strict), TypeReference.getClassName(qualifiedName, strict), arguments);
    }

    public TypeReference(String packageName, String className) {
        this(packageName, className, null);
    }

    public TypeReference(String packageName, String className, List<TypeReference> arguments) {
        if (packageName == null) {
            throw new IllegalArgumentException("Invalid package name: " + packageName);
        }
        if (className == null) {
            throw new IllegalArgumentException("Invalid class name: " + className);
        }
        this.packageName = packageName;
        this.simpleNames = (List)Conversions.doWrapArray((Object)className.split("\\."));
        List<TypeReference> _elvis = null;
        if (arguments != null) {
            _elvis = arguments;
        } else {
            List _emptyList = Collections.emptyList();
            _elvis = _emptyList;
        }
        this.typeArguments = _elvis;
    }

    public TypeReference(Class<?> clazz) {
        this(clazz, null);
    }

    public TypeReference(Class<?> clazz, List<TypeReference> arguments) {
        boolean _isPrimitive = clazz.isPrimitive();
        if (_isPrimitive) {
            String _name = clazz.getName();
            String _plus = "Type is primitive: " + _name;
            throw new IllegalArgumentException(_plus);
        }
        boolean _isAnonymousClass = clazz.isAnonymousClass();
        if (_isAnonymousClass) {
            String _name_1 = clazz.getName();
            String _plus_1 = "Class is anonymous: " + _name_1;
            throw new IllegalArgumentException(_plus_1);
        }
        boolean _isLocalClass = clazz.isLocalClass();
        if (_isLocalClass) {
            String _name_2 = clazz.getName();
            String _plus_2 = "Class is local: " + _name_2;
            throw new IllegalArgumentException(_plus_2);
        }
        this.packageName = clazz.getPackage().getName();
        this.simpleNames = CollectionLiterals.newArrayList();
        List<TypeReference> _elvis = null;
        if (arguments != null) {
            _elvis = arguments;
        } else {
            List _emptyList = Collections.emptyList();
            _elvis = _emptyList;
        }
        this.typeArguments = _elvis;
        Class<?> c = clazz;
        do {
            this.simpleNames.add(0, c.getSimpleName());
        } while ((c = c.getDeclaringClass()) != null);
    }

    public TypeReference(EClass clazz, ResourceSet resourceSet) {
        this(TypeReference.getQualifiedName(clazz, resourceSet));
    }

    public TypeReference(QualifiedClassName qualifiedClazzName) {
        this(qualifiedClazzName.packageName, qualifiedClazzName.className, null);
    }

    public TypeReference(EPackage epackage, ResourceSet resourceSet) {
        this(TypeReference.getQualifiedName(epackage, resourceSet));
    }

    private static String getPackageName(String qualifiedName, boolean strict) {
        boolean _equals;
        List segments = IterableExtensions.toList((Iterable)Splitter.on((String)".").split((CharSequence)qualifiedName));
        int _size = segments.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            return "";
        }
        if (strict) {
            boolean _not;
            Functions.Function1 _function;
            int _length = ((Object[])Conversions.unwrapArray((Object)segments, Object.class)).length;
            int _minus = _length - 1;
            List packageSegments = segments.subList(0, _minus);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter(packageSegments, (Functions.Function1)(_function = it -> Character.isUpperCase(it.charAt(0)))));
            boolean bl2 = _not = !_isEmpty;
            if (_not) {
                throw new IllegalArgumentException("Cannot determine the package name of '" + qualifiedName + "'. Please use the TypeReference(packageName, className) constructor");
            }
            return IterableExtensions.join(packageSegments, (CharSequence)".");
        }
        int _length_1 = ((Object[])Conversions.unwrapArray((Object)segments, Object.class)).length;
        int _minus_1 = _length_1 - 1;
        List packageSegments_1 = segments.subList(0, _minus_1);
        while (!packageSegments_1.isEmpty()) {
            boolean _isUpperCase = Character.isUpperCase(((String)IterableExtensions.last(packageSegments_1)).charAt(0));
            if (_isUpperCase) {
                List _converted_packageSegments_1 = packageSegments_1;
                int _length_2 = ((Object[])Conversions.unwrapArray(_converted_packageSegments_1, Object.class)).length;
                int _minus_2 = _length_2 - 1;
                packageSegments_1 = packageSegments_1.subList(0, _minus_2);
                continue;
            }
            return IterableExtensions.join(packageSegments_1, (CharSequence)".");
        }
        return "";
    }

    private static String getClassName(String qualifiedName, boolean strict) {
        String _xblockexpression = null;
        String packageName = TypeReference.getPackageName(qualifiedName, strict);
        String _xifexpression = null;
        boolean _isEmpty = packageName.isEmpty();
        if (_isEmpty) {
            _xifexpression = qualifiedName;
        } else {
            int _length = packageName.length();
            int _plus = _length + 1;
            _xifexpression = qualifiedName.substring(_plus, qualifiedName.length());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private static QualifiedClassName getQualifiedName(EClass clazz, ResourceSet resourceSet) {
        QualifiedClassName _xifexpression = null;
        String _nsURI = clazz.getEPackage().getNsURI();
        boolean _equals = Objects.equal((Object)_nsURI, (Object)"http://www.eclipse.org/2008/Xtext");
        if (_equals) {
            String _name = clazz.getName();
            _xifexpression = new QualifiedClassName("org.eclipse.xtext", _name);
        } else {
            QualifiedClassName _xifexpression_1 = null;
            String _nsURI_1 = clazz.getEPackage().getNsURI();
            boolean _equals_1 = Objects.equal((Object)_nsURI_1, (Object)"http://www.eclipse.org/emf/2002/Ecore");
            if (_equals_1) {
                boolean _tripleNotEquals;
                QualifiedClassName _xifexpression_2 = null;
                String _instanceTypeName = clazz.getInstanceTypeName();
                boolean bl = _tripleNotEquals = _instanceTypeName != null;
                if (_tripleNotEquals) {
                    QualifiedClassName _xblockexpression = null;
                    String itn = clazz.getInstanceTypeName();
                    String _substring = itn.substring(0, itn.lastIndexOf("."));
                    int _lastIndexOf = itn.lastIndexOf(".");
                    int _plus = _lastIndexOf + 1;
                    String _replace = itn.substring(_plus).replace("$", ".");
                    _xifexpression_2 = _xblockexpression = new QualifiedClassName(_substring, _replace);
                } else {
                    String _name_1 = clazz.getName();
                    _xifexpression_2 = new QualifiedClassName("org.eclipse.emf.ecore", _name_1);
                }
                _xifexpression_1 = _xifexpression_2;
            } else {
                String _qualifiedPackageName = GenModelUtil2.getGenClass(clazz, resourceSet).getGenPackage().getQualifiedPackageName();
                String _interfaceName = GenModelUtil2.getGenClass(clazz, resourceSet).getInterfaceName();
                _xifexpression_1 = new QualifiedClassName(_qualifiedPackageName, _interfaceName);
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private static QualifiedClassName getQualifiedName(EPackage epackage, ResourceSet resourceSet) {
        String _qualifiedPackageName = GenModelUtil2.getGenPackage(epackage, resourceSet).getQualifiedPackageName();
        String _packageInterfaceName = GenModelUtil2.getGenPackage(epackage, resourceSet).getPackageInterfaceName();
        return new QualifiedClassName(_qualifiedPackageName, _packageInterfaceName);
    }

    public String toString() {
        String _name = this.getName();
        Functions.Function1 _function = it -> it.toString();
        String _join = IterableExtensions.join(this.typeArguments, (CharSequence)"<", (CharSequence)", ", (CharSequence)">", (Functions.Function1)_function);
        return _name + _join;
    }

    public String getName() {
        String _join = IterableExtensions.join(this.simpleNames, (CharSequence)".");
        return this.packageName + "." + _join;
    }

    public String getSimpleName() {
        return (String)IterableExtensions.last(this.simpleNames);
    }

    public String getPath() {
        String _replace = this.packageName.replace(".", "/");
        String _plus = _replace + "/";
        String _head = (String)IterableExtensions.head(this.simpleNames);
        return _plus + _head;
    }

    public String getJavaPath() {
        String _path = this.getPath();
        return _path + ".java";
    }

    public String getXtendPath() {
        String _path = this.getPath();
        return _path + ".xtend";
    }

    @Pure
    public String getPackageName() {
        return this.packageName;
    }

    @Pure
    public List<String> getSimpleNames() {
        return this.simpleNames;
    }

    @Pure
    public List<TypeReference> getTypeArguments() {
        return this.typeArguments;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeReference other = (TypeReference)obj;
        if (this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName)) {
            return false;
        }
        if (this.simpleNames == null ? other.simpleNames != null : !this.simpleNames.equals(other.simpleNames)) {
            return false;
        }
        return !(this.typeArguments == null ? other.typeArguments != null : !this.typeArguments.equals(other.typeArguments));
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        result = 31 * result + (this.simpleNames == null ? 0 : this.simpleNames.hashCode());
        result = 31 * result + (this.typeArguments == null ? 0 : this.typeArguments.hashCode());
        return result;
    }

    @FinalFieldsConstructor
    public static class QualifiedClassName {
        @Accessors(value={AccessorType.PUBLIC_GETTER})
        private final String packageName;
        @Accessors(value={AccessorType.PUBLIC_GETTER})
        private final String className;

        @Pure
        public String getPackageName() {
            return this.packageName;
        }

        @Pure
        public String getClassName() {
            return this.className;
        }

        public QualifiedClassName(String packageName, String className) {
            this.packageName = packageName;
            this.className = className;
        }
    }
}

