/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import java.util.Map;
import org.eclipse.xtext.common.types.access.impl.ClassNameUtil;

public abstract class AbstractClassFinder<C> {
    protected static final ClassNotFoundException CACHED_EXCEPTION = new ClassNotFoundException();
    private final ClassLoader classLoader;
    private final ClassNameUtil classNameUtil;
    private final C nullValue;
    private final Map<String, C> cache;

    protected AbstractClassFinder(ClassLoader classLoader, C nullValue, Map<String, C> cache) {
        this.classLoader = classLoader;
        this.nullValue = nullValue;
        this.cache = cache;
        this.classNameUtil = new ClassNameUtil();
    }

    public C forName(String name) throws ClassNotFoundException {
        C result = this.cache.get(name);
        if (result != null) {
            if (result == this.nullValue) {
                throw CACHED_EXCEPTION;
            }
            return result;
        }
        try {
            result = this.forName(this.classNameUtil.normalizeClassName(name), this.classLoader);
            this.cache.put(name, result);
            return result;
        }
        catch (ClassNotFoundException e) {
            this.cache.put(name, this.nullValue);
            throw e;
        }
    }

    protected abstract C forName(String var1, ClassLoader var2) throws ClassNotFoundException;
}

