/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.core.config;

import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.emf.mwe.core.config.ConfigurationModel;
import org.eclipse.emf.mwe.core.config.FeatureNotFound;
import org.eclipse.emf.mwe.core.config.GlobalConfigurationHolder;
import org.eclipse.emf.mwe.core.container.ConditionEvaluationException;
import org.eclipse.emf.mwe.core.container.ConditionalComponent;
import org.eclipse.emf.mwe.core.issues.Issues;

public class FeatureComponent
extends ConditionalComponent {
    private String isSelected = null;
    private String isNotSelected = null;

    public FeatureComponent() {
        super("feature");
    }

    public void setIsSelected(String name) {
        this.isSelected = name;
    }

    public void setIsNotSelected(String name) {
        this.isNotSelected = name;
    }

    @Override
    public void checkConfiguration(Issues issues) throws ConfigurationException {
        super.checkConfiguration(issues);
        if (this.isSelected == null && this.isNotSelected == null) {
            issues.addError(this, "you have to specify eithre an exists or notExits.");
        }
    }

    @Override
    public boolean evaluate() {
        ConfigurationModel configuration = GlobalConfigurationHolder.getConfiguration();
        if (configuration == null) {
            throw new ConditionEvaluationException("no configuration model specified.");
        }
        if (this.isSelected != null && !configuration.featureExists(this.isSelected)) {
            throw new ConditionEvaluationException("the feature '" + this.isSelected + "' is not defined in the configuration model.");
        }
        if (this.isNotSelected != null && !configuration.featureExists(this.isNotSelected)) {
            throw new ConditionEvaluationException("the feature '" + this.isNotSelected + "' is not defined in the configuration model.");
        }
        try {
            if (this.isSelected != null && this.isNotSelected == null) {
                return configuration.isFeatureSelected(this.isSelected);
            }
            if (this.isSelected == null && this.isNotSelected != null) {
                return !configuration.isFeatureSelected(this.isNotSelected);
            }
            if (this.isSelected != null && this.isNotSelected != null) {
                return configuration.isFeatureSelected(this.isSelected) && !configuration.isFeatureSelected(this.isNotSelected);
            }
        }
        catch (FeatureNotFound cannotHappen) {
            throw new ConditionEvaluationException("exception: " + cannotHappen.getMessage());
        }
        return false;
    }

    @Override
    public String getLogMessage() {
        try {
            return "feature ( exists " + this.isSelected + " ): " + this.evaluate();
        }
        catch (ConditionEvaluationException ex) {
            return "feature ( exists " + this.isSelected + " ): cannot be evaluated; " + ex.getMessage();
        }
    }
}

