/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.internal.runtime.DevClassPathHelper;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bundles {
    private static final Logger log = LoggerFactory.getLogger(Bundles.class);

    public static List<String> getClasspathEntries(Bundle bundle) {
        log.debug("getClasspathEntries(Bundle={})", (Object)bundle);
        LinkedHashSet<String> cp = new LinkedHashSet<String>();
        if (Bundles.inDevelopmentMode()) {
            cp.addAll(Bundles.getDevClassPath(bundle.getSymbolicName()));
        }
        cp.addAll(Bundles.parseBundleClasspath(bundle));
        ArrayList<String> entries = new ArrayList<String>();
        for (String cpe : cp) {
            String entry = Bundles.getNestedJarOrDir(bundle, ".".equals(cpe) ? "/" : cpe);
            if (entry == null) continue;
            entry = new Path(entry).toOSString();
            log.debug("\tEntry:{}", (Object)entry);
            entries.add(entry);
        }
        return entries;
    }

    private static List<String> parseBundleClasspath(Bundle bundle) {
        String header = (String)bundle.getHeaders().get("Bundle-ClassPath");
        try {
            ManifestElement[] cpEntries = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)header);
            if (cpEntries != null) {
                return Arrays.stream(cpEntries).map(ManifestElement::getValue).collect(Collectors.toList());
            }
        }
        catch (BundleException ex) {
            log.warn("Could not parse bundle classpath of {}", (Object)bundle, (Object)ex);
        }
        return List.of(".");
    }

    private static String getNestedJarOrDir(Bundle bundle, String cp) {
        File file;
        URL url = bundle.getEntry(cp);
        if (url != null) {
            try {
                return FileLocator.toFileURL((URL)url).getFile();
            }
            catch (IOException ex) {
                log.warn("Could not get entry {} for bundle {}", new Object[]{cp, bundle, ex});
            }
        }
        if (Bundles.inDevelopmentMode() && (file = new File(cp)).exists() && file.isAbsolute()) {
            return file.getAbsolutePath();
        }
        log.debug("Bundle {} does not have entry {}", (Object)bundle, (Object)cp);
        return null;
    }

    public static List<String> getDevClassPath(String bundleSymbolicName) {
        return Arrays.asList(DevClassPathHelper.getDevClassPath((String)bundleSymbolicName));
    }

    public static boolean inDevelopmentMode() {
        return DevClassPathHelper.inDevelopmentMode();
    }
}

