/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.model.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.fx.ide.model.FXPlugin;
import org.eclipse.fx.ide.model.IFXCtrlClass;
import org.eclipse.fx.ide.model.IFXCtrlEventMethod;
import org.eclipse.fx.ide.model.IFXCtrlField;
import org.eclipse.fx.ide.model.internal.FXCtrlEventMethod;
import org.eclipse.fx.ide.model.internal.FXCtrlField;
import org.eclipse.fx.ide.model.internal.utils.Util;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class FXCtrlClass
implements IFXCtrlClass {
    private IJavaProject javaProject;
    private IType type;
    private Map<String, IFXCtrlEventMethod> eventMethods;
    private Map<String, IFXCtrlField> fields;
    private IFXCtrlClass superClass;

    public FXCtrlClass(IJavaProject jp, IType type) {
        this.javaProject = jp;
        this.type = type;
        try {
            String s = type.getSuperclassName();
            if (s != null) {
                s = Util.getFQNType(type, s);
                this.superClass = FXPlugin.getClassmodel().findCtrlClass(jp, jp.findType(s));
            }
        }
        catch (JavaModelException e) {
            FXPlugin.getLogger().log(1, "Unable to retrieve superclass name of '" + type.getFullyQualifiedName() + "'", (Throwable)e);
        }
    }

    @Override
    public IType getType() {
        return this.type;
    }

    IJavaProject getJavaProject() {
        return this.javaProject;
    }

    @Override
    public String getSimpleName() {
        return this.type.getElementName();
    }

    @Override
    public String getFQN() {
        return this.type.getFullyQualifiedName();
    }

    @Override
    public Map<String, IFXCtrlEventMethod> getAllEventMethods() {
        HashMap<String, IFXCtrlEventMethod> rv = new HashMap<String, IFXCtrlEventMethod>();
        if (this.superClass != null) {
            rv.putAll(this.superClass.getAllEventMethods());
        }
        rv.putAll(this.getLocalEventMethods());
        return Collections.unmodifiableMap(rv);
    }

    private Map<String, IFXCtrlEventMethod> getLocalEventMethods() {
        if (this.eventMethods == null) {
            this.eventMethods = new HashMap<String, IFXCtrlEventMethod>();
            try {
                IMethod[] iMethodArray = this.type.getMethods();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] types;
                    IMethod m = iMethodArray[n2];
                    boolean annotated = false;
                    IAnnotation[] iAnnotationArray = m.getAnnotations();
                    int n3 = iAnnotationArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IAnnotation a = iAnnotationArray[n4];
                        if (a.getElementName().endsWith("FXML")) {
                            annotated = true;
                            break;
                        }
                        ++n4;
                    }
                    if (annotated && (types = m.getParameterTypes()).length <= 1) {
                        if (types.length == 1) {
                            String erasedFQNType = Util.getFQNType((IType)m.getParent(), Signature.getTypeErasure((String)Signature.toString((String)types[0])));
                            if (FXCtrlEventMethod.isEventMethod(this.javaProject, erasedFQNType)) {
                                this.eventMethods.put(m.getElementName(), new FXCtrlEventMethod(this, m, erasedFQNType));
                            }
                        } else if (!this.eventMethods.containsKey(m.getElementName())) {
                            this.eventMethods.put(m.getElementName(), new FXCtrlEventMethod(this, m, null));
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return this.eventMethods;
    }

    @Override
    public Map<String, IFXCtrlField> getAllFields() {
        HashMap<String, IFXCtrlField> rv = new HashMap<String, IFXCtrlField>();
        if (this.superClass != null) {
            rv.putAll(this.superClass.getAllFields());
        }
        rv.putAll(this.getLocalFields());
        return Collections.unmodifiableMap(rv);
    }

    private Map<String, IFXCtrlField> getLocalFields() {
        if (this.fields == null) {
            this.fields = new HashMap<String, IFXCtrlField>();
            try {
                IField[] iFieldArray = this.type.getFields();
                int n = iFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IField f = iFieldArray[n2];
                    boolean annotated = false;
                    IAnnotation[] iAnnotationArray = f.getAnnotations();
                    int n3 = iAnnotationArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IAnnotation a = iAnnotationArray[n4];
                        if (a.getElementName().endsWith("FXML")) {
                            annotated = true;
                            break;
                        }
                        ++n4;
                    }
                    if (annotated) {
                        String erasedFQNType = Util.getFQNType((IType)f.getParent(), Signature.getTypeErasure((String)Signature.toString((String)f.getTypeSignature())));
                        FXCtrlField field = new FXCtrlField(this, f, erasedFQNType);
                        this.fields.put(f.getElementName(), field);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return this.fields;
    }
}

