/**
 * Copyright (c) 2010-2012, Mark Czotter, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Mark Czotter - initial API and implementation
 */
package org.eclipse.incquery.patternlanguage.emf.jvmmodel;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.incquery.patternlanguage.emf.jvmmodel.JavadocInferrer;
import org.eclipse.incquery.patternlanguage.emf.util.EMFJvmTypesBuilder;
import org.eclipse.incquery.patternlanguage.emf.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.jvmmodel.JvmAnnotationReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * {@link IMatchProcessor} implementation inferrer.
 * 
 * @author Mark Czotter
 */
@SuppressWarnings("all")
public class PatternMatchProcessorClassInferrer {
  @Inject
  @Extension
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  @Extension
  private JavadocInferrer _javadocInferrer;
  
  @Extension
  private JvmTypeReferenceBuilder builder;
  
  @Extension
  private JvmAnnotationReferenceBuilder annBuilder;
  
  /**
   * Infers the {@link IMatchProcessor} implementation class from a {@link Pattern}.
   */
  public JvmDeclaredType inferProcessorClass(final Pattern pattern, final boolean isPrelinkingPhase, final String processorPackageName, final JvmType matchClass, final JvmTypeReferenceBuilder builder, final JvmAnnotationReferenceBuilder annBuilder) {
    this.builder = builder;
    this.annBuilder = annBuilder;
    String _processorClassName = this._eMFPatternLanguageJvmModelInferrerUtil.processorClassName(pattern);
    final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
      public void apply(final JvmGenericType it) {
        it.setPackageName(processorPackageName);
        CharSequence _javadocProcessorClass = PatternMatchProcessorClassInferrer.this._javadocInferrer.javadocProcessorClass(pattern);
        String _string = _javadocProcessorClass.toString();
        PatternMatchProcessorClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
        it.setAbstract(true);
        EList<JvmTypeReference> _superTypes = it.getSuperTypes();
        JvmTypeReference _typeRef = PatternMatchProcessorClassInferrer.this.builder.typeRef(matchClass);
        JvmTypeReference _typeRef_1 = PatternMatchProcessorClassInferrer.this.builder.typeRef(IMatchProcessor.class, _typeRef);
        PatternMatchProcessorClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _typeRef_1);
      }
    };
    final JvmGenericType processorClass = this._eMFJvmTypesBuilder.toClass(pattern, _processorClassName, _function);
    return processorClass;
  }
  
  /**
   * Infers methods for Processor class based on the input 'pattern'.
   */
  public boolean inferProcessorClassMethods(final JvmDeclaredType processorClass, final Pattern pattern, final JvmType matchClassRef) {
    boolean _xblockexpression = false;
    {
      EList<JvmMember> _members = processorClass.getMembers();
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          JvmTypeReference _typeRef = PatternMatchProcessorClassInferrer.this.builder.typeRef(Void.TYPE);
          it.setReturnType(_typeRef);
          CharSequence _javadocProcessMethod = PatternMatchProcessorClassInferrer.this._javadocInferrer.javadocProcessMethod(pattern);
          String _string = _javadocProcessMethod.toString();
          PatternMatchProcessorClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
          it.setAbstract(true);
          EList<Variable> _parameters = pattern.getParameters();
          for (final Variable parameter : _parameters) {
            EList<JvmFormalParameter> _parameters_1 = it.getParameters();
            String _parameterName = PatternMatchProcessorClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(parameter);
            JvmTypeReference _calculateType = PatternMatchProcessorClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(parameter);
            JvmFormalParameter _parameter = PatternMatchProcessorClassInferrer.this._eMFJvmTypesBuilder.toParameter(parameter, _parameterName, _calculateType);
            PatternMatchProcessorClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
          }
        }
      };
      JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "process", null, _function);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
      EList<JvmMember> _members_1 = processorClass.getMembers();
      final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          JvmTypeReference _typeRef = PatternMatchProcessorClassInferrer.this.builder.typeRef(Void.TYPE);
          it.setReturnType(_typeRef);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternMatchProcessorClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternMatchProcessorClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmTypeReference _typeRef_1 = PatternMatchProcessorClassInferrer.this.builder.typeRef(matchClassRef);
          JvmFormalParameter _parameter = PatternMatchProcessorClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "match", _typeRef_1);
          PatternMatchProcessorClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("process(");
              {
                EList<Variable> _parameters = pattern.getParameters();
                boolean _hasElements = false;
                for(final Variable p : _parameters) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder.appendImmediate(", ", "");
                  }
                  _builder.append("match.");
                  String _terMethodName = PatternMatchProcessorClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.getterMethodName(p);
                  _builder.append(_terMethodName, "");
                  _builder.append("()");
                }
              }
              _builder.append(");");
              _builder.newLineIfNotEmpty();
            }
          };
          PatternMatchProcessorClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_1 = this._eMFJvmTypesBuilder.toMethod(pattern, "process", null, _function_1);
      _xblockexpression = this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
    }
    return _xblockexpression;
  }
}
