/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.ui.quickfix;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.XImportSection;
import org.eclipse.incquery.tooling.core.project.ProjectGenerationHelper;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.ui.quickfix.XbaseQuickfixProvider;

public class EMFPatternLanguageQuickfixProvider
extends XbaseQuickfixProvider {
    @Fix(value="org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.identifier_as_keyword")
    public void escapeKeywordAsIdentifier(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Prefix Identifier", "Adds a ^ prefix to the identifier", null, new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument document = context.getXtextDocument();
                document.replace(issue.getOffset().intValue(), 0, "^");
            }
        });
    }

    @Fix(value="org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.missing_parameter_type")
    public void inferMissingParameterType(final Issue issue, IssueResolutionAcceptor acceptor) {
        String[] stringArray = issue.getData();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            final String data = stringArray[n2];
            acceptor.accept(issue, "Insert type '" + data + "'", "Declares the inferred type " + data + " for the variable", null, new IModification(){

                public void apply(IModificationContext context) throws Exception {
                    IXtextDocument document = context.getXtextDocument();
                    document.replace(issue.getOffset() + issue.getLength(), 0, " : " + data);
                }
            });
            ++n2;
        }
    }

    @Fix(value="org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.missing_import")
    public void addMissingPackageImport(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add missing import", "Add missing import", null, new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument document = context.getXtextDocument();
                Integer offset = (Integer)document.readOnly((IUnitOfWork)new IUnitOfWork<Integer, XtextResource>(){

                    public Integer exec(XtextResource state) {
                        XImportSection importSection = (XImportSection)Iterators.find((Iterator)state.getAllContents(), (Predicate)Predicates.instanceOf(XImportSection.class), null);
                        ICompositeNode node = NodeModelUtils.getNode((EObject)importSection);
                        return node.getTotalEndOffset();
                    }
                });
                if (offset != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("\n");
                    sb.append("import \"");
                    sb.append(issue.getData()[0]);
                    sb.append("\"");
                    document.replace(offset.intValue(), 0, sb.toString());
                }
            }
        });
    }

    @Fix(value="org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.missing_import_dependency")
    public void addDependency(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add dependency", "Add the required bundle to the manifest.mf file.", null, new IModification(){

            public void apply(IModificationContext context) throws CoreException, BadLocationException {
                URI uriToProblem = issue.getUriToProblem();
                if (uriToProblem.isPlatform()) {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IFile file = root.getFile((IPath)new Path(uriToProblem.toPlatformString(true)));
                    if (file.exists() && !file.isReadOnly()) {
                        ProjectGenerationHelper.ensureBundleDependencies((IProject)file.getProject(), Arrays.asList(issue.getData()));
                    }
                    IXtextDocument document = context.getXtextDocument();
                    document.replace(issue.getOffset().intValue(), 1, document.get(issue.getOffset().intValue(), 1));
                }
            }
        });
    }
}

