/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.pcsc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import org.eclipse.keyple.plugin.pcsc.PcscReader;
import org.eclipse.keyple.seproxy.exception.KeypleBaseException;
import org.eclipse.keyple.seproxy.exception.KeypleReaderException;
import org.eclipse.keyple.seproxy.plugin.AbstractObservableReader;
import org.eclipse.keyple.seproxy.plugin.AbstractThreadedObservablePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PcscPlugin
extends AbstractThreadedObservablePlugin {
    private static final Logger logger = LoggerFactory.getLogger(PcscPlugin.class);
    private static final long SETTING_THREAD_TIMEOUT_DEFAULT = 1000L;
    private static final PcscPlugin uniqueInstance = new PcscPlugin();
    private static TerminalFactory factory;
    private boolean logging = false;

    private PcscPlugin() {
        super("PcscPlugin");
    }

    public static PcscPlugin getInstance() {
        return uniqueInstance;
    }

    public Map<String, String> getParameters() {
        return null;
    }

    public void setParameter(String key, String value) throws IllegalArgumentException, KeypleBaseException {
    }

    public PcscPlugin setLogging(boolean logging) {
        this.logging = logging;
        return this;
    }

    protected SortedSet<String> fetchNativeReadersNames() throws KeypleReaderException {
        ConcurrentSkipListSet<String> nativeReadersNames = new ConcurrentSkipListSet<String>();
        CardTerminals terminals = this.getCardTerminals();
        try {
            for (CardTerminal term : terminals.list()) {
                nativeReadersNames.add(term.getName());
            }
        }
        catch (CardException e) {
            if (e.getCause().toString().contains("SCARD_E_NO_READERS_AVAILABLE")) {
                logger.trace("No reader available.");
            }
            logger.trace("[{}] fetchNativeReadersNames => Terminal list is not accessible. Exception: {}", (Object)this.getName(), (Object)e.getMessage());
            throw new KeypleReaderException("Could not access terminals list", (Throwable)e);
        }
        return nativeReadersNames;
    }

    protected SortedSet<AbstractObservableReader> initNativeReaders() throws KeypleReaderException {
        ConcurrentSkipListSet<AbstractObservableReader> nativeReaders = new ConcurrentSkipListSet<AbstractObservableReader>();
        CardTerminals terminals = this.getCardTerminals();
        try {
            for (CardTerminal term : terminals.list()) {
                nativeReaders.add((AbstractObservableReader)new PcscReader(this.getName(), term));
            }
        }
        catch (CardException e) {
            if (e.getCause().toString().contains("SCARD_E_NO_READERS_AVAILABLE")) {
                logger.trace("No reader available.");
            }
            logger.trace("[{}] Terminal list is not accessible. Exception: {}", (Object)this.getName(), (Object)e.getMessage());
            throw new KeypleReaderException("Could not access terminals list", (Throwable)e);
        }
        return nativeReaders;
    }

    protected AbstractObservableReader fetchNativeReader(String name) throws KeypleReaderException {
        for (AbstractObservableReader reader : this.readers) {
            if (!reader.getName().equals(name)) continue;
            return reader;
        }
        PcscReader reader = null;
        CardTerminals terminals = this.getCardTerminals();
        ArrayList terminalList = new ArrayList();
        try {
            for (CardTerminal term : terminals.list()) {
                if (!term.getName().equals(name)) continue;
                reader = new PcscReader(this.getName(), term);
            }
        }
        catch (CardException e) {
            logger.trace("[{}] Terminal list is not accessible. Exception: {}", (Object)this.getName(), (Object)e.getMessage());
            throw new KeypleReaderException("Could not access terminals list", (Throwable)e);
        }
        if (reader == null) {
            throw new KeypleReaderException("Reader " + name + " not found!");
        }
        return reader;
    }

    private CardTerminals getCardTerminals() {
        try {
            Class<?> pcscterminal = null;
            pcscterminal = Class.forName("sun.security.smartcardio.PCSCTerminals");
            Field contextId = pcscterminal.getDeclaredField("contextId");
            contextId.setAccessible(true);
            if (contextId.getLong(pcscterminal) != 0L) {
                Class<?> pcsc = Class.forName("sun.security.smartcardio.PCSC");
                Method SCardEstablishContext = pcsc.getDeclaredMethod("SCardEstablishContext", Integer.TYPE);
                SCardEstablishContext.setAccessible(true);
                Field SCARD_SCOPE_USER = pcsc.getDeclaredField("SCARD_SCOPE_USER");
                SCARD_SCOPE_USER.setAccessible(true);
                long newId = (Long)SCardEstablishContext.invoke(pcsc, SCARD_SCOPE_USER.getInt(pcsc));
                contextId.setLong(pcscterminal, newId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (factory == null) {
            factory = TerminalFactory.getDefault();
        }
        CardTerminals terminals = factory.terminals();
        return terminals;
    }
}

